/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.log4j.Logger;

abstract class AbstractJson {
    private static final Logger LOG = Logger.getLogger(AbstractJson.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    protected AbstractJson() {
    }

    private ObjectMapper getMapper() {
        return mapper;
    }

    public String toJson() throws JsonProcessingException {
        return this.getMapper().writeValueAsString((Object)this);
    }

    public String toPrettyJson() throws JsonProcessingException {
        return this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    static {
        try {
            SimpleModule module = new SimpleModule();
            mapper.registerModule((Module)module);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"this should never happen", t);
        }
    }
}

