/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.jsondeserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.cismet.verdis.server.json.NachrichtAnhangJson;
import de.cismet.verdis.server.json.NachrichtJson;
import de.cismet.verdis.server.json.NachrichtParameterJson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class NachrichtDeserializer
extends StdDeserializer<NachrichtJson> {
    private final ObjectMapper objectMapper;

    public NachrichtDeserializer(ObjectMapper objectMapper) {
        super(NachrichtJson.class);
        this.objectMapper = objectMapper;
    }

    public NachrichtJson deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        ObjectNode on = (ObjectNode)jp.readValueAsTree();
        String identifier = on.has("identifier") ? on.get("identifier").textValue() : null;
        Boolean draft = on.has("draft") ? Boolean.valueOf(on.get("draft").asBoolean()) : null;
        NachrichtJson.Typ typ = on.has("typ") ? NachrichtJson.Typ.valueOf(on.get("typ").textValue()) : null;
        Date timestamp = on.has("timestamp") ? new Date(on.get("timestamp").longValue()) : null;
        Integer order = on.has("order") ? Integer.valueOf(on.get("order").asInt()) : null;
        String absender = on.has("absender") ? on.get("absender").textValue() : null;
        String nachricht = on.has("nachricht") ? on.get("nachricht").textValue() : null;
        NachrichtParameterJson nachrichtenParameter = on.has("nachrichtenParameter") ? (NachrichtParameterJson)this.objectMapper.treeToValue((TreeNode)on.get("nachrichtenParameter"), NachrichtParameterJson.class) : null;
        ArrayList<NachrichtAnhangJson> anhang = new ArrayList<NachrichtAnhangJson>();
        if (on.has("anhang") && on.get("anhang").isArray()) {
            Iterator iterator = on.get("anhang").iterator();
            while (iterator.hasNext()) {
                anhang.add((NachrichtAnhangJson)this.objectMapper.treeToValue((TreeNode)iterator.next(), NachrichtAnhangJson.class));
            }
        }
        return new NachrichtJson(identifier, draft, typ, timestamp, order, nachricht, nachrichtenParameter, absender, anhang);
    }
}

