/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.jsondeserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.cismet.verdis.server.json.StacOptionsDurationJson;
import de.cismet.verdis.server.json.StacOptionsJson;
import java.io.IOException;

public class StacOptionsDeserializer
extends StdDeserializer<StacOptionsJson> {
    private final ObjectMapper objectMapper;

    public StacOptionsDeserializer(ObjectMapper objectMapper) {
        super(StacOptionsJson.class);
        this.objectMapper = objectMapper;
    }

    public StacOptionsJson deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        StacOptionsDurationJson duration;
        ObjectNode on = (ObjectNode)jp.readValueAsTree();
        Integer kassenzeichenid = on.has("kassenzeichenid") ? Integer.valueOf(on.get("kassenzeichenid").asInt()) : null;
        String creatorUserName = on.has("creatorUserName") ? on.get("creatorUserName").asText() : null;
        StacOptionsDurationJson stacOptionsDurationJson = duration = on.has("duration") ? (StacOptionsDurationJson)this.objectMapper.treeToValue((TreeNode)on.get("duration"), StacOptionsDurationJson.class) : null;
        if (kassenzeichenid == null) {
            throw new RuntimeException("invalid StacOptionsJson: kassenzeichenid is missing");
        }
        return new StacOptionsJson(kassenzeichenid, creatorUserName, duration);
    }
}

