/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;

public class AenderungsanfrageSearchStatement
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AenderungsanfrageSearchStatement.class);
    private Integer stacId;
    private Integer kassenzeichennummer;
    private String clerk;
    private Boolean active;
    private Set<String> statii;
    private SearchMode searchMode = SearchMode.AND;
    private final SearchInfo searchInfo = new SearchInfo();

    public AenderungsanfrageSearchStatement() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for Aenderungsanfrage");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("stacId");
        searchParameterInfo.setType(Type.INTEGER);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        searchParameterInfo.setKey("kassenzeichenNummer");
        searchParameterInfo.setType(Type.INTEGER);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        searchParameterInfo.setKey("user");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        searchParameterInfo.setKey("active");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        searchParameterInfo.setKey("statii");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.NODE);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public AenderungsanfrageSearchStatement(Integer stacId) {
        this();
        this.stacId = stacId;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            String where;
            ArrayList<String> froms = new ArrayList<String>();
            ArrayList<String> wheres = new ArrayList<String>();
            boolean joinStacId = false;
            boolean joinStatus = false;
            boolean joinKassenzeichen = false;
            if (this.stacId != null) {
                wheres.add("a." + "stac_id" + " = " + this.stacId + "");
                joinStacId = true;
            }
            if (this.clerk != null) {
                wheres.add("a." + "clerk_username" + " LIKE '" + this.clerk + "'");
            }
            if (this.active != null) {
                joinStatus = true;
                if (Boolean.TRUE.equals(this.active)) {
                    wheres.add("s." + "schluessel" + " NOT LIKE '" + (Object)((Object)AenderungsanfrageUtils.Status.ARCHIVED) + "'");
                } else {
                    wheres.add("s." + "schluessel" + " LIKE '" + (Object)((Object)AenderungsanfrageUtils.Status.ARCHIVED) + "'");
                }
            }
            if (this.kassenzeichennummer != null) {
                joinKassenzeichen = true;
                wheres.add("k." + "kassenzeichennummer8" + " = " + this.kassenzeichennummer);
            }
            froms.add("aenderungsanfrage" + " AS a");
            if (joinStacId) {
                froms.add("cs_stac ON a." + "stac_id" + " = cs_stac.id");
            }
            if (joinStatus) {
                froms.add("aenderungsanfrage_status" + " AS s ON a." + "status" + " = s." + "id");
            }
            if (joinKassenzeichen) {
                froms.add("kassenzeichen" + " AS k ON a." + "kassenzeichen_nummer" + " = k." + "kassenzeichennummer8");
            }
            String from = String.join((CharSequence)" LEFT JOIN ", froms);
            if (wheres.isEmpty()) {
                where = "WHERE true";
            } else {
                switch (this.searchMode) {
                    case AND: {
                        wheres.add("TRUE");
                        where = "WHERE " + String.join((CharSequence)" AND ", wheres);
                        break;
                    }
                    case OR: {
                        wheres.add("FALSE");
                        where = "WHERE " + String.join((CharSequence)" OR ", wheres);
                        break;
                    }
                    default: {
                        where = "WHERE false";
                    }
                }
            }
            String cidSubQuery = "SELECT id FROM cs_class WHERE table_name ILIKE '" + "aenderungsanfrage" + "'";
            String query = "SELECT (" + cidSubQuery + ") as cid, a.id as oid FROM " + from + " " + where + " ORDER BY a." + "timestamp" + " DESC";
            MetaService ms = (MetaService)this.getActiveLocalServers().get("VERDIS_GRUNDIS");
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            ArrayList searchResult = ms.performCustomSearch(query + ";");
            LOG.info((Object)query);
            for (ArrayList al : searchResult) {
                result.add(new MetaObjectNode("VERDIS_GRUNDIS", ((Integer)al.get(1)).intValue(), ((Integer)al.get(0)).intValue(), "", null, null));
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"problem during Aenderungsanfrage search", (Throwable)ex);
            return null;
        }
    }

    public Integer getStacId() {
        return this.stacId;
    }

    public void setStacId(Integer stacId) {
        this.stacId = stacId;
    }

    public Integer getKassenzeichennummer() {
        return this.kassenzeichennummer;
    }

    public void setKassenzeichennummer(Integer kassenzeichennummer) {
        this.kassenzeichennummer = kassenzeichennummer;
    }

    public String getClerk() {
        return this.clerk;
    }

    public void setClerk(String clerk) {
        this.clerk = clerk;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Set<String> getStatii() {
        return this.statii;
    }

    public void setStatii(Set<String> statii) {
        this.statii = statii;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public static enum SearchMode {
        AND,
        OR;

    }
}

