/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BeschreibungLightweightSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BeschreibungLightweightSearch.class);
    private static final String TABLE__FLAECHENBESCHREIUNG = "flaechenbeschreibung";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchInfo searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("dachflaeche", Type.BOOLEAN), new MySearchParameterInfo("representationPattern", Type.STRING, true), new MySearchParameterInfo("representationFields", Type.STRING, true)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    private Boolean dachflaeche;
    private String representationPattern;
    private String[] representationFields;

    public BeschreibungLightweightSearch() {
    }

    public BeschreibungLightweightSearch(String representationPattern, String[] representationFields) {
        this();
        this.setRepresentationPattern(representationPattern);
        this.setRepresentationFields(representationFields);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        Boolean dachflaeche = this.getDachflaeche();
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("VERDIS_GRUNDIS");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'VERDIS_GRUNDIS'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'VERDIS_GRUNDIS'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'VERDIS_GRUNDIS'");
        }
        ArrayList<String> conditions = new ArrayList<String>();
        if (dachflaeche != null) {
            conditions.add(String.format("dachflaeche is %s", dachflaeche.toString()));
        }
        String query = "SELECT id, beschreibung FROM flaechenbeschreibung" + (conditions.isEmpty() ? "" : " wHERE " + String.join((CharSequence)" AND ", conditions) + " ORDER BY beschreibung");
        try {
            MetaClass mc = CidsBean.getMetaClassFromTableName((String)"VERDIS_GRUNDIS", (String)TABLE__FLAECHENBESCHREIUNG, (ConnectionContext)this.getConnectionContext());
            if (this.getRepresentationPattern() != null) {
                return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getRepresentationPattern()));
            }
            return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields()));
        }
        catch (Exception ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public Boolean getDachflaeche() {
        return this.dachflaeche;
    }

    public void setDachflaeche(Boolean dachflaeche) {
        this.dachflaeche = dachflaeche;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }
}

