/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StacInfoSearchStatement
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(StacInfoSearchStatement.class);
    private static final String FIELD_KASSENZEICHENID = "kassenzeichenid";
    private static final String QUERY_TEMPLATE_KASSENZEICHENID = "SELECT id, base_login_name, expiration, stac_options FROM cs_stac WHERE stac_options ilike '%%\"kassenzeichenid\":%d%%'";
    private static final String QUERY_TEMPLATE_STACID = "SELECT id, base_login_name, expiration, stac_options FROM cs_stac WHERE id = %d";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchBy searchBy;
    private Integer kassenzeichenId = null;
    private Integer stacId = null;

    public StacInfoSearchStatement(SearchBy searchBy) {
        this.searchBy = searchBy;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setKassenzeichenId(Integer kassenzeichenId) {
        this.kassenzeichenId = kassenzeichenId;
    }

    public void setStacId(Integer stacId) {
        this.stacId = stacId;
    }

    public Collection<Map> performServerSearch() {
        try {
            String sql = SearchBy.KASSENZEICHEN_ID.equals((Object)this.searchBy) ? String.format(QUERY_TEMPLATE_KASSENZEICHENID, this.kassenzeichenId) : String.format(QUERY_TEMPLATE_STACID, this.stacId);
            MetaService ms = (MetaService)this.getActiveLocalServers().get("VERDIS_GRUNDIS");
            ArrayList result = ms.performCustomSearch(sql, this.connectionContext);
            ArrayList<Map> aln = new ArrayList<Map>();
            for (ArrayList al : result) {
                Integer id = (Integer)al.get(0);
                String baseLoginName = (String)al.get(1);
                Timestamp expiration = (Timestamp)al.get(2);
                String stacOptions = (String)al.get(3);
                Map stacOptionsMap = (Map)OBJECT_MAPPER.readValue(stacOptions, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (SearchBy.KASSENZEICHEN_ID.equals((Object)this.searchBy) && (!stacOptionsMap.containsKey(FIELD_KASSENZEICHENID) || !this.kassenzeichenId.equals(stacOptionsMap.get(FIELD_KASSENZEICHENID)))) continue;
                HashMap<Fields, Object> objectArray = new HashMap<Fields, Object>();
                objectArray.put(Fields.ID, id);
                objectArray.put(Fields.BASE_LOGIN_NAME, baseLoginName);
                objectArray.put(Fields.EXPIRATION, expiration);
                objectArray.put(Fields.STAC_OPTIONS_JSON, stacOptionsMap);
                aln.add(objectArray);
            }
            return aln;
        }
        catch (Exception ex) {
            LOG.error((Object)"problem during search", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static enum Fields {
        ID,
        BASE_LOGIN_NAME,
        EXPIRATION,
        STAC_OPTIONS_JSON;

    }

    public static enum SearchBy {
        STAC_ID,
        KASSENZEICHEN_ID;

    }
}

