/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class VerdisFortfuehrungItemSearch
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(VerdisFortfuehrungItemSearch.class);
    public static int FIELD_ID = 0;
    public static int FIELD_FFN = 1;
    public static int FIELD_ANLASSNAME = 2;
    public static int FIELD_BEGINN = 3;
    public static int FIELD_FS_ALT = 4;
    public static int FIELD_FS_NEU = 5;
    public static int FIELD_GEOFIELD = 6;
    public static int FIELD_FLURSTUECK_ID = 7;
    public static int FIELD_FORTFUEHRUNG_ID = 8;
    private Date fromDate = null;
    private Date toDate = null;

    public VerdisFortfuehrungItemSearch(Date fromDate, Date toDate) {
        this.setFromDate(fromDate);
        this.setToDate(toDate);
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    private void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    private void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Collection performServerSearch() {
        ArrayList<Object[]> items = new ArrayList<Object[]>();
        String query = "SELECT lookup_alkis_ffn.id AS id , lookup_alkis_ffn.ffn AS ffn , lookup_ffn_anlassarten.anl_bezeichnung AS anlass_name , to_date(lookup_alkis_ffn.beginn, 'DD-Mon-YY') AS beginn_date , flurstueckskennzeichen_alt AS fs_alt , flurstueckskennzeichen_neu AS fs_neu , st_asText(flurstueck.umschreibendes_rechteck) AS geo_field , flurstueck.id AS flurstueck_id FROM lookup_alkis_ffn LEFT JOIN lookup_ffn_anlassarten ON '\\\"' || lookup_ffn_anlassarten.anl_ffn || '\\\"' = lookup_alkis_ffn.anl_ffn LEFT JOIN flurstueck ON lookup_alkis_ffn.ffn = flurstueck.fortfuehrungsnummer WHERE flurstueck.umschreibendes_rechteck IS NOT NULL AND to_date(lookup_alkis_ffn.beginn, 'DD-Mon-YY') >= '" + this.fromDate + "' AND to_date(lookup_alkis_ffn.beginn, 'DD-Mon-YY') <= '" + this.toDate + "' ORDER BY lookup_alkis_ffn.ffn ASC;";
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        try {
            for (ArrayList fields : metaService.performCustomSearch(query)) {
                String queryFF = "SELECT id FROM fortfuehrung WHERE alkis_ffn Like '" + (String)fields.get(1) + "';";
                MetaService metaServiceFF = (MetaService)this.getActiveLocalServers().get("VERDIS_GRUNDIS");
                Integer ffId = null;
                Iterator iterator = metaServiceFF.performCustomSearch(queryFF).iterator();
                if (iterator.hasNext()) {
                    ArrayList fieldsFF = (ArrayList)iterator.next();
                    ffId = (Integer)fieldsFF.get(0);
                }
                items.add(new Object[]{(Integer)fields.get(FIELD_ID), (String)fields.get(FIELD_FFN), (String)fields.get(FIELD_ANLASSNAME), (Date)fields.get(FIELD_BEGINN), (String)fields.get(FIELD_FS_ALT), (String)fields.get(FIELD_FS_NEU), (String)fields.get(FIELD_GEOFIELD), (Integer)fields.get(FIELD_FLURSTUECK_ID), ffId});
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"problem fortfuehrung item search", (Throwable)ex);
        }
        return items;
    }
}

