/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.startup;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.DomainServerStartupHook;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserGroup;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import de.cismet.verdis.server.utils.VerdisServerResources;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class VerdisServerStartupHook
implements DomainServerStartupHook {
    private static final Logger LOG = Logger.getLogger((String)VerdisServerStartupHook.class.getName());
    private static final String PREPARED_STATEMENT__DELETE_OLD_STACS = "DELETE FROM cs_stac WHERE expiration < now()";
    private static final String PREPARED_STATEMENT__DELETE_OLD_HISTORY = "DELETE FROM cs_history WHERE valid_from < (SELECT now() - interval '3 years')";

    public void domainServerStarted() {
        this.loadAllServerResources();
        new Thread(new Runnable(){

            @Override
            public void run() {
                DomainServerImpl domainServer = null;
                while (domainServer == null) {
                    domainServer = DomainServerImpl.getServerInstance();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                VerdisServerStartupHook.this.archiveOldAenderungsanfragen(domainServer);
                VerdisServerStartupHook.this.deleteOldHistory(domainServer);
            }
        }){}.start();
    }

    public String getDomain() {
        return "VERDIS_GRUNDIS";
    }

    public void loadAllServerResources() {
        boolean error = false;
        for (VerdisServerResources verdisServerResource : VerdisServerResources.values()) {
            try {
                ServerResourcesLoader.getInstance().load(verdisServerResource.getValue());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while loading resource from the resources base path.", (Throwable)ex);
                error = true;
            }
        }
        if (error) {
            LOG.error((Object)"!!! CAUTION !!! Not all server resources could be loaded !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldStacs(DomainServerImpl domainServer) {
        Connection connection = null;
        try {
            connection = domainServer.getConnectionPool().getConnection();
            PreparedStatement ps = connection.prepareStatement(PREPARED_STATEMENT__DELETE_OLD_STACS);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (connection != null) {
                domainServer.getConnectionPool().releaseDbConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldHistory(DomainServerImpl domainServer) {
        Connection connection = null;
        try {
            connection = domainServer.getConnectionPool().getConnection();
            PreparedStatement ps = connection.prepareStatement(PREPARED_STATEMENT__DELETE_OLD_HISTORY);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (connection != null) {
                domainServer.getConnectionPool().releaseDbConnection(connection);
            }
        }
    }

    private void archiveOldAenderungsanfragen(DomainServerImpl domainServer) {
        ConnectionContext connectionContext = ConnectionContext.createDeprecated();
        User user = new User(-1, "StartupHook", "VERDIS_GRUNDIS");
        user.setPotentialUserGroups(Arrays.asList(new UserGroup(-1, "VORN_Schreiben_KA", "VERDIS_GRUNDIS")));
        AenderungsanfrageUtils.getInstance();
        AenderungsanfrageUtils.archiveOldAenderungsanfragen(user, (MetaService)domainServer, connectionContext);
    }
}

