/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.utils;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.verdis.server.json.AenderungsanfrageJson;
import de.cismet.verdis.server.json.AenderungsanfrageResultJson;
import de.cismet.verdis.server.json.ContactInfoJson;
import de.cismet.verdis.server.json.ContactInfosJson;
import de.cismet.verdis.server.json.FlaecheAenderungJson;
import de.cismet.verdis.server.json.FlaecheAnschlussgradJson;
import de.cismet.verdis.server.json.FlaecheFlaechenartJson;
import de.cismet.verdis.server.json.FlaechePruefungJson;
import de.cismet.verdis.server.json.MessageConfigJson;
import de.cismet.verdis.server.json.NachrichtAnhangJson;
import de.cismet.verdis.server.json.NachrichtJson;
import de.cismet.verdis.server.json.NachrichtParameterAnschlussgradJson;
import de.cismet.verdis.server.json.NachrichtParameterFlaechenartJson;
import de.cismet.verdis.server.json.NachrichtParameterGroesseJson;
import de.cismet.verdis.server.json.NachrichtParameterJson;
import de.cismet.verdis.server.json.NachrichtParameterStatusJson;
import de.cismet.verdis.server.json.NachrichtSystemJson;
import de.cismet.verdis.server.json.PruefungAnschlussgradJson;
import de.cismet.verdis.server.json.PruefungFlaechenartJson;
import de.cismet.verdis.server.json.PruefungGroesseJson;
import de.cismet.verdis.server.jsondeserializer.AenderungsanfrageDeserializer;
import de.cismet.verdis.server.jsondeserializer.AenderungsanfrageResultDeserializer;
import de.cismet.verdis.server.jsondeserializer.FlaecheAenderungDeserializer;
import de.cismet.verdis.server.jsondeserializer.FlaecheAnschlussgradDeserializer;
import de.cismet.verdis.server.jsondeserializer.FlaecheFlaechenartDeserializer;
import de.cismet.verdis.server.jsondeserializer.FlaechePruefungDeserializer;
import de.cismet.verdis.server.jsondeserializer.NachrichtAnhangDeserializer;
import de.cismet.verdis.server.jsondeserializer.NachrichtDeserializer;
import de.cismet.verdis.server.jsondeserializer.NachrichtParameterDeserializer;
import de.cismet.verdis.server.jsondeserializer.PruefungAnschlussgradDeserializer;
import de.cismet.verdis.server.jsondeserializer.PruefungFlaechenartDeserializer;
import de.cismet.verdis.server.jsondeserializer.PruefungGroesseDeserializer;
import de.cismet.verdis.server.search.AenderungsanfrageSearchStatement;
import de.cismet.verdis.server.search.AenderungsanfrageStatusSearchStatement;
import de.cismet.verdis.server.utils.AenderungsanfrageConf;
import de.cismet.verdis.server.utils.StacEntry;
import de.cismet.verdis.server.utils.StacUtils;
import de.cismet.verdis.server.utils.VerdisServerResources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.geojson.Feature;
import org.geojson.GeoJsonObject;

public class AenderungsanfrageUtils {
    private static final Logger LOG = Logger.getLogger(AenderungsanfrageUtils.class);
    private static final Comparator<NachrichtJson> NACHRICHTEN_TIMEORDER_COMPARATOR = new Comparator<NachrichtJson>(){

        @Override
        public int compare(NachrichtJson o1, NachrichtJson o2) {
            Integer r2;
            Date t1 = o1 != null ? o1.getTimestamp() : null;
            Date t2 = o2 != null ? o2.getTimestamp() : null;
            Integer r1 = o1 != null ? o1.getOrder() : null;
            Integer n = r2 = o2 != null ? o2.getOrder() : null;
            if (!Objects.equals(t1, t2)) {
                return ObjectUtils.compare((Comparable)t1, (Comparable)t2);
            }
            if (!Objects.equals(r1, r2)) {
                return ObjectUtils.compare((Comparable)r1, (Comparable)r2);
            }
            return 0;
        }
    };
    public static final String CMDREPLACER_CLERK_EMAIL = "{CLERK_MAIL}";
    public static final String CMDREPLACER_CITIZEN_EMAIL = "{CITIZEN_MAIL}";
    public static final String CMDREPLACER_TOPIC = "{TOPIC}";
    public static final String CMDREPLACER_MESSAGE = "{MESSAGE}";
    public static final String DEFAULT_CMDTEMPLATE = "sendEmail -s   smtp.wuppertal-intra.de -f   regengeld@stadt.wuppertal.de -t   \"{CITIZEN_MAIL}\" -bcc \"{CLERK_MAIL}\" -u   \"{TOPIC}\" -m   \"{MESSAGE}\"";
    public static final String MESSAGETYPE_MAILVERIFICATION = "MAILVERIFICATION";
    public static final String MESSAGETYPE_MAILCONFIRMATION = "MAILCONFIRMATION";
    public static final String MESSAGETYPE_NOTIFY = "NOTIFY";
    public static final String MESSAGETYPE_SUBMISSION = "SUBMISSION";
    private static final String CONFIG_JSON_FORMAT = "config.%s.json";
    private static final String TEMPLATEREPLACER_KASSENZEICHEN = "{KASSENZEICHEN}";
    private static final String TEMPLATEREPLACER_CODE = "{CODE}";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private boolean unitTestContext = false;
    private final Map<Integer, EmailVerification> emailVerificationMap = new HashMap<Integer, EmailVerification>();

    private AenderungsanfrageUtils() {
        try {
            SimpleModule module = new SimpleModule();
            module.addDeserializer(PruefungGroesseJson.class, (JsonDeserializer)new PruefungGroesseDeserializer(MAPPER));
            module.addDeserializer(PruefungFlaechenartJson.class, (JsonDeserializer)new PruefungFlaechenartDeserializer(MAPPER));
            module.addDeserializer(PruefungAnschlussgradJson.class, (JsonDeserializer)new PruefungAnschlussgradDeserializer(MAPPER));
            module.addDeserializer(NachrichtParameterJson.class, (JsonDeserializer)new NachrichtParameterDeserializer(MAPPER));
            module.addDeserializer(PruefungGroesseJson.class, (JsonDeserializer)new PruefungGroesseDeserializer(MAPPER));
            module.addDeserializer(FlaechePruefungJson.class, (JsonDeserializer)new FlaechePruefungDeserializer(MAPPER));
            module.addDeserializer(FlaecheAenderungJson.class, (JsonDeserializer)new FlaecheAenderungDeserializer(MAPPER));
            module.addDeserializer(FlaecheAnschlussgradJson.class, (JsonDeserializer)new FlaecheAnschlussgradDeserializer(MAPPER));
            module.addDeserializer(FlaecheFlaechenartJson.class, (JsonDeserializer)new FlaecheFlaechenartDeserializer(MAPPER));
            module.addDeserializer(NachrichtAnhangJson.class, (JsonDeserializer)new NachrichtAnhangDeserializer(MAPPER));
            module.addDeserializer(NachrichtJson.class, (JsonDeserializer)new NachrichtDeserializer(MAPPER));
            module.addDeserializer(AenderungsanfrageJson.class, (JsonDeserializer)new AenderungsanfrageDeserializer(MAPPER));
            module.addDeserializer(AenderungsanfrageResultJson.class, (JsonDeserializer)new AenderungsanfrageResultDeserializer(MAPPER));
            MAPPER.registerModule((Module)module);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"this should never happen", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEmail(Integer kassenzeichen, String email) {
        Map<Integer, EmailVerification> map = this.emailVerificationMap;
        synchronized (map) {
            this.emailVerificationMap.remove(kassenzeichen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addEmailVerification(Integer kassenzeichen, String email) {
        if (email != null) {
            String code = RandomStringUtils.randomAlphanumeric((int)6);
            Map<Integer, EmailVerification> map = this.emailVerificationMap;
            synchronized (map) {
                this.emailVerificationMap.put(kassenzeichen, new EmailVerification(email, code));
            }
            return code;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmailVerification getEmailVerification(Integer kassenzeichen) {
        Map<Integer, EmailVerification> map = this.emailVerificationMap;
        synchronized (map) {
            return this.emailVerificationMap.get(kassenzeichen);
        }
    }

    private static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static AenderungsanfrageConf getConfFromServerResource() throws Exception {
        Properties properties = ServerResourcesLoader.getInstance().loadProperties(VerdisServerResources.AENDERUNTSANFRAGE.getValue());
        return new AenderungsanfrageConf(properties);
    }

    private String createIdentifier(NachrichtJson nachricht) throws Exception {
        if (this.unitTestContext) {
            return nachricht != null ? DigestUtils.md5Hex((String)nachricht.toJson()) : null;
        }
        return UUID.randomUUID().toString();
    }

    private List<NachrichtJson> processNachrichten(List<NachrichtJson> nachrichtenOrig, List<NachrichtJson> nachrichtenNew, Boolean citizenOrClerk, String username, Date timestamp) throws Exception {
        boolean isOwnMessage;
        boolean isCitizen = Boolean.TRUE.equals(citizenOrClerk);
        boolean isClerk = Boolean.FALSE.equals(citizenOrClerk);
        ArrayList<NachrichtJson> nachrichtenProcessed = new ArrayList<NachrichtJson>();
        HashMap<String, NachrichtJson> origNachrichtenMap = new HashMap<String, NachrichtJson>();
        nachrichtenOrig.sort(NACHRICHTEN_TIMEORDER_COMPARATOR);
        for (NachrichtJson origNachricht : nachrichtenOrig) {
            if (origNachricht.getIdentifier() == null) {
                origNachricht.setIdentifier(this.createIdentifier(origNachricht));
            }
            origNachrichtenMap.put(origNachricht.getIdentifier(), origNachricht);
            boolean isDraft = Boolean.TRUE.equals(origNachricht.getDraft());
            boolean isCitizenMessage = NachrichtJson.Typ.CITIZEN.equals((Object)origNachricht.getTyp());
            boolean isClerkMessage = NachrichtJson.Typ.CLERK.equals((Object)origNachricht.getTyp());
            boolean bl = isCitizen ? isCitizenMessage : (isOwnMessage = isClerk ? isClerkMessage : false);
            if (isDraft && isOwnMessage) continue;
            nachrichtenProcessed.add(origNachricht);
        }
        nachrichtenNew.sort(NACHRICHTEN_TIMEORDER_COMPARATOR);
        for (NachrichtJson newNachricht : nachrichtenNew) {
            boolean timestampIsNull;
            boolean isClerksSeenMessage;
            boolean isCitizenMessage = NachrichtJson.Typ.CITIZEN.equals((Object)newNachricht.getTyp());
            boolean isClerkMessage = NachrichtJson.Typ.CLERK.equals((Object)newNachricht.getTyp());
            boolean isSystemMessage = NachrichtJson.Typ.SYSTEM.equals((Object)newNachricht.getTyp());
            isOwnMessage = isCitizen ? isCitizenMessage : (isClerk ? isClerkMessage : false);
            boolean isNew = newNachricht.getIdentifier() == null || !origNachrichtenMap.containsKey(newNachricht.getIdentifier());
            boolean wasPrefiouslyDraft = origNachrichtenMap.get(newNachricht.getIdentifier()) != null && Boolean.TRUE.equals(((NachrichtJson)origNachrichtenMap.get(newNachricht.getIdentifier())).getDraft());
            NachrichtParameterJson nachrichtenParameter = newNachricht.getNachrichtenParameter();
            boolean isClerksNotifyMessage = isSystemMessage && nachrichtenParameter != null && NachrichtParameterJson.Type.NOTIFY.equals((Object)nachrichtenParameter.getType()) && Boolean.FALSE.equals(nachrichtenParameter.getBenachrichtigt()) && username.equals(newNachricht.getAbsender());
            boolean isClerksProlongMessage = isSystemMessage && nachrichtenParameter != null && NachrichtParameterJson.Type.PROLONG.equals((Object)nachrichtenParameter.getType()) && Boolean.FALSE.equals(nachrichtenParameter.getVerlaengert()) && username.equals(newNachricht.getAbsender());
            boolean bl = isClerksSeenMessage = isSystemMessage && nachrichtenParameter != null && NachrichtParameterJson.Type.SEEN.equals((Object)nachrichtenParameter.getType()) && username.equals(newNachricht.getAbsender());
            if ((!isOwnMessage || !isNew && !wasPrefiouslyDraft) && !isClerksNotifyMessage && !isClerksProlongMessage && !isClerksSeenMessage) continue;
            NachrichtJson origNachricht = newNachricht.getIdentifier() != null && origNachrichtenMap.containsKey(newNachricht.getIdentifier()) ? (NachrichtJson)origNachrichtenMap.get(newNachricht.getIdentifier()) : null;
            boolean draftBecomesReal = !Boolean.TRUE.equals(newNachricht.getDraft()) && origNachricht != null && Boolean.TRUE.equals(origNachricht.getDraft());
            boolean bl2 = timestampIsNull = newNachricht.getTimestamp() == null;
            if (isNew || draftBecomesReal || timestampIsNull) {
                newNachricht.setTimestamp(timestamp);
            }
            if (newNachricht.getIdentifier() == null) {
                newNachricht.setIdentifier(this.createIdentifier(newNachricht));
            }
            nachrichtenProcessed.add(newNachricht);
        }
        nachrichtenProcessed.sort(NACHRICHTEN_TIMEORDER_COMPARATOR);
        return nachrichtenProcessed;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, FlaecheAenderungJson> processFlaechenUndPruefung(Map<String, CidsBean> existingFlaechen, Map<String, FlaecheAenderungJson> flaechenOrig, Map<String, FlaecheAenderungJson> flaechenNew, Boolean citizenOrClerk, Boolean veranlagt, String username, Date timestamp) throws Exception {
        block26: {
            block25: {
                isCitizen = Boolean.TRUE.equals(citizenOrClerk);
                isClerk = Boolean.FALSE.equals(citizenOrClerk);
                flaechenProcessed = new HashMap<String, FlaecheAenderungJson>();
                if (flaechenOrig != null) break block25;
                for (String bezeichnung : flaechenNew.keySet()) {
                    if (existingFlaechen.containsKey(bezeichnung)) {
                        flaeche = flaechenNew.get(bezeichnung);
                        flaeche.setPruefung(null);
                        flaechenProcessed.put(bezeichnung, flaeche);
                        continue;
                    }
                    AenderungsanfrageUtils.LOG.info((Object)("ignoring flaeche " + bezeichnung + " because it does not exist in the bean"));
                }
                break block26;
            }
            for (String bezeichnung : flaechenOrig.keySet()) {
                if (existingFlaechen.containsKey(bezeichnung)) {
                    flaecheOrig = flaechenOrig.get(bezeichnung);
                    flaecheProcessed = (FlaecheAenderungJson)AenderungsanfrageUtils.getMapper().readValue(flaecheOrig.toJson(), FlaecheAenderungJson.class);
                    flaechenProcessed.put(bezeichnung, flaecheProcessed);
                    continue;
                }
                AenderungsanfrageUtils.LOG.info((Object)("ignoring flaeche " + bezeichnung + " because it does not exist in the bean"));
            }
            for (String bezeichnung : flaechenNew.keySet()) {
                block27: {
                    block29: {
                        block28: {
                            if (!existingFlaechen.containsKey(bezeichnung)) break block27;
                            flaecheOrig = flaechenOrig.containsKey(bezeichnung) != false ? flaechenOrig.get(bezeichnung) : null;
                            flaecheNew = flaechenNew.get(bezeichnung);
                            if (flaecheOrig != null) break block28;
                            flaecheProcessed = (FlaecheAenderungJson)AenderungsanfrageUtils.getMapper().readValue(flaecheNew.toJson(), FlaecheAenderungJson.class);
                            flaecheProcessed.setPruefung(null);
                            break block29;
                        }
                        flaecheProcessed = (FlaecheAenderungJson)AenderungsanfrageUtils.getMapper().readValue(flaecheOrig.toJson(), FlaecheAenderungJson.class);
                        groesseNew = flaecheNew != null ? flaecheNew.getGroesse() : null;
                        flaechenartNew = flaecheNew != null ? flaecheNew.getFlaechenart() : null;
                        anschlussgradNew = flaecheNew != null ? flaecheNew.getAnschlussgrad() : null;
                        groesseOrig = flaecheOrig.getGroesse();
                        flaechenartOrig = flaecheOrig.getFlaechenart();
                        anschlussgradOrig = flaecheOrig.getAnschlussgrad();
                        flaecheBean = existingFlaechen.get(bezeichnung);
                        v0 = flaecheBean != null ? (Integer)flaecheBean.getProperty("flaecheninfo" + "." + "groesse_korrektur") : (groesseCids = null);
                        if (flaecheBean == null) ** GOTO lbl-1000
                        if (flaecheBean.getProperty("flaecheninfo" + "." + "flaechenart") != null) {
                            v1 = new FlaecheFlaechenartJson((String)flaecheBean.getProperty("flaecheninfo" + "." + "flaechenart" + "." + "art"), (String)flaecheBean.getProperty("flaecheninfo" + "." + "flaechenart" + "." + "art_abkuerzung"));
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = flaechenartCids = null;
                        }
                        if (flaecheBean == null) ** GOTO lbl-1000
                        if (flaecheBean.getProperty("flaecheninfo" + "." + "anschlussgrad") != null) {
                            v2 = new FlaecheAnschlussgradJson((String)flaecheBean.getProperty("flaecheninfo" + "." + "anschlussgrad" + "." + "grad"), (String)flaecheBean.getProperty("flaecheninfo" + "." + "anschlussgrad" + "." + "grad_abkuerzung"));
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = null;
                        }
                        anschlussgradCids = v2;
                        groesseNewEqualsBean = Objects.equals(groesseCids, groesseNew);
                        flaechenartNewEqualsBean = Objects.equals(flaechenartCids, flaechenartNew);
                        anschlussgradNewEqualsBean = Objects.equals(anschlussgradCids, anschlussgradNew);
                        groesseNewEqualsOrig = Objects.equals(groesseOrig, groesseNew);
                        flaechenartNewEqualsOrig = Objects.equals(flaechenartOrig, flaechenartNew);
                        anschlussgradNewEqualsOrig = Objects.equals(anschlussgradOrig, anschlussgradNew);
                        if (isCitizen) {
                            if (!(flaecheOrig.getPruefung() != null || groesseNew != null && !groesseNewEqualsBean || flaechenartNew != null && !flaechenartNewEqualsBean || anschlussgradNew != null && !anschlussgradNewEqualsBean)) {
                                flaechenProcessed.remove(bezeichnung);
                                continue;
                            }
                            flaecheProcessed.setDraft(flaecheNew != null ? flaecheNew.getDraft() : null);
                            if (!groesseNewEqualsOrig) {
                                flaecheProcessed.setGroesse(groesseNew);
                                if (flaecheProcessed.getPruefung() != null) {
                                    flaecheProcessed.getPruefung().setGroesse(null);
                                }
                            }
                            if (!flaechenartNewEqualsOrig) {
                                flaecheProcessed.setFlaechenart(flaechenartNew);
                                if (flaecheProcessed.getPruefung() != null) {
                                    flaecheProcessed.getPruefung().setFlaechenart(null);
                                }
                            }
                            if (!anschlussgradNewEqualsOrig) {
                                flaecheProcessed.setAnschlussgrad(anschlussgradNew);
                                if (flaecheProcessed.getPruefung() != null) {
                                    flaecheProcessed.getPruefung().setAnschlussgrad(null);
                                }
                            }
                        } else if (isClerk) {
                            groesseOrigEqualsBean = Objects.equals(groesseCids, groesseOrig);
                            flaechenartOrigEqualsBean = Objects.equals(flaechenartCids, flaechenartOrig);
                            anschlussgradOrigEqualsBean = Objects.equals(anschlussgradCids, anschlussgradOrig);
                            pruefungOrig = flaecheOrig.getPruefung();
                            pruefungGroesseOrig = pruefungOrig != null ? pruefungOrig.getGroesse() : null;
                            pruefungFlaechenartOrig = pruefungOrig != null ? pruefungOrig.getFlaechenart() : null;
                            pruefungAnschlussgradOrig = pruefungOrig != null ? pruefungOrig.getAnschlussgrad() : null;
                            pruefungNew = flaecheNew != null ? flaecheNew.getPruefung() : null;
                            pruefungGroesseNew = pruefungNew != null ? pruefungNew.getGroesse() : null;
                            pruefungFlaechenartNew = pruefungNew != null ? pruefungNew.getFlaechenart() : null;
                            pruefungAnschlussgradNew = pruefungNew != null ? pruefungNew.getAnschlussgrad() : null;
                            pruefungGroesseAutoaccept = groesseOrigEqualsBean != false ? new PruefungGroesseJson(groesseCids) : null;
                            pruefungFlaechenartAutoaccept = flaechenartOrigEqualsBean != false ? new PruefungFlaechenartJson(flaechenartCids) : null;
                            v3 = pruefungAnschlussgradAutoaccept = anschlussgradOrigEqualsBean != false ? new PruefungAnschlussgradJson(anschlussgradCids) : null;
                            v4 = veranlagt == null ? pruefungGroesseOrig : (pruefungGroesseAutoaccept != null ? pruefungGroesseAutoaccept : (pruefungGroesseProcessed = pruefungGroesseNew != null && Boolean.TRUE.equals(pruefungGroesseNew.getPending()) != false ? pruefungGroesseNew : pruefungGroesseOrig));
                            v5 = veranlagt == null ? pruefungFlaechenartOrig : (pruefungFlaechenartAutoaccept != null ? pruefungFlaechenartAutoaccept : (pruefungFlaechenartProcessed = pruefungFlaechenartNew != null && Boolean.TRUE.equals(pruefungFlaechenartNew.getPending()) != false ? pruefungFlaechenartNew : pruefungFlaechenartOrig));
                            v6 = veranlagt == null ? pruefungAnschlussgradOrig : (pruefungAnschlussgradAutoaccept != null ? pruefungAnschlussgradAutoaccept : (pruefungAnschlussgradProcessed = pruefungAnschlussgradNew != null && Boolean.TRUE.equals(pruefungAnschlussgradNew.getPending()) != false ? pruefungAnschlussgradNew : pruefungAnschlussgradOrig));
                            if (pruefungGroesseProcessed != null) {
                                pruefungGroesseProcessed.setPending(null);
                                if (!Objects.equals(pruefungGroesseOrig, pruefungGroesseProcessed)) {
                                    pruefungGroesseProcessed.setTimestamp(timestamp);
                                    pruefungGroesseProcessed.setVon(username);
                                }
                            }
                            if (pruefungFlaechenartProcessed != null) {
                                pruefungFlaechenartProcessed.setPending(null);
                                if (!Objects.equals(pruefungFlaechenartOrig, pruefungFlaechenartProcessed)) {
                                    pruefungFlaechenartProcessed.setTimestamp(timestamp);
                                    pruefungFlaechenartProcessed.setVon(username);
                                }
                            }
                            if (pruefungAnschlussgradProcessed != null) {
                                pruefungAnschlussgradProcessed.setPending(null);
                                if (!Objects.equals(pruefungAnschlussgradOrig, pruefungAnschlussgradProcessed)) {
                                    pruefungAnschlussgradProcessed.setTimestamp(timestamp);
                                    pruefungAnschlussgradProcessed.setVon(username);
                                }
                            }
                            flaecheProcessed.setPruefung(new FlaechePruefungJson(pruefungGroesseProcessed, pruefungFlaechenartProcessed, pruefungAnschlussgradProcessed));
                        }
                    }
                    flaechenProcessed.put(bezeichnung, flaecheProcessed);
                    continue;
                }
                AenderungsanfrageUtils.LOG.info((Object)("ignoring flaeche " + bezeichnung + " because it does not exist in the bean"));
            }
        }
        return flaechenProcessed;
    }

    private Map<String, GeoJsonObject> processAnmerkungen(Map<String, GeoJsonObject> geometrienOrig, Map<String, GeoJsonObject> geometrienNew, Boolean citizenOrClerk, String username, Date timestamp) throws Exception {
        boolean isCitizen = Boolean.TRUE.equals(citizenOrClerk);
        boolean isClerk = Boolean.FALSE.equals(citizenOrClerk);
        HashMap<String, GeoJsonObject> geometrienProcessed = new HashMap<String, GeoJsonObject>();
        if (isCitizen) {
            for (String bezeichnung : geometrienNew.keySet()) {
                Feature featureOrig = (Feature)geometrienOrig.get(bezeichnung);
                Feature featureNew = (Feature)geometrienNew.get(bezeichnung);
                if (featureNew == null) continue;
                Feature featureProcessed = new Feature();
                featureProcessed.setId(featureNew.getId());
                featureProcessed.setGeometry(featureNew.getGeometry());
                featureProcessed.setProperties(featureNew.getProperties());
                String geoJsonOrigString = featureOrig != null ? new ObjectMapper().writeValueAsString((Object)featureOrig) : null;
                String geoJsonNewString = new ObjectMapper().writeValueAsString((Object)featureNew);
                if (!Boolean.TRUE.equals(featureNew.getProperty("draft")) && !Objects.equals(geoJsonOrigString, geoJsonNewString) && featureProcessed.getProperties() != null) {
                    featureProcessed.getProperties().remove("pruefung");
                    featureProcessed.getProperties().remove("pruefungVon");
                    featureProcessed.getProperties().remove("pruefungTimestamp");
                }
                geometrienProcessed.put(bezeichnung, (GeoJsonObject)featureProcessed);
            }
        } else {
            for (String bezeichnung : geometrienOrig.keySet()) {
                Feature featureOrig = (Feature)geometrienOrig.get(bezeichnung);
                Feature featureNew = (Feature)geometrienNew.get(bezeichnung);
                Feature featureProcessed = new Feature();
                featureProcessed.setId(featureOrig.getId());
                featureProcessed.setGeometry(featureOrig.getGeometry());
                featureProcessed.setProperties(featureOrig.getProperties());
                if (isClerk && featureNew != null) {
                    Boolean pruefungOrig = (Boolean)featureOrig.getProperty("pruefung");
                    Boolean pruefungNew = (Boolean)featureNew.getProperty("pruefung");
                    if (pruefungNew != null) {
                        featureProcessed.setProperty("pruefung", (Object)pruefungNew);
                    }
                    if (!Objects.equals(pruefungOrig, pruefungNew) && pruefungNew != null) {
                        featureProcessed.setProperty("pruefungVon", (Object)username);
                        featureProcessed.setProperty("pruefungTimestamp", (Object)timestamp);
                    }
                }
                geometrienProcessed.put(bezeichnung, (GeoJsonObject)featureProcessed);
            }
        }
        return geometrienProcessed;
    }

    private static String executeCmd(String cmd) throws Exception {
        ProcessBuilder builder = new ProcessBuilder("/bin/sh", "-c", cmd);
        Process process = builder.start();
        InputStream is = process.getInputStream();
        return IOUtils.toString((Reader)new InputStreamReader(is));
    }

    private static void sendMail(String cmdTemplate, String emailAdresse, String betreff, String inhalt) throws Exception {
        if (emailAdresse != null && cmdTemplate != null) {
            String cmd = cmdTemplate.replaceAll(Pattern.quote(CMDREPLACER_CITIZEN_EMAIL), Matcher.quoteReplacement(emailAdresse)).replaceAll(Pattern.quote(CMDREPLACER_TOPIC), Matcher.quoteReplacement(betreff)).replaceAll(Pattern.quote(CMDREPLACER_MESSAGE), Matcher.quoteReplacement(inhalt));
            LOG.info((Object)String.format("executing sendMail CMD: %s", cmd));
            AenderungsanfrageUtils.executeCmd(cmd);
        }
    }

    public boolean sendVerificationMail(AenderungsanfrageJson aenderungsanfrage, String code) {
        if (aenderungsanfrage != null && code != null) {
            Integer kassenzeichenNummer = aenderungsanfrage.getKassenzeichen();
            String emailAdresse = aenderungsanfrage.getEmailAdresse();
            if (emailAdresse != null) {
                try {
                    AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
                    File configDir = conf.getMessageconfigDir() != null ? new File(conf.getMessageconfigDir()) : null;
                    MessageConfigJson messageConfig = this.getMessageConfig(MESSAGETYPE_MAILVERIFICATION, configDir);
                    if (messageConfig != null) {
                        String messageTemplate;
                        String cmdTemplate = messageConfig.getCmdTemplate();
                        String betreff = messageConfig.getTopic();
                        String string = messageTemplate = messageConfig.getMessageTemplateFile() != null ? this.readMessageTemplate(new File(configDir, messageConfig.getMessageTemplateFile())) : null;
                        if (messageTemplate != null) {
                            String inhalt = messageTemplate.replaceAll(Pattern.quote(TEMPLATEREPLACER_KASSENZEICHEN), Matcher.quoteReplacement(kassenzeichenNummer != null ? kassenzeichenNummer.toString() : "-")).replaceAll(Pattern.quote(TEMPLATEREPLACER_CODE), Matcher.quoteReplacement(code));
                            AenderungsanfrageUtils.sendMail(cmdTemplate != null ? cmdTemplate : DEFAULT_CMDTEMPLATE, emailAdresse, betreff, inhalt);
                            return true;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while sendVerificationMail", (Throwable)ex);
                }
            }
        }
        return false;
    }

    public boolean sendConfirmationMail(AenderungsanfrageJson aenderungsanfrage) {
        if (aenderungsanfrage != null) {
            Integer kassenzeichenNummer = aenderungsanfrage.getKassenzeichen();
            String emailAdresse = aenderungsanfrage.getEmailAdresse();
            if (emailAdresse != null) {
                try {
                    AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
                    File configDir = conf.getMessageconfigDir() != null ? new File(conf.getMessageconfigDir()) : null;
                    MessageConfigJson messageConfig = this.getMessageConfig(MESSAGETYPE_MAILCONFIRMATION, configDir);
                    if (messageConfig != null) {
                        String messageTemplate;
                        String cmdTemplate = messageConfig.getCmdTemplate();
                        String betreff = messageConfig.getTopic();
                        String string = messageTemplate = messageConfig.getMessageTemplateFile() != null ? this.readMessageTemplate(new File(configDir, messageConfig.getMessageTemplateFile())) : null;
                        if (messageTemplate != null) {
                            String inhalt = messageTemplate.replaceAll(Pattern.quote(TEMPLATEREPLACER_KASSENZEICHEN), Matcher.quoteReplacement(kassenzeichenNummer != null ? kassenzeichenNummer.toString() : "-"));
                            AenderungsanfrageUtils.sendMail(cmdTemplate != null ? cmdTemplate : DEFAULT_CMDTEMPLATE, emailAdresse, betreff, inhalt);
                            return true;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while sendConfirmationMail", (Throwable)ex);
                }
            }
        }
        return false;
    }

    private String readMessageTemplate(File messageTemplateFile) throws Exception {
        String messageTemplate = messageTemplateFile != null && messageTemplateFile.exists() && messageTemplateFile.isFile() && messageTemplateFile.canRead() ? IOUtils.toString((Reader)new FileReader(messageTemplateFile)) : null;
        return messageTemplate;
    }

    private MessageConfigJson getMessageConfig(String messageType, File configDir) {
        try {
            File configFile = configDir != null ? new File(configDir, String.format(CONFIG_JSON_FORMAT, messageType)) : null;
            boolean configFileOk = configFile != null && configFile.exists() && configFile.isFile() && configFile.canRead();
            String configJson = configFileOk ? IOUtils.toString((Reader)new FileReader(configFile)) : null;
            return configJson != null ? (MessageConfigJson)AenderungsanfrageUtils.getMapper().readValue(configJson, MessageConfigJson.class) : null;
        }
        catch (Exception ex) {
            LOG.error((Object)String.format("error while loading config file for %s, ", messageType), (Throwable)ex);
            return null;
        }
    }

    public boolean sendNotifyMail(AenderungsanfrageJson aenderungsanfrage) {
        if (aenderungsanfrage != null) {
            Integer kassenzeichenNummer = aenderungsanfrage.getKassenzeichen();
            String emailAdresse = aenderungsanfrage.getEmailAdresse();
            Boolean verifiziert = aenderungsanfrage.getEmailVerifiziert();
            if (emailAdresse != null && Boolean.TRUE.equals(verifiziert)) {
                try {
                    AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
                    File configDir = conf.getMessageconfigDir() != null ? new File(conf.getMessageconfigDir()) : null;
                    MessageConfigJson messageConfig = this.getMessageConfig(MESSAGETYPE_NOTIFY, configDir);
                    if (messageConfig != null) {
                        String messageTemplate;
                        String cmdTemplate = messageConfig.getCmdTemplate();
                        String betreff = messageConfig.getTopic();
                        String string = messageTemplate = messageConfig.getMessageTemplateFile() != null ? this.readMessageTemplate(new File(configDir, messageConfig.getMessageTemplateFile())) : null;
                        if (messageTemplate != null) {
                            String inhalt = messageTemplate.replaceAll(Pattern.quote(TEMPLATEREPLACER_KASSENZEICHEN), Matcher.quoteReplacement(kassenzeichenNummer != null ? kassenzeichenNummer.toString() : "-"));
                            AenderungsanfrageUtils.sendMail(cmdTemplate != null ? cmdTemplate : DEFAULT_CMDTEMPLATE, emailAdresse, betreff, inhalt);
                            return true;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while sendNotifyMail", (Throwable)ex);
                }
            }
        }
        return false;
    }

    public boolean sendStatusChangedMail(AenderungsanfrageJson aenderungsanfrage, Status status) {
        if (aenderungsanfrage != null) {
            Integer kassenzeichenNummer = aenderungsanfrage.getKassenzeichen();
            String emailAdresse = aenderungsanfrage.getEmailAdresse();
            Boolean verifiziert = aenderungsanfrage.getEmailVerifiziert();
            if (emailAdresse != null && Boolean.TRUE.equals(verifiziert)) {
                try {
                    AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
                    File configDir = conf.getMessageconfigDir() != null ? new File(conf.getMessageconfigDir()) : null;
                    MessageConfigJson messageConfig = this.getMessageConfig(status.toString(), configDir);
                    if (messageConfig != null) {
                        String messageTemplate;
                        String cmdTemplate = messageConfig.getCmdTemplate();
                        String betreff = messageConfig.getTopic();
                        String string = messageTemplate = messageConfig.getMessageTemplateFile() != null ? this.readMessageTemplate(new File(configDir, messageConfig.getMessageTemplateFile())) : null;
                        if (messageTemplate != null) {
                            String inhalt = messageTemplate.replaceAll(Pattern.quote(TEMPLATEREPLACER_KASSENZEICHEN), Matcher.quoteReplacement(kassenzeichenNummer != null ? kassenzeichenNummer.toString() : "-"));
                            AenderungsanfrageUtils.sendMail(cmdTemplate != null ? cmdTemplate : DEFAULT_CMDTEMPLATE, emailAdresse, betreff, inhalt);
                            return true;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while sendStatusChangedMail", (Throwable)ex);
                }
            }
        }
        return false;
    }

    public boolean sendSubmissionMail(AenderungsanfrageJson aenderungsanfrage) {
        if (aenderungsanfrage != null) {
            Integer kassenzeichenNummer = aenderungsanfrage.getKassenzeichen();
            String emailAdresse = aenderungsanfrage.getEmailAdresse();
            Boolean verifiziert = aenderungsanfrage.getEmailVerifiziert();
            if (emailAdresse != null && Boolean.TRUE.equals(verifiziert)) {
                try {
                    AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
                    File configDir = conf.getMessageconfigDir() != null ? new File(conf.getMessageconfigDir()) : null;
                    MessageConfigJson messageConfig = this.getMessageConfig(MESSAGETYPE_SUBMISSION, configDir);
                    if (messageConfig != null) {
                        String messageTemplate;
                        String cmdTemplate = messageConfig.getCmdTemplate();
                        String betreff = messageConfig.getTopic();
                        String string = messageTemplate = messageConfig.getMessageTemplateFile() != null ? this.readMessageTemplate(new File(configDir, messageConfig.getMessageTemplateFile())) : null;
                        if (messageTemplate != null) {
                            String inhalt = messageTemplate.replaceAll(Pattern.quote(TEMPLATEREPLACER_KASSENZEICHEN), Matcher.quoteReplacement(kassenzeichenNummer != null ? kassenzeichenNummer.toString() : "-"));
                            AenderungsanfrageUtils.sendMail(cmdTemplate != null ? cmdTemplate : DEFAULT_CMDTEMPLATE, emailAdresse, betreff, inhalt);
                            return true;
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while sendSubmissionMail", (Throwable)ex);
                }
            }
        }
        return false;
    }

    public AenderungsanfrageJson doProcessing(StacEntry stacEntry, Integer kassenzeichennumer, Map<String, CidsBean> existingFlaechen, AenderungsanfrageJson anfrageOrig, AenderungsanfrageJson anfrageNew, Boolean citizenOrClerk, Boolean veranlagt, String username, Date timestamp, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        AenderungsanfrageJson anfrageProcessed;
        Boolean emailVerifiziert = anfrageOrig.getEmailVerifiziert();
        String emailAdresse = anfrageOrig.getEmailAdresse();
        if (Boolean.TRUE.equals(citizenOrClerk) && anfrageNew.getEmailVerifiziert() == null) {
            emailAdresse = anfrageNew.getEmailAdresse();
            if (emailAdresse != null) {
                emailVerifiziert = false;
                String code = this.addEmailVerification(kassenzeichennumer, emailAdresse);
                this.sendVerificationMail(anfrageNew, code);
            } else {
                emailVerifiziert = null;
                this.removeEmail(kassenzeichennumer, emailAdresse);
            }
        }
        String emailVerifikation = anfrageNew.getEmailVerifikation();
        if (Boolean.TRUE.equals(citizenOrClerk) && emailAdresse != null && emailVerifikation != null && !Boolean.TRUE.equals(emailVerifiziert)) {
            EmailVerification emailVerification = this.getEmailVerification(kassenzeichennumer);
            if (emailVerification != null) {
                emailVerifiziert = emailVerifikation.equals(emailVerification.getCode());
                if (emailVerifiziert.booleanValue()) {
                    LOG.info((Object)String.format("validation of %s with code %s SUCCESFULL", emailAdresse, emailVerifikation));
                    this.sendConfirmationMail(anfrageNew);
                } else {
                    LOG.info((Object)String.format("validation of %s with code %s FAILED", emailAdresse, emailVerifikation));
                }
            } else {
                emailVerifiziert = null;
            }
        }
        if ((anfrageProcessed = new AenderungsanfrageJson(kassenzeichennumer, emailAdresse, null, emailVerifiziert, this.processFlaechenUndPruefung(existingFlaechen, anfrageOrig.getFlaechen(), anfrageNew.getFlaechen(), citizenOrClerk, veranlagt, username, timestamp), this.processAnmerkungen(anfrageOrig.getGeometrien(), anfrageNew.getGeometrien(), citizenOrClerk, username, timestamp), this.processNachrichten(anfrageOrig.getNachrichten(), anfrageNew.getNachrichten(), citizenOrClerk, username, timestamp), null)).getNachrichten() != null) {
            boolean notified = false;
            for (NachrichtJson nachrichtJson : anfrageProcessed.getNachrichten()) {
                if (nachrichtJson == null) continue;
                NachrichtParameterJson nachrichtenParameter = nachrichtJson.getNachrichtenParameter();
                if (nachrichtenParameter != null && Boolean.FALSE.equals(nachrichtenParameter.getBenachrichtigt())) {
                    if (!notified) {
                        notified = this.sendNotifyMail(anfrageNew);
                    }
                    if (notified) {
                        nachrichtenParameter.setBenachrichtigt(Boolean.TRUE);
                    }
                }
                if (nachrichtenParameter == null || !Boolean.FALSE.equals(nachrichtenParameter.getVerlaengert())) continue;
                StacUtils.prolongExpiration(stacEntry, metaService, connectionContext);
                nachrichtenParameter.setVerlaengert(Boolean.TRUE);
            }
        }
        return anfrageProcessed;
    }

    /*
     * WARNING - void declaration
     */
    public Status identifyNewStatus(Status oldStatus, Map<String, CidsBean> existingFlaechen, AenderungsanfrageJson aenderungsanfrageBefore, AenderungsanfrageJson aenderungsanfrageAfter, Boolean citizenOrClerk, Boolean veranlagt, String username, Date timestamp) throws Exception {
        boolean isCitizen = Boolean.TRUE.equals(citizenOrClerk);
        boolean isClerk = Boolean.FALSE.equals(citizenOrClerk);
        boolean isArchived = Status.ARCHIVED.equals((Object)oldStatus);
        HashMap<String, NachrichtJson> nachrichtenPerUUid = new HashMap<String, NachrichtJson>();
        if (aenderungsanfrageBefore.getNachrichten() != null) {
            for (NachrichtJson nachrichtJson : aenderungsanfrageBefore.getNachrichten()) {
                if (nachrichtJson == null || nachrichtJson.getIdentifier() == null) continue;
                nachrichtenPerUUid.put(nachrichtJson.getIdentifier(), nachrichtJson);
            }
        }
        if (isCitizen && !isArchived) {
            boolean anyChanges = false;
            if (aenderungsanfrageAfter.getFlaechen() != null) {
                for (String bezeichnung : aenderungsanfrageAfter.getFlaechen().keySet()) {
                    FlaecheFlaechenartJson flaechenartAfter;
                    FlaecheAenderungJson flaecheAenderungBefore = aenderungsanfrageBefore.getFlaechen().get(bezeichnung);
                    FlaecheAenderungJson flaecheAenderungAfter = aenderungsanfrageAfter.getFlaechen().get(bezeichnung);
                    FlaecheAenderungJson flaecheAenderungBeforeNoDraft = flaecheAenderungBefore != null && !Boolean.TRUE.equals(flaecheAenderungBefore.getDraft()) ? flaecheAenderungBefore : null;
                    FlaecheAenderungJson flaecheAenderungAfterNoDraft = flaecheAenderungAfter != null && !Boolean.TRUE.equals(flaecheAenderungAfter.getDraft()) ? flaecheAenderungAfter : null;
                    Integer groesseBefore = flaecheAenderungBeforeNoDraft != null ? flaecheAenderungBeforeNoDraft.getGroesse() : null;
                    FlaecheAnschlussgradJson anschlussgradBefore = flaecheAenderungBeforeNoDraft != null ? flaecheAenderungBeforeNoDraft.getAnschlussgrad() : null;
                    FlaecheFlaechenartJson flaechenartBefore = flaecheAenderungBeforeNoDraft != null ? flaecheAenderungBeforeNoDraft.getFlaechenart() : null;
                    Integer groesseAfter = flaecheAenderungAfterNoDraft != null ? flaecheAenderungAfterNoDraft.getGroesse() : null;
                    FlaecheAnschlussgradJson anschlussgradAfter = flaecheAenderungAfterNoDraft != null ? flaecheAenderungAfterNoDraft.getAnschlussgrad() : null;
                    FlaecheFlaechenartJson flaecheFlaechenartJson = flaechenartAfter = flaecheAenderungAfterNoDraft != null ? flaecheAenderungAfterNoDraft.getFlaechenart() : null;
                    if (Objects.equals(groesseBefore, groesseAfter) && Objects.equals(anschlussgradBefore, anschlussgradAfter) && Objects.equals(flaechenartBefore, flaechenartAfter)) continue;
                    anyChanges = true;
                    break;
                }
            }
            if (aenderungsanfrageAfter.getGeometrien() != null) {
                for (String bezeichnung : aenderungsanfrageAfter.getGeometrien().keySet()) {
                    String anmerkungAfterString;
                    Feature anmerkungBeforeWithoutPruefung;
                    Feature anmerkungAfterNoDraft;
                    Feature anmerkungBefore = (Feature)aenderungsanfrageBefore.getGeometrien().get(bezeichnung);
                    Feature anmerkungAfter = (Feature)aenderungsanfrageAfter.getGeometrien().get(bezeichnung);
                    Feature anmerkungBeforeNoDraft = anmerkungBefore != null && !Boolean.TRUE.equals(anmerkungBefore.getProperty("draft")) ? anmerkungBefore : null;
                    Feature feature = anmerkungAfterNoDraft = anmerkungAfter != null && !Boolean.TRUE.equals(anmerkungAfter.getProperty("draft")) ? anmerkungAfter : null;
                    if (anmerkungBeforeNoDraft != null) {
                        anmerkungBeforeWithoutPruefung = new Feature();
                        anmerkungBeforeWithoutPruefung.setId(anmerkungBeforeNoDraft.getId());
                        anmerkungBeforeWithoutPruefung.setGeometry(anmerkungBeforeNoDraft.getGeometry());
                        anmerkungBeforeWithoutPruefung.setProperties(anmerkungBeforeNoDraft.getProperties());
                        if (anmerkungBeforeWithoutPruefung.getProperties() != null) {
                            anmerkungBeforeWithoutPruefung.getProperties().remove("pruefung");
                            anmerkungBeforeWithoutPruefung.getProperties().remove("pruefungVon");
                            anmerkungBeforeWithoutPruefung.getProperties().remove("pruefungTimestamp");
                        }
                    } else {
                        anmerkungBeforeWithoutPruefung = null;
                    }
                    String anmerkungBeforeString = anmerkungBeforeWithoutPruefung != null ? new ObjectMapper().writeValueAsString((Object)anmerkungBeforeWithoutPruefung) : null;
                    String string = anmerkungAfterString = anmerkungAfterNoDraft != null ? new ObjectMapper().writeValueAsString((Object)anmerkungAfterNoDraft) : null;
                    if (anmerkungBeforeWithoutPruefung != null && Objects.equals(anmerkungBeforeString, anmerkungAfterString)) continue;
                    anyChanges = true;
                    break;
                }
            }
            if (anyChanges) {
                return Status.PENDING;
            }
        } else if (isClerk) {
            boolean prolong = false;
            if (aenderungsanfrageAfter.getNachrichten() != null) {
                for (NachrichtJson nachricht : aenderungsanfrageAfter.getNachrichten()) {
                    NachrichtJson nachrichtBefore;
                    if (nachricht == null || !NachrichtJson.Typ.SYSTEM.equals((Object)nachricht.getTyp()) || !Boolean.TRUE.equals(nachricht.getNachrichtenParameter().getVerlaengert())) continue;
                    String identifier = nachricht.getIdentifier();
                    NachrichtJson nachrichtJson = nachrichtBefore = identifier != null && nachrichtenPerUUid.containsKey(identifier) ? (NachrichtJson)nachrichtenPerUUid.get(identifier) : null;
                    if (nachrichtBefore != null && (nachrichtBefore.getNachrichtenParameter() == null || Boolean.TRUE.equals(nachrichtBefore.getNachrichtenParameter().getVerlaengert()))) continue;
                    prolong = true;
                    break;
                }
            }
            if (veranlagt != null && !isArchived || prolong) {
                void var14_24;
                if (aenderungsanfrageBefore.getFlaechen().size() < aenderungsanfrageAfter.getFlaechen().size()) {
                    throw new Exception("flaeche added. clerk is not allowed to add flaeche");
                }
                boolean bl = false;
                int aenderungCount = 0;
                for (String bezeichnung : aenderungsanfrageBefore.getFlaechen().keySet()) {
                    boolean isFlaechenartAcceptedOrRejected;
                    FlaecheFlaechenartJson pruefungFlaechenartAfter;
                    FlaecheAenderungJson flaecheAenderungBefore = aenderungsanfrageBefore.getFlaechen().get(bezeichnung);
                    FlaecheAenderungJson flaecheAenderungAfter = aenderungsanfrageAfter.getFlaechen().get(bezeichnung);
                    if (existingFlaechen.containsKey(bezeichnung) && flaecheAenderungAfter == null) {
                        throw new Exception("flaeche disappeared. clerk is not allowed to delete flaeche");
                    }
                    if (flaecheAenderungAfter == null) continue;
                    Integer groesseBefore = flaecheAenderungBefore.getGroesse();
                    FlaecheAnschlussgradJson anschlussgradBefore = flaecheAenderungBefore.getAnschlussgrad();
                    FlaecheFlaechenartJson flaechenartBefore = flaecheAenderungBefore.getFlaechenart();
                    Integer pruefungGroesseBefore = flaecheAenderungBefore.getPruefung() != null && flaecheAenderungBefore.getPruefung().getGroesse() != null && !Boolean.TRUE.equals(flaecheAenderungBefore.getPruefung().getGroesse().getPending()) ? (Integer)flaecheAenderungBefore.getPruefung().getGroesse().getValue() : null;
                    FlaecheAnschlussgradJson pruefungAnschlussgradBefore = flaecheAenderungBefore.getPruefung() != null && flaecheAenderungBefore.getPruefung().getAnschlussgrad() != null && !Boolean.TRUE.equals(flaecheAenderungBefore.getPruefung().getAnschlussgrad().getPending()) ? (FlaecheAnschlussgradJson)flaecheAenderungBefore.getPruefung().getAnschlussgrad().getValue() : null;
                    FlaecheFlaechenartJson pruefungflaechenartBefore = flaecheAenderungBefore.getPruefung() != null && flaecheAenderungBefore.getPruefung().getFlaechenart() != null && !Boolean.TRUE.equals(flaecheAenderungBefore.getPruefung().getFlaechenart().getPending()) ? (FlaecheFlaechenartJson)flaecheAenderungBefore.getPruefung().getFlaechenart().getValue() : null;
                    Integer groesseAfter = flaecheAenderungAfter.getGroesse();
                    FlaecheAnschlussgradJson anschlussgradAfter = flaecheAenderungAfter.getAnschlussgrad();
                    FlaecheFlaechenartJson flaechenartAfter = flaecheAenderungAfter.getFlaechenart();
                    Integer pruefungGroesseAfter = flaecheAenderungAfter.getPruefung() != null && flaecheAenderungAfter.getPruefung().getGroesse() != null && !Boolean.TRUE.equals(flaecheAenderungAfter.getPruefung().getGroesse().getPending()) ? (Integer)flaecheAenderungAfter.getPruefung().getGroesse().getValue() : null;
                    FlaecheAnschlussgradJson pruefungAnschlussgradAfter = flaecheAenderungAfter.getPruefung() != null && flaecheAenderungAfter.getPruefung().getAnschlussgrad() != null && !Boolean.TRUE.equals(flaecheAenderungAfter.getPruefung().getAnschlussgrad().getPending()) ? (FlaecheAnschlussgradJson)flaecheAenderungAfter.getPruefung().getAnschlussgrad().getValue() : null;
                    FlaecheFlaechenartJson flaecheFlaechenartJson = pruefungFlaechenartAfter = flaecheAenderungAfter.getPruefung() != null && flaecheAenderungAfter.getPruefung().getFlaechenart() != null && !Boolean.TRUE.equals(flaecheAenderungAfter.getPruefung().getFlaechenart().getPending()) ? (FlaecheFlaechenartJson)flaecheAenderungAfter.getPruefung().getFlaechenart().getValue() : null;
                    if (!(Objects.equals(groesseBefore, groesseAfter) && Objects.equals(anschlussgradBefore, anschlussgradAfter) && Objects.equals(flaechenartBefore, flaechenartAfter))) {
                        throw new Exception("groesse, anschlussgrad or flachenart request did change. clerk is not allowed to do this");
                    }
                    if (!Boolean.TRUE.equals(flaecheAenderungBefore.getDraft())) {
                        if (flaecheAenderungBefore.getGroesse() != null) {
                            ++aenderungCount;
                        }
                        if (flaecheAenderungBefore.getAnschlussgrad() != null) {
                            ++aenderungCount;
                        }
                        if (flaecheAenderungBefore.getFlaechenart() != null) {
                            ++aenderungCount;
                        }
                    }
                    if (!Boolean.TRUE.equals(flaecheAenderungBefore.getDraft()) && flaecheAenderungAfter.getPruefung() != null) {
                        void var14_23;
                        if (flaecheAenderungAfter.getPruefung().getGroesse() != null) {
                            ++var14_23;
                        }
                        if (flaecheAenderungAfter.getPruefung().getAnschlussgrad() != null) {
                            ++var14_23;
                        }
                        if (flaecheAenderungAfter.getPruefung().getFlaechenart() != null) {
                            ++var14_23;
                        }
                    }
                    boolean isGroesseAcceptedOrRejected = groesseBefore != null && pruefungGroesseAfter != null;
                    boolean isAnschlussgradAcceptedOrRejected = anschlussgradBefore != null && pruefungAnschlussgradAfter != null;
                    boolean bl2 = isFlaechenartAcceptedOrRejected = flaechenartBefore != null && pruefungFlaechenartAfter != null;
                    if (isGroesseAcceptedOrRejected && !Objects.equals(pruefungGroesseBefore, pruefungGroesseAfter)) {
                        aenderungsanfrageAfter.getNachrichten().add(new NachrichtSystemJson(this.createIdentifier(null), timestamp, null, new NachrichtParameterGroesseJson(Objects.equals(groesseBefore, pruefungGroesseAfter) ? NachrichtParameterJson.Type.CHANGED : NachrichtParameterJson.Type.REJECTED, bezeichnung, groesseBefore), username));
                    }
                    if (isAnschlussgradAcceptedOrRejected && !Objects.equals(pruefungAnschlussgradBefore, pruefungAnschlussgradAfter)) {
                        aenderungsanfrageAfter.getNachrichten().add(new NachrichtSystemJson(this.createIdentifier(null), timestamp, null, new NachrichtParameterAnschlussgradJson(Objects.equals(anschlussgradBefore, pruefungAnschlussgradAfter) ? NachrichtParameterJson.Type.CHANGED : NachrichtParameterJson.Type.REJECTED, bezeichnung, anschlussgradBefore), username));
                    }
                    if (!isFlaechenartAcceptedOrRejected || Objects.equals(pruefungflaechenartBefore, pruefungFlaechenartAfter)) continue;
                    aenderungsanfrageAfter.getNachrichten().add(new NachrichtSystemJson(this.createIdentifier(null), timestamp, null, new NachrichtParameterFlaechenartJson(Objects.equals(flaechenartBefore, pruefungFlaechenartAfter) ? NachrichtParameterJson.Type.CHANGED : NachrichtParameterJson.Type.REJECTED, bezeichnung, flaechenartBefore), username));
                }
                for (String bezeichnung : aenderungsanfrageAfter.getGeometrien().keySet()) {
                    Feature anmerkungAfter = (Feature)aenderungsanfrageAfter.getGeometrien().get(bezeichnung);
                    if (anmerkungAfter == null || Boolean.TRUE.equals(anmerkungAfter.getProperty("draft"))) continue;
                    ++aenderungCount;
                    Boolean pruefungAfter = (Boolean)anmerkungAfter.getProperty("pruefung");
                    if (pruefungAfter == null) continue;
                    ++var14_24;
                }
                if (var14_24 == aenderungCount) {
                    if (Boolean.TRUE.equals(veranlagt) || prolong) {
                        return Status.NONE;
                    }
                } else {
                    return Status.PROCESSING;
                }
            }
        }
        return null;
    }

    public void addStatusChangedSystemMessage(Status oldStatus, Status changeStatusTo, AenderungsanfrageJson aenderungsanfrageAfter, Date timestamp, String username) throws Exception {
        boolean statusChanged;
        boolean bl = statusChanged = changeStatusTo != null && !changeStatusTo.equals((Object)oldStatus);
        if (statusChanged) {
            aenderungsanfrageAfter.getNachrichten().add(new NachrichtSystemJson(this.createIdentifier(null), Status.PROCESSING.equals((Object)changeStatusTo) ? new Date(timestamp.getTime() - 1L) : (Status.NONE.equals((Object)changeStatusTo) ? new Date(timestamp.getTime() + 1L) : timestamp), null, new NachrichtParameterStatusJson(changeStatusTo), username));
        }
    }

    public AenderungsanfrageJson doFilteringOutWhatIShouldntSee(AenderungsanfrageJson aenderungsanfrage, boolean citizenOrClerk) throws Exception {
        boolean include;
        boolean isDraft;
        boolean isCitizen = Boolean.TRUE.equals(citizenOrClerk);
        boolean isClerk = Boolean.FALSE.equals(citizenOrClerk);
        if (aenderungsanfrage == null) {
            return null;
        }
        AenderungsanfrageJson aenderungsanfrageFiltered = new AenderungsanfrageJson(aenderungsanfrage.getKassenzeichen(), aenderungsanfrage.getEmailAdresse(), aenderungsanfrage.getEmailVerifiziert());
        if (aenderungsanfrage.getNachrichten() != null) {
            for (NachrichtJson nachricht : aenderungsanfrage.getNachrichten()) {
                if (nachricht == null) continue;
                NachrichtJson nachrichtFiltered = (NachrichtJson)AenderungsanfrageUtils.getMapper().readValue(nachricht.toJson(), NachrichtJson.class);
                boolean isDraft2 = Boolean.TRUE.equals(nachricht.getDraft());
                boolean isCitizenMessage = NachrichtJson.Typ.CITIZEN.equals((Object)nachricht.getTyp());
                boolean isClerkMessage = NachrichtJson.Typ.CLERK.equals((Object)nachricht.getTyp());
                boolean isOwnMessage = isCitizen ? isCitizenMessage : (isClerk ? isClerkMessage : false);
                boolean include2 = isOwnMessage || !isDraft2;
                if (!include2) continue;
                if (isCitizen) {
                    nachrichtFiltered.setAbsender(null);
                }
                aenderungsanfrageFiltered.getNachrichten().add(nachrichtFiltered);
            }
        }
        if (aenderungsanfrage.getFlaechen() != null) {
            for (String bezeichnung : aenderungsanfrage.getFlaechen().keySet()) {
                FlaecheAenderungJson flaeche = aenderungsanfrage.getFlaechen().get(bezeichnung);
                if (flaeche == null) continue;
                FlaecheAenderungJson flaecheFiltered = (FlaecheAenderungJson)AenderungsanfrageUtils.getMapper().readValue(flaeche.toJson(), FlaecheAenderungJson.class);
                isDraft = Boolean.TRUE.equals(flaeche.getDraft());
                include = isCitizen || isClerk && !isDraft;
                if (!include) continue;
                if (isCitizen && flaecheFiltered.getPruefung() != null) {
                    if (flaecheFiltered.getPruefung().getGroesse() != null) {
                        flaecheFiltered.getPruefung().getGroesse().setVon(null);
                        if (Boolean.TRUE.equals(flaecheFiltered.getPruefung().getGroesse().getPending())) {
                            flaecheFiltered.getPruefung().setGroesse(null);
                        }
                    }
                    if (flaecheFiltered.getPruefung().getFlaechenart() != null) {
                        flaecheFiltered.getPruefung().getFlaechenart().setVon(null);
                        if (Boolean.TRUE.equals(flaecheFiltered.getPruefung().getFlaechenart().getPending())) {
                            flaecheFiltered.getPruefung().setFlaechenart(null);
                        }
                    }
                    if (flaecheFiltered.getPruefung().getAnschlussgrad() != null) {
                        flaecheFiltered.getPruefung().getAnschlussgrad().setVon(null);
                        if (Boolean.TRUE.equals(flaecheFiltered.getPruefung().getAnschlussgrad().getPending())) {
                            flaecheFiltered.getPruefung().setAnschlussgrad(null);
                        }
                    }
                    if (flaecheFiltered.getPruefung().getGroesse() == null && flaecheFiltered.getPruefung().getFlaechenart() == null && flaecheFiltered.getPruefung().getAnschlussgrad() == null) {
                        flaecheFiltered.setPruefung(null);
                    }
                }
                aenderungsanfrageFiltered.getFlaechen().put(bezeichnung, flaecheFiltered);
            }
        }
        if (aenderungsanfrage.getGeometrien() != null) {
            for (String bezeichnung : aenderungsanfrage.getGeometrien().keySet()) {
                Feature anmerkung = (Feature)aenderungsanfrage.getGeometrien().get(bezeichnung);
                if (anmerkung == null) continue;
                Feature anmerkungFitlered = (Feature)AenderungsanfrageUtils.getMapper().readValue(AenderungsanfrageUtils.getMapper().writeValueAsString((Object)anmerkung), Feature.class);
                isDraft = Boolean.TRUE.equals(anmerkung.getProperty("draft"));
                include = isCitizen || !isDraft;
                if (!include) continue;
                if (isCitizen && anmerkungFitlered.getProperties() != null) {
                    anmerkungFitlered.getProperties().remove("pruefungTimestamp");
                }
                aenderungsanfrageFiltered.getGeometrien().put(bezeichnung, (GeoJsonObject)anmerkungFitlered);
            }
        }
        return aenderungsanfrageFiltered;
    }

    private static Collection execSearch(CidsServerSearch search, User user, MetaService metaService) throws SearchException {
        HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
        localServers.put("VERDIS_GRUNDIS", metaService);
        search.setActiveLocalServers(localServers);
        search.setUser(user);
        return search.performServerSearch();
    }

    public static AenderungsanfrageJson stripAenderungsanfrageFor(AenderungsanfrageJson aenderungsanfrage, NachrichtJson.Typ typ) throws IOException {
        Map<String, FlaecheAenderungJson> flaechen;
        if (aenderungsanfrage == null) {
            return null;
        }
        AenderungsanfrageJson anfrageStripped = (AenderungsanfrageJson)AenderungsanfrageUtils.getMapper().readValue(aenderungsanfrage.toJson(), AenderungsanfrageJson.class);
        List<NachrichtJson> nachrichten = aenderungsanfrage.getNachrichten();
        if (nachrichten != null) {
            anfrageStripped.getNachrichten().clear();
            for (NachrichtJson nachricht : nachrichten) {
                if (Boolean.TRUE.equals(nachricht.getDraft()) && (typ == null || !Objects.equals((Object)typ, (Object)nachricht.getTyp()))) continue;
                anfrageStripped.getNachrichten().add(nachricht);
            }
        }
        if (anfrageStripped.getNachrichten().isEmpty()) {
            anfrageStripped.setNachrichten(null);
        }
        if ((flaechen = aenderungsanfrage.getFlaechen()) != null) {
            anfrageStripped.getFlaechen().clear();
            for (String key : flaechen.keySet()) {
                FlaecheAenderungJson flaecheAenderungStripped = (FlaecheAenderungJson)AenderungsanfrageUtils.getMapper().readValue(flaechen.get(key).toJson(), FlaecheAenderungJson.class);
                if (Boolean.TRUE.equals(flaecheAenderungStripped.getDraft()) && !NachrichtJson.Typ.CITIZEN.equals((Object)typ)) continue;
                FlaechePruefungJson pruefungStripped = flaecheAenderungStripped.getPruefung();
                if (pruefungStripped != null && (typ == null || NachrichtJson.Typ.CITIZEN.equals((Object)typ))) {
                    PruefungGroesseJson pruefungGroesse;
                    PruefungFlaechenartJson pruefungFlaechenart;
                    PruefungAnschlussgradJson pruefungAnschlussgrad = pruefungStripped.getAnschlussgrad();
                    if (pruefungAnschlussgrad != null && Boolean.TRUE.equals(pruefungAnschlussgrad.getPending())) {
                        pruefungStripped.setAnschlussgrad(null);
                    }
                    if ((pruefungFlaechenart = pruefungStripped.getFlaechenart()) != null && Boolean.TRUE.equals(pruefungFlaechenart.getPending())) {
                        pruefungStripped.setFlaechenart(null);
                    }
                    if ((pruefungGroesse = pruefungStripped.getGroesse()) != null && Boolean.TRUE.equals(pruefungGroesse.getPending())) {
                        pruefungStripped.setGroesse(null);
                    }
                    if (pruefungStripped.getAnschlussgrad() == null && pruefungStripped.getFlaechenart() == null && pruefungStripped.getGroesse() == null) {
                        flaecheAenderungStripped.setPruefung(null);
                    }
                }
                if (flaecheAenderungStripped.getAnschlussgrad() == null && flaecheAenderungStripped.getFlaechenart() == null && flaecheAenderungStripped.getGroesse() == null && flaecheAenderungStripped.getPruefung() == null) continue;
                anfrageStripped.getFlaechen().put(key, flaecheAenderungStripped);
            }
            if (anfrageStripped.getFlaechen().isEmpty()) {
                anfrageStripped.setFlaechen(null);
            }
        }
        return anfrageStripped;
    }

    public CidsBean getAenderungsanfrageBean(StacEntry stacEntry, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        if (stacEntry != null) {
            User user = StacUtils.getUser(stacEntry, metaService, connectionContext);
            AenderungsanfrageSearchStatement search = new AenderungsanfrageSearchStatement();
            search.setStacId(stacEntry.getId());
            Collection mons = AenderungsanfrageUtils.execSearch((CidsServerSearch)search, user, metaService);
            for (MetaObjectNode mon : mons) {
                if (mon == null) continue;
                return metaService.getMetaObject(user, mon.getObjectId(), mon.getClassId(), connectionContext).getBean();
            }
        }
        return null;
    }

    public AenderungsanfrageJson createAenderungsanfrageJson(Map<String, Object> map) throws Exception {
        return this.createAenderungsanfrageJson(AenderungsanfrageUtils.getMapper().writeValueAsString(map));
    }

    public AenderungsanfrageJson createAenderungsanfrageJson(String json) throws Exception {
        return (AenderungsanfrageJson)AenderungsanfrageUtils.getMapper().readValue(json, AenderungsanfrageJson.class);
    }

    public AenderungsanfrageResultJson createAenderungsanfrageResultJson(String json) throws Exception {
        return (AenderungsanfrageResultJson)AenderungsanfrageUtils.getMapper().readValue(json, AenderungsanfrageResultJson.class);
    }

    public NachrichtAnhangJson createNachrichtAnhangJson(String json) throws Exception {
        return (NachrichtAnhangJson)AenderungsanfrageUtils.getMapper().readValue(json, NachrichtAnhangJson.class);
    }

    public NachrichtParameterJson createNachrichtParameterJson(String json) throws Exception {
        return (NachrichtParameterJson)AenderungsanfrageUtils.getMapper().readValue(json, NachrichtParameterJson.class);
    }

    public ContactInfoJson getContactInfo(String user) {
        return this.getContactInfo(user, null);
    }

    public ContactInfoJson getContactInfo(String user, String defaultUser) {
        ContactInfosJson contactInfos = this.getContactInfos();
        if (contactInfos != null && contactInfos.getMap() != null) {
            if (contactInfos.getMap().containsKey(user)) {
                return contactInfos.getMap().get(user);
            }
            return defaultUser != null ? contactInfos.getMap().get(defaultUser) : null;
        }
        return null;
    }

    public ContactInfosJson getContactInfos() {
        try {
            AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
            File contactInfoFile = conf.getSachbearbeiterKontaktdaten() != null ? new File(conf.getSachbearbeiterKontaktdaten()) : null;
            String json = contactInfoFile != null && contactInfoFile.isFile() && contactInfoFile.canRead() ? IOUtils.toString((Reader)new FileReader(contactInfoFile)) : null;
            return json != null ? (ContactInfosJson)AenderungsanfrageUtils.getMapper().readValue(json, ContactInfosJson.class) : null;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading contact infos", (Throwable)ex);
            return null;
        }
    }

    public static CidsBean getStatusBean(Status status, User user, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        AenderungsanfrageStatusSearchStatement search = new AenderungsanfrageStatusSearchStatement();
        search.setSchluessel(status.toString());
        Collection mons = AenderungsanfrageUtils.execSearch((CidsServerSearch)search, user, metaService);
        if (mons != null && !mons.isEmpty()) {
            for (MetaObjectNode mon : mons) {
                if (mon == null) continue;
                return metaService.getMetaObject(user, mon.getObjectId(), mon.getClassId(), connectionContext).getBean();
            }
        }
        return null;
    }

    public static CidsBean getStatusBean(Status status, StacEntry stacEntry, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        if (stacEntry != null) {
            User user = StacUtils.getUser(stacEntry, metaService, connectionContext);
            return AenderungsanfrageUtils.getStatusBean(status, user, metaService, connectionContext);
        }
        return null;
    }

    public static void archiveOldAenderungsanfragen(User user, MetaService metaService, ConnectionContext connectionContext) {
        try {
            Timestamp now = Timestamp.valueOf(LocalDate.now().minusMonths(2L).atStartOfDay());
            CidsBean archivedBean = AenderungsanfrageUtils.getStatusBean(Status.ARCHIVED, user, metaService, connectionContext);
            AenderungsanfrageSearchStatement search = new AenderungsanfrageSearchStatement();
            search.setActive(Boolean.TRUE);
            Collection mons = AenderungsanfrageUtils.execSearch((CidsServerSearch)search, user, metaService);
            for (MetaObjectNode mon : mons) {
                Timestamp expiration;
                StacEntry stacEntry;
                CidsBean aenderungsanfrageBean = metaService.getMetaObject(user, mon.getObjectId(), mon.getClassId(), connectionContext).getBean();
                Integer stacId = (Integer)aenderungsanfrageBean.getProperty("stac_id");
                if (stacId == null || (stacEntry = StacUtils.getStacEntry(stacId, metaService, connectionContext)) == null || (expiration = stacEntry.getExpiration()) == null || !now.after(expiration)) continue;
                aenderungsanfrageBean.setProperty("status", (Object)archivedBean);
                DomainServerImpl.getServerInstance().updateMetaObject(user, aenderungsanfrageBean.getMetaObject(), connectionContext);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public static boolean isNewCitizenMessage(AenderungsanfrageJson aenderungsanfrage) {
        boolean lastIsCitizen = false;
        if (aenderungsanfrage != null && aenderungsanfrage.getNachrichten() != null) {
            for (NachrichtJson nachricht : aenderungsanfrage.getNachrichten()) {
                if (nachricht == null || Boolean.TRUE.equals(nachricht.getDraft())) continue;
                lastIsCitizen = NachrichtJson.Typ.CITIZEN.equals((Object)nachricht.getTyp());
            }
        }
        return lastIsCitizen;
    }

    public static String createChatHtmlFromAenderungsanfrage(AenderungsanfrageJson anfrage, int fontSize, boolean showSystem, boolean linkOrButton, boolean anon) throws Exception {
        String mainTemplate = IOUtils.toString((URL)AenderungsanfrageUtils.class.getResource("/de/cismet/verdis/server/utils/main.template"), (String)"UTF-8");
        String msgTemplate = IOUtils.toString((URL)AenderungsanfrageUtils.class.getResource("/de/cismet/verdis/server/utils/msg.template"), (String)"UTF-8");
        String timeHeaderTemplate = IOUtils.toString((URL)AenderungsanfrageUtils.class.getResource("/de/cismet/verdis/server/utils/timeHeader.template"), (String)"UTF-8");
        String attachmentLinkTemplate = IOUtils.toString((URL)AenderungsanfrageUtils.class.getResource("/de/cismet/verdis/server/utils/attachmentLink.template"), (String)"UTF-8");
        String attachmentButtonTemplate = IOUtils.toString((URL)AenderungsanfrageUtils.class.getResource("/de/cismet/verdis/server/utils/attachmentButton.template"), (String)"UTF-8");
        String styleTemplate = IOUtils.toString((URL)AenderungsanfrageUtils.class.getResource("/de/cismet/verdis/server/utils/style.template"), (String)"UTF-8");
        String attachmentPngbase64 = Base64.getEncoder().encodeToString(IOUtils.toByteArray((URL)AenderungsanfrageUtils.class.getResource("/de/cismet/verdis/server/utils/attachment.png")));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.YYYY - HH:mm");
        SimpleDateFormat sameDateFormat = new SimpleDateFormat("hh:mm");
        StringBuffer chatSb = new StringBuffer();
        if (anfrage != null && anfrage.getNachrichten() != null) {
            NachrichtJson nachrichtBefore = null;
            for (NachrichtJson nachricht : anfrage.getNachrichten()) {
                String content;
                String clazz;
                if (NachrichtJson.Typ.CITIZEN.equals((Object)nachricht.getTyp()) && Boolean.TRUE.equals(nachricht.getDraft()) || NachrichtJson.Typ.SYSTEM.equals((Object)nachricht.getTyp()) && !showSystem) continue;
                switch (nachricht.getTyp()) {
                    case CITIZEN: {
                        clazz = "sent";
                        break;
                    }
                    case CLERK: {
                        clazz = "rcvd";
                        break;
                    }
                    case SYSTEM: {
                        clazz = "sys";
                        break;
                    }
                    default: {
                        clazz = null;
                    }
                }
                if (NachrichtJson.Typ.SYSTEM.equals((Object)nachricht.getTyp())) {
                    NachrichtParameterJson nachrichtenParameter = nachricht.getNachrichtenParameter();
                    if (nachrichtenParameter != null && nachrichtenParameter.getType() != null) {
                        block5 : switch (nachrichtenParameter.getType()) {
                            case STATUS: {
                                Status status = nachrichtenParameter.getStatus();
                                switch (status) {
                                    case CLOSED: {
                                        content = anon ? "Die Bearbeitung wurde gesperrt." : String.format("Die Bearbeitung wurde durch '%s' gesperrt.", nachricht.getAbsender());
                                        break block5;
                                    }
                                    case NONE: {
                                        content = anon ? "Die Bearbeitung wurde abgeschlossen." : String.format("Die Bearbeitung wurde von '%s' abgeschlossen.", nachricht.getAbsender());
                                        break block5;
                                    }
                                    case PROCESSING: {
                                        content = anon ? "Die Bearbeitung wurde aufgenommen." : String.format("Die Bearbeitung wurde von '%s' aufgenommen.", nachricht.getAbsender());
                                        break block5;
                                    }
                                    case PENDING: {
                                        content = "Es wurden neue \u00c4nderungen eingereicht.";
                                        break block5;
                                    }
                                }
                                content = null;
                                break;
                            }
                            case CHANGED: 
                            case REJECTED: {
                                Integer groesse = nachrichtenParameter.getGroesse();
                                FlaecheFlaechenartJson flaechenart = nachrichtenParameter.getFlaechenart();
                                FlaecheAnschlussgradJson anschlussgrad = nachrichtenParameter.getAnschlussgrad();
                                boolean accepted = NachrichtParameterJson.Type.CHANGED.equals((Object)nachrichtenParameter.getType());
                                if (groesse != null) {
                                    content = anon ? String.format("Die \u00c4nderung der Gr\u00f6\u00dfe der Fl\u00e4che '%s' auf %dm\u00b2 wurde %s.", nachrichtenParameter.getFlaeche(), groesse, accepted ? "angenommen" : "abgelehnt") : String.format("Die \u00c4nderung der Gr\u00f6\u00dfe der Fl\u00e4che '%s' auf %dm\u00b2 wurde von '%s' %s.", nachrichtenParameter.getFlaeche(), groesse, nachricht.getAbsender(), accepted ? "angenommen" : "abgelehnt");
                                    break;
                                }
                                if (flaechenart != null) {
                                    content = anon ? String.format("Die \u00c4nderung der Fl\u00e4chenart der Fl\u00e4che '%s' auf '%s' wurde %s.", nachrichtenParameter.getFlaeche(), flaechenart.getArt(), accepted ? "angenommen" : "abgelehnt") : String.format("Die \u00c4nderung der Fl\u00e4chenart der Fl\u00e4che '%s' auf '%s' wurde von '%s' %s.", nachrichtenParameter.getFlaeche(), flaechenart.getArt(), nachricht.getAbsender(), accepted ? "angenommen" : "abgelehnt");
                                    break;
                                }
                                if (anschlussgrad != null) {
                                    content = anon ? String.format("Die \u00c4nderung des Anschlussgrads der Fl\u00e4che '%s' auf '%s' wurde %s.", nachrichtenParameter.getFlaeche(), anschlussgrad.getGrad(), accepted ? "angenommen" : "abgelehnt") : String.format("Die \u00c4nderung des Anschlussgrads der Fl\u00e4che '%s' auf '%s' wurde von '%s' %s.", nachrichtenParameter.getFlaeche(), anschlussgrad.getGrad(), nachricht.getAbsender(), accepted ? "angenommen" : "abgelehnt");
                                    break;
                                }
                                content = null;
                                break;
                            }
                            case NOTIFY: {
                                boolean benachrichtigt = Boolean.TRUE.equals(nachrichtenParameter.getBenachrichtigt());
                                content = anon ? String.format("Eine \u00c4nderungs-Benachrichtigung wurde %s.", benachrichtigt ? "versandt" : "angefordet") : String.format("Eine \u00c4nderungs-Benachrichtigung von '%s' wurde %s.", nachricht.getAbsender(), benachrichtigt ? "versandt" : "angefordet");
                                break;
                            }
                            case SEEN: {
                                content = anon ? "Letzte Nachricht wurde als gelesen markiert." : String.format("Letzte Nachricht wurde von %s als gelesen markiert.", nachricht.getAbsender());
                                break;
                            }
                            default: {
                                content = null;
                                break;
                            }
                        }
                    } else {
                        content = null;
                    }
                } else {
                    String string = content = nachricht.getNachricht() != null ? nachricht.getNachricht().replaceAll(Pattern.quote("\n"), "<br/>\n") : "";
                }
                String timeHeader = Boolean.TRUE.equals(nachricht.getDraft()) ? "Entwurf" : (nachricht.getTimestamp() == null ? timeHeaderTemplate.replaceAll("<!--time-->", "") : (nachrichtBefore != null && nachricht.getTimestamp().getTime() - nachrichtBefore.getTimestamp().getTime() < 60000L && nachrichtBefore.getTyp() == nachricht.getTyp() ? "" : (nachrichtBefore != null && DateUtils.isSameDay((Date)nachricht.getTimestamp(), (Date)nachrichtBefore.getTimestamp()) && nachrichtBefore.getTyp() == nachricht.getTyp() ? timeHeaderTemplate.replaceAll("<!--time-->", sameDateFormat.format(nachricht.getTimestamp())) : timeHeaderTemplate.replaceAll("<!--time-->", dateFormat.format(nachricht.getTimestamp())))));
                StringBuffer attachmentsSb = new StringBuffer();
                for (NachrichtAnhangJson anhang : nachricht.getAnhang()) {
                    String anhangJson = anhang.toJson().replaceAll("\"", "&quot;");
                    attachmentsSb.append(linkOrButton ? attachmentLinkTemplate.replaceAll(Pattern.quote("<!--name-->"), anhang.getName()) : attachmentButtonTemplate.replaceAll(Pattern.quote("<!--json-->"), anhangJson).replaceAll(Pattern.quote("<!--name-->"), anhang.getName()));
                }
                String attachments = attachmentsSb.toString();
                String msg = msgTemplate.replaceAll(Pattern.quote("<!--time-header-->"), timeHeader != null ? timeHeader : "").replaceAll(Pattern.quote("<!--class-->"), clazz != null ? clazz : null).replaceAll(Pattern.quote("<!--content-->"), content != null ? content : "").replaceAll(Pattern.quote("<!--attachments-->"), attachments != null ? attachments : "");
                chatSb.append(msg);
                nachrichtBefore = nachricht;
            }
        }
        String title = String.format("%d", anfrage != null ? anfrage.getKassenzeichen() : 0);
        String css = styleTemplate.replaceAll(Pattern.quote("/*font-size*/"), String.format("%dpx", fontSize)).replaceAll(Pattern.quote("/*attachmentBase64*/"), attachmentPngbase64);
        String chat = chatSb.toString();
        String html = mainTemplate.replaceAll(Pattern.quote("<!--title-->"), title).replaceAll(Pattern.quote("/*css*/"), css).replaceAll(Pattern.quote("<!--info-->"), "").replaceAll(Pattern.quote("<!--chat-->"), chat);
        return html;
    }

    public static void main(String[] args) throws Exception {
        AenderungsanfrageJson anfrage = AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson("...");
        String html = AenderungsanfrageUtils.createChatHtmlFromAenderungsanfrage(anfrage, 14, true, false, true);
        System.out.println(html);
        IOUtils.write((String)html, (OutputStream)new FileOutputStream("/tmp/chat/index.html"), (String)"UTF-8");
    }

    public static AenderungsanfrageUtils getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public void setUnitTestContext(boolean unitTestContext) {
        this.unitTestContext = unitTestContext;
    }

    private static final class LazyInitialiser {
        private static final AenderungsanfrageUtils INSTANCE = new AenderungsanfrageUtils();

        private LazyInitialiser() {
        }
    }

    public static class EmailVerification {
        private final String email;
        private final String code;

        public String getEmail() {
            return this.email;
        }

        public String getCode() {
            return this.code;
        }

        public EmailVerification(String email, String code) {
            this.email = email;
            this.code = code;
        }
    }

    public static enum Status {
        NONE,
        PENDING,
        PROCESSING,
        CLOSED,
        ARCHIVED;

    }
}

