/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.verdis.server.action.PreExistingStacException;
import de.cismet.verdis.server.json.StacOptionsDurationJson;
import de.cismet.verdis.server.search.KassenzeichenSearchStatement;
import de.cismet.verdis.server.search.StacInfoSearchStatement;
import de.cismet.verdis.server.utils.StacUtils;
import de.cismet.verdis.server.utils.VerdisServerResources;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CreateAStacForKassenzeichenServerAction
implements MetaServiceStore,
UserAwareServerAction,
ServerAction,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(CreateAStacForKassenzeichenServerAction.class);
    public static final String TASKNAME = "createAStacForKassenzeichen";
    private User user;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public Object execute(Object object, ServerActionParameter ... params) {
        String kassenzeichen = null;
        Integer kassenzeichenId = null;
        Integer durationValue = null;
        StacOptionsDurationJson.Unit durationUnit = null;
        String userName = null;
        Timestamp expiration = null;
        Boolean expirePreExisting = null;
        try {
            StacOptionsDurationJson duration;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    Object value = sap.getValue();
                    if (sap.getKey().equals(Parameter.USER.toString())) {
                        userName = (String)value;
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.KASSENZEICHEN.toString())) {
                        kassenzeichen = (String)value;
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.KASSENZEICHEN_ID.toString())) {
                        kassenzeichenId = value instanceof Integer ? (Integer)value : Integer.parseInt((String)value);
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.DURATION_VALUE.toString())) {
                        durationValue = value instanceof Integer ? (Integer)value : Integer.parseInt((String)value);
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.DURATION_UNIT.toString())) {
                        durationUnit = value instanceof StacOptionsDurationJson.Unit ? (StacOptionsDurationJson.Unit)((Object)value) : StacOptionsDurationJson.Unit.valueOf((String)value);
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.EXPIRATION.toString())) {
                        expiration = value instanceof Timestamp ? (Timestamp)value : new Timestamp(Long.parseLong((String)value));
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.EXPIRE_PRE_EXISTING.toString())) continue;
                    expirePreExisting = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
                }
            }
            StacOptionsDurationJson stacOptionsDurationJson = duration = durationUnit != null && durationValue != null ? new StacOptionsDurationJson(durationUnit, durationValue) : null;
            if (duration != null) {
                expiration = StacUtils.createTimestampFrom(duration);
            }
            if (kassenzeichenId == null && kassenzeichen != null) {
                KassenzeichenSearchStatement search = new KassenzeichenSearchStatement(kassenzeichen);
                HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
                localServers.put("VERDIS_GRUNDIS", this.getMetaService());
                search.setActiveLocalServers(localServers);
                search.setUser(this.getUser());
                Collection<MetaObjectNode> mons = search.performServerSearch();
                if (mons != null && mons.size() == 1) {
                    MetaObjectNode mon = mons.iterator().next();
                    MetaObject mo = this.getMetaService().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                    kassenzeichenId = mo.getId();
                }
            }
            if (userName == null) {
                userName = this.getUser().getName();
            }
            Properties properties = ServerResourcesLoader.getInstance().loadProperties(VerdisServerResources.CREATE_STAC_FOR_A_KASSENZEICHEN_ACTION_PROPERTIES.getValue());
            StacInfoSearchStatement search = new StacInfoSearchStatement(StacInfoSearchStatement.SearchBy.KASSENZEICHEN_ID);
            search.setKassenzeichenId(kassenzeichenId);
            HashMap<String, MetaService> activeLocalServers = new HashMap<String, MetaService>();
            activeLocalServers.put("VERDIS_GRUNDIS", this.getMetaService());
            search.setActiveLocalServers(activeLocalServers);
            search.setUser(this.getUser());
            search.initWithConnectionContext(this.getConnectionContext());
            search.setActiveLocalServers(activeLocalServers);
            Collection<Map> col = search.performServerSearch();
            if (col != null) {
                Date now = new Date();
                for (Map row : col) {
                    if (row == null) continue;
                    Integer stacId = (Integer)row.get((Object)StacInfoSearchStatement.Fields.ID);
                    Timestamp expirationPreExisting = (Timestamp)row.get((Object)StacInfoSearchStatement.Fields.EXPIRATION);
                    if (!now.before(expirationPreExisting)) continue;
                    if (Boolean.TRUE.equals(expirePreExisting)) {
                        StacUtils.updateStacExpiration(stacId, new Timestamp(now.getTime()), this.getMetaService(), this.getConnectionContext());
                        continue;
                    }
                    throw new PreExistingStacException(expirationPreExisting);
                }
            }
            return StacUtils.createStac(kassenzeichenId, properties.getProperty("baseLoginName", userName), userName, expiration, duration);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public static enum Parameter {
        USER,
        EXPIRATION,
        DURATION_VALUE,
        DURATION_UNIT,
        KASSENZEICHEN,
        KASSENZEICHEN_ID,
        EXPIRE_PRE_EXISTING;

    }
}

