/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.verdis.server.action.EBReportServerAction;
import de.cismet.verdis.server.utils.StacEntry;
import de.cismet.verdis.server.utils.StacUtils;
import de.cismet.verdis.server.utils.VerdisServerResources;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GetMyFebViaStacServerAction
implements MetaServiceStore,
UserAwareServerAction,
ServerAction,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(GetMyFebViaStacServerAction.class);
    public static final String TASKNAME = "getMyFEB";
    private User user;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Object execute(Object object, ServerActionParameter ... params) {
        Body bodyType = Body.BYTE_ARRAY;
        String stac = "";
        try {
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.BODY.toString())) {
                        bodyType = Body.valueOf((String)sap.getValue());
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.STAC.toString())) continue;
                    stac = (String)sap.getValue();
                }
            }
            if (stac == null && object == null) {
                throw new Exception("no stac given");
            }
            if (bodyType == null) {
                throw new Exception("body-type parameter is null");
            }
            if (object != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("object=" + object));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("body=" + (Object)((Object)bodyType)));
                }
                switch (bodyType) {
                    case BYTE_ARRAY: {
                        stac = new String((byte[])object);
                        break;
                    }
                    case STRING: {
                        stac = (String)object;
                        break;
                    }
                    default: {
                        stac = null;
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("STAC=" + stac));
            }
            if (stac == null) {
                throw new Exception("STAC is null");
            }
            return this.createReport(stac);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error during GetMyFebViaStacServerAction.execute()", (Throwable)ex);
            return "{\"nothing\":\"at all\"}";
        }
    }

    private byte[] createReport(String stac) throws Exception {
        StacEntry stacEntry = StacUtils.getStacEntry(stac, this.getMetaService(), this.getConnectionContext());
        CidsBean kassenzeichenBean = StacUtils.getKassenzeichenBean(stacEntry, this.getMetaService(), this.getConnectionContext());
        Properties properties = ServerResourcesLoader.getInstance().loadProperties(VerdisServerResources.GET_MY_FEB_VIA_STAC_ACTION_PROPERTIES.getValue());
        Integer kassenzeichenNummer = (Integer)kassenzeichenBean.getProperty("kassenzeichennummer8");
        EBReportServerAction.Type type = properties.getProperty("type") != null ? EBReportServerAction.Type.valueOf(properties.getProperty("type")) : null;
        EBReportServerAction.MapFormat mapFormat = properties.getProperty("mapFormat") != null ? EBReportServerAction.MapFormat.valueOf(properties.getProperty("mapFormat")) : null;
        String hints = properties.getProperty("hints");
        Double mapScale = properties.getProperty("mapScale") != null ? Double.valueOf(properties.getProperty("mapScale")) : null;
        Boolean abflusswirksamkeit = properties.getProperty("abflusswirksamkeit") != null ? Boolean.valueOf(properties.getProperty("abflusswirksamkeit")) : null;
        return EBReportServerAction.createReport(kassenzeichenNummer, type, mapFormat, hints, mapScale, abflusswirksamkeit);
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public static enum Body {
        STRING,
        BYTE_ARRAY;

    }

    public static enum Parameter {
        BODY,
        RETURN,
        STAC;

    }
}

