/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.commons.security.WebDavClient;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.netutil.ProxyHandler;
import de.cismet.verdis.server.json.NachrichtAnhangUploadJson;
import de.cismet.verdis.server.utils.AenderungsanfrageConf;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import de.cismet.verdis.server.utils.StacEntry;
import de.cismet.verdis.server.utils.StacUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.UUID;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class UploadChangeRequestAnhangServerAction
implements MetaServiceStore,
UserAwareServerAction,
ServerAction,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(UploadChangeRequestAnhangServerAction.class);
    public static final String TASKNAME = "uploadChangeRequestAnhang";
    private User user;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    private static int upload(String uploadFilePath, byte[] bytes, AenderungsanfrageConf conf) throws Exception {
        ByteArrayInputStream data = new ByteArrayInputStream(bytes);
        WebDavClient webdavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), conf.getWebdavUser(), conf.getWebdavPassword());
        return webdavClient.put(uploadFilePath, (InputStream)data);
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        String fileName = null;
        String stac = null;
        boolean waitForSuccess = true;
        try {
            int status;
            if (body == null) {
                throw new Exception("body can't be null");
            }
            final byte[] bytes = (byte[])body;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    String key = sap.getKey();
                    Object value = sap.getValue();
                    if (Parameter.STAC.toString().equalsIgnoreCase(key)) {
                        stac = (String)value;
                        continue;
                    }
                    if (Parameter.FILENAME.toString().equalsIgnoreCase(key)) {
                        fileName = (String)value;
                        continue;
                    }
                    if (!Parameter.WAIT_FOR_SUCCESS.toString().equalsIgnoreCase(key)) continue;
                    if (value instanceof String) {
                        waitForSuccess = Boolean.parseBoolean((String)value);
                        continue;
                    }
                    if (!(value instanceof Boolean)) continue;
                    waitForSuccess = (Boolean)value;
                }
            }
            if (stac == null) {
                throw new StatusException(412, String.format("Parameter '%s' nicht gesetzt", Parameter.STAC.toString()));
            }
            if (fileName == null) {
                throw new StatusException(412, String.format("Parameter '%s' nicht gesetzt", Parameter.FILENAME.toString()));
            }
            StacEntry stacEntry = StacUtils.getStacEntry(stac, this.getMetaService(), this.getConnectionContext());
            if (stacEntry == null) {
                throw new StatusException(412, "STAC ist ung\u00fcltig");
            }
            String uuid = UUID.randomUUID().toString();
            final AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
            String webdavUrl = conf.getWebdavUrl();
            String uploadDirPath = webdavUrl.endsWith("/") ? webdavUrl : webdavUrl + "/";
            final String uploadFilePath = String.format("%s%s_%s", uploadDirPath, uuid, URLEncoder.encode(fileName, "utf-8").replaceAll("\\+", "%20"));
            if (waitForSuccess) {
                status = UploadChangeRequestAnhangServerAction.upload(uploadFilePath, bytes, conf);
                if (status != 201) {
                    LOG.error((Object)String.format("upload to %s failed with status code %d", uploadFilePath, status));
                    throw new StatusException(status, "Upload fehlgeschlagen");
                }
            } else {
                status = 202;
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        UploadChangeRequestAnhangServerAction.upload(uploadFilePath, bytes, conf);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                        }
                    }
                }.execute();
            }
            NachrichtAnhangUploadJson returnJson = new NachrichtAnhangUploadJson(status, null, fileName, uuid);
            return returnJson.toJson();
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            return new NachrichtAnhangUploadJson(ex instanceof StatusException ? ((StatusException)ex).getStatus() : 500, ex.getMessage());
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    private static class StatusException
    extends Exception {
        private final int status;

        public StatusException(int status, String message) {
            super(message);
            this.status = status;
        }

        public StatusException(int status, String message, Throwable cause) {
            super(message, cause);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static enum Parameter {
        STAC,
        FILENAME,
        WAIT_FOR_SUCCESS;

    }
}

