/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.jsondeserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.cismet.verdis.server.json.AenderungsanfrageJson;
import de.cismet.verdis.server.json.FlaecheAenderungJson;
import de.cismet.verdis.server.json.NachrichtJson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geojson.GeoJsonObject;

public class AenderungsanfrageDeserializer
extends StdDeserializer<AenderungsanfrageJson> {
    private final ObjectMapper objectMapper;

    public AenderungsanfrageDeserializer(ObjectMapper objectMapper) {
        super(AenderungsanfrageJson.class);
        this.objectMapper = objectMapper;
    }

    public AenderungsanfrageJson deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        Boolean submission;
        Boolean emailVerifiziert;
        ObjectNode on = (ObjectNode)jp.readValueAsTree();
        Integer kassenzeichen = on.has("kassenzeichen") && on.get("kassenzeichen").isInt() ? Integer.valueOf(on.get("kassenzeichen").asInt()) : null;
        ArrayList<NachrichtJson> nachrichten = new ArrayList<NachrichtJson>();
        String emailAdresse = on.has("emailAdresse") && on.get("emailAdresse").isTextual() ? on.get("emailAdresse").asText() : null;
        String emailVerifikation = on.has("emailVerifikation") && on.get("emailVerifikation").isTextual() ? on.get("emailVerifikation").asText() : null;
        Boolean bl = emailVerifiziert = on.has("emailVerifiziert") && on.get("emailVerifiziert").isBoolean() ? Boolean.valueOf(on.get("emailVerifiziert").asBoolean()) : null;
        if (on.has("nachrichten") && on.get("nachrichten").isArray()) {
            Iterator iterator = on.get("nachrichten").iterator();
            while (iterator.hasNext()) {
                nachrichten.add((NachrichtJson)this.objectMapper.treeToValue((TreeNode)iterator.next(), NachrichtJson.class));
            }
        }
        HashMap<String, FlaecheAenderungJson> flaechen = new HashMap<String, FlaecheAenderungJson>();
        if (on.has("flaechen") && on.get("flaechen").isObject()) {
            Iterator fieldIterator = on.get("flaechen").fields();
            while (fieldIterator.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)fieldIterator.next();
                String bezeichnung = (String)fieldEntry.getKey();
                if (bezeichnung == null) {
                    throw new RuntimeException("flaeche key is null");
                }
                flaechen.put(bezeichnung, (FlaecheAenderungJson)this.objectMapper.treeToValue((TreeNode)fieldEntry.getValue(), FlaecheAenderungJson.class));
            }
        }
        HashMap<String, GeoJsonObject> geometrien = new HashMap<String, GeoJsonObject>();
        if (on.has("geometrien") && on.get("geometrien").isObject()) {
            Iterator fieldIterator = on.get("geometrien").fields();
            while (fieldIterator.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)fieldIterator.next();
                String bezeichnung = (String)fieldEntry.getKey();
                geometrien.put(bezeichnung, (GeoJsonObject)this.objectMapper.treeToValue((TreeNode)fieldEntry.getValue(), GeoJsonObject.class));
            }
        }
        Boolean bl2 = submission = on.has("submission") && on.get("submission").isBoolean() ? Boolean.valueOf(on.get("submission").asBoolean()) : null;
        if (kassenzeichen == null) {
            throw new RuntimeException("invalid AnfrageJson: kassenzeichen is missing");
        }
        return new AenderungsanfrageJson(kassenzeichen, emailAdresse, emailVerifikation, emailVerifiziert, flaechen, geometrien, nachrichten, submission);
    }
}

