/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.jsondeserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.cismet.verdis.server.json.FlaecheAnschlussgradJson;
import de.cismet.verdis.server.json.FlaecheFlaechenartJson;
import de.cismet.verdis.server.json.NachrichtJson;
import de.cismet.verdis.server.json.NachrichtParameterJson;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import java.io.IOException;

public class NachrichtParameterDeserializer
extends StdDeserializer<NachrichtParameterJson> {
    private final ObjectMapper objectMapper;

    public NachrichtParameterDeserializer(ObjectMapper objectMapper) {
        super(NachrichtJson.class);
        this.objectMapper = objectMapper;
    }

    public NachrichtParameterJson deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        Boolean verlaengern;
        ObjectNode on = (ObjectNode)jp.readValueAsTree();
        NachrichtParameterJson.Type type = on.has("type") ? NachrichtParameterJson.Type.valueOf(on.get("type").textValue()) : null;
        AenderungsanfrageUtils.Status status = on.has("status") ? AenderungsanfrageUtils.Status.valueOf(on.get("status").textValue()) : null;
        String flaeche = on.has("flaeche") ? on.get("flaeche").asText() : null;
        Integer groesse = on.has("groesse") ? Integer.valueOf(on.get("groesse").asInt()) : null;
        FlaecheFlaechenartJson flaechenart = on.has("flaechenart") ? (FlaecheFlaechenartJson)this.objectMapper.treeToValue((TreeNode)on.get("flaechenart"), FlaecheFlaechenartJson.class) : null;
        FlaecheAnschlussgradJson anschlussgrad = on.has("anschlussgrad") ? (FlaecheAnschlussgradJson)this.objectMapper.treeToValue((TreeNode)on.get("anschlussgrad"), FlaecheAnschlussgradJson.class) : null;
        Boolean benachrichtigt = on.has("benachrichtigt") ? Boolean.valueOf(on.get("benachrichtigt").booleanValue()) : null;
        Boolean bl = verlaengern = on.has("verlaengert") ? Boolean.valueOf(on.get("verlaengert").booleanValue()) : null;
        if (type == null) {
            throw new RuntimeException("invalid NachrichtSystemParametersJson: type has to be is set");
        }
        switch (type) {
            case STATUS: {
                if (status != null) break;
                throw new RuntimeException("invalid NachrichtSystemParametersJson: status has to be is set");
            }
            case CHANGED: 
            case REJECTED: {
                if (groesse != null || flaechenart != null || anschlussgrad != null) break;
                throw new RuntimeException("invalid NachrichtSystemParametersJson: neither groesse nor flaechenart nor anschlussgrad is set");
            }
            case NOTIFY: {
                if (benachrichtigt != null) break;
                throw new RuntimeException("invalid NachrichtSystemParametersJson: benachrichtigt has to be set");
            }
            case PROLONG: {
                if (verlaengern != null) break;
                throw new RuntimeException("invalid NachrichtSystemParametersJson: verlaengern has to be set");
            }
        }
        return new NachrichtParameterJson(type, status, flaeche, groesse, flaechenart, anschlussgrad, benachrichtigt, verlaengern);
    }
}

