/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.verdis.server.search.GeomServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.postgis.Geometry;
import org.postgis.PGgeometry;

public class AssignLandparcelGeomSearch
extends GeomServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AssignLandparcelGeomSearch.class);

    @Override
    public String getCrs() {
        return "EPSG:25832";
    }

    public Collection performServerSearch() {
        try {
            MetaService metaService;
            ArrayList results;
            com.vividsolutions.jts.geom.Geometry geometry = this.getGeometry();
            String sql = "SELECT    st_ASTEXT(alkis_landparcel.geometrie),    alkis_landparcel.alkis_id FROM    alkis_landparcel WHERE    ST_Within(ST_GeomFromText('" + geometry.toText() + "', " + geometry.getSRID() + "), alkis_landparcel.geometrie)";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)sql);
            }
            if (!(results = (metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU")).performCustomSearch(sql)).isEmpty()) {
                ArrayList<Object> data = new ArrayList<Object>();
                for (ArrayList result : results) {
                    String geomString = (String)result.get(0);
                    String bezeichnung = (String)result.get(1);
                    PGgeometry pgGeometry = new PGgeometry(geomString);
                    com.vividsolutions.jts.geom.Geometry geom = PostGisGeometryFactory.createJtsGeometry((Geometry)pgGeometry.getGeometry());
                    data.add(geom);
                    data.add(bezeichnung);
                }
                return data;
            }
            return null;
        }
        catch (Exception e) {
            LOG.fatal((Object)"problem during landparcel search", (Throwable)e);
            return null;
        }
    }
}

