/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BuchungsblattLanparcelsGeomServerSearch
extends AbstractCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(BuchungsblattLanparcelsGeomServerSearch.class);
    private static final float FLURSTUECKBUFFER_FOR_KASSENZEICHEN_GEOMSEARCH = -0.1f;
    String searchQuery = "";

    public BuchungsblattLanparcelsGeomServerSearch(String bbcode) {
        this.searchQuery = "SELECT st_astext(ST_SimplifyPreserveTopology(st_union(st_buffer(alkis_buchungsblatt_landparcel.geometrie, -0.1)), 0.1)), st_srid(max(alkis_buchungsblatt_landparcel.geometrie)) FROM alkis_buchungsblatt, alkis_buchungsblatt_to_buchungsblattlandparcels, alkis_buchungsblatt_landparcel WHERE alkis_buchungsblatt.landparcels = alkis_buchungsblatt_to_buchungsblattlandparcels.buchungsblatt_reference AND alkis_buchungsblatt_to_buchungsblattlandparcels.buchungsblatt_landparcel = alkis_buchungsblatt_landparcel.id AND alkis_buchungsblatt.buchungsblattcode ILIKE '" + bbcode + "' GROUP BY alkis_buchungsblatt.id";
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                ArrayList lists = ms.performCustomSearch(this.searchQuery);
                if (lists.isEmpty()) {
                    return lists;
                }
                return (Collection)lists.get(0);
            }
            catch (RemoteException ex) {
                LOG.error((Object)"error while performing custom server search", (Throwable)ex);
            }
        }
        return null;
    }

    public String toString() {
        return this.searchQuery;
    }
}

