/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.verdis.server.utils.VerdisServerResources;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class EBReportServerAction
implements UserAwareServerAction,
MetaServiceStore,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(EBReportServerAction.class);
    public static final String TASK_NAME = "EBReport";
    public static final String NULL_VALUE = "_null_";
    private User user;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    private static String executeCmd(String cmd) throws Exception {
        ProcessBuilder builder = new ProcessBuilder("/bin/sh", "-c", cmd);
        Process process = builder.start();
        InputStream is = process.getInputStream();
        return IOUtils.toString((Reader)new InputStreamReader(is));
    }

    public Object execute(Object object, ServerActionParameter ... params) {
        Body body = Body.INTEGER;
        Type type = Type.FLAECHEN;
        MapFormat mapFormat = MapFormat.A4LS;
        String hints = "";
        Boolean abflusswirksamkeit = false;
        Double scaleDenominator = null;
        try {
            Integer kassenzeichen;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    Object value = sap.getValue();
                    if (sap.getKey().equals(Parameter.BODY.toString())) {
                        body = value instanceof Body ? (Body)((Object)value) : Body.valueOf((String)value);
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.TYPE.toString())) {
                        type = value instanceof Type ? (Type)((Object)value) : Type.valueOf((String)value);
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.MAP_FORMAT.toString())) {
                        mapFormat = value instanceof MapFormat ? (MapFormat)((Object)value) : MapFormat.valueOf((String)value);
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.HINTS.toString())) {
                        hints = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.MAP_SCALE.toString())) {
                        scaleDenominator = value instanceof Double ? (Double)value : Double.valueOf((String)value);
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.ABLUSSWIRKSAMKEIT.toString())) continue;
                    abflusswirksamkeit = value instanceof Boolean ? (Boolean)sap.getValue() : Boolean.valueOf((String)value);
                }
            }
            if (object == null) {
                throw new Exception("body is null");
            }
            if (body == null) {
                throw new Exception("body-type parameter is null");
            }
            switch (body) {
                case BYTE_ARRAY: {
                    kassenzeichen = new BigInteger((byte[])object).intValue();
                    break;
                }
                case STRING_AS_BYTE_ARRAY: {
                    kassenzeichen = new BigInteger(new String((byte[])object)).intValue();
                    break;
                }
                case INTEGER: {
                    kassenzeichen = (Integer)object;
                    break;
                }
                case STRING: {
                    kassenzeichen = Integer.parseInt((String)object);
                    break;
                }
                default: {
                    kassenzeichen = null;
                }
            }
            return EBReportServerAction.createReport(kassenzeichen, type, mapFormat, hints, scaleDenominator, abflusswirksamkeit);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public static byte[] createReport(Integer kassenzeichen, Type type, MapFormat mapFormat, String hints, Double scaleDenominator, Boolean abflusswirksamkeit) throws Exception {
        Properties properties = ServerResourcesLoader.getInstance().loadProperties(VerdisServerResources.EB_REPORT_ACTION_PROPERTIES.getValue());
        Properties cmdProperties = new Properties();
        FileInputStream inputStream = new FileInputStream((String)properties.get("cmdProperties"));
        cmdProperties.load(inputStream);
        String abflusswirksamkeitFlag = Boolean.TRUE.equals(abflusswirksamkeit) ? cmdProperties.getProperty("abflusswirksamkeitFlag") : "";
        String ebGeneratorCmd = cmdProperties.getProperty("cmd").replaceAll("<callserverUrl>", (String)cmdProperties.get("callserverUrl")).replaceAll("<compressionFlag>", (String)cmdProperties.get("compressionFlag")).replaceAll("<user>", (String)cmdProperties.get("user")).replaceAll("<group>", (String)cmdProperties.get("group")).replaceAll("<domain>", (String)cmdProperties.get("domain")).replaceAll("<password>", (String)cmdProperties.get("password")).replaceAll("<kassenzeichen>", String.valueOf(kassenzeichen)).replaceAll("<type>", type != null ? type.name() : NULL_VALUE).replaceAll("<mapFormat>", mapFormat != null ? mapFormat.name() : NULL_VALUE).replaceAll("<hints>", hints != null ? hints : "").replaceAll("<scaleDenominator>", scaleDenominator != null ? String.valueOf(scaleDenominator) : NULL_VALUE).replaceAll("<abflusswirksamkeitFlag>", String.valueOf(abflusswirksamkeitFlag));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)ebGeneratorCmd);
        }
        String response = EBReportServerAction.executeCmd(ebGeneratorCmd);
        return Base64.getMimeDecoder().decode(response);
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        TYPE,
        MAP_FORMAT,
        MAP_SCALE,
        ABLUSSWIRKSAMKEIT,
        HINTS,
        BODY;

    }

    public static enum Body {
        BYTE_ARRAY,
        STRING,
        INTEGER,
        STRING_AS_BYTE_ARRAY;

    }

    public static enum MapFormat {
        A4,
        A3,
        LS,
        P,
        A4LS,
        A4P,
        A3LS,
        A3P;

    }

    public static enum Type {
        FRONTEN,
        FLAECHEN;

    }
}

