/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.server.messages.CidsServerMessageManagerImpl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.verdis.server.json.AenderungsanfrageJson;
import de.cismet.verdis.server.json.AenderungsanfrageResultJson;
import de.cismet.verdis.server.json.NachrichtJson;
import de.cismet.verdis.server.json.NachrichtParameterJson;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import de.cismet.verdis.server.utils.StacEntry;
import de.cismet.verdis.server.utils.StacUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public class KassenzeichenChangeRequestServerAction
implements MetaServiceStore,
UserAwareServerAction,
ServerAction,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(KassenzeichenChangeRequestServerAction.class);
    public static final String TASKNAME = "kassenzeichenChangeRequest";
    public static final String CSM_NEWREQUEST = "newChangerequest";
    private User user;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    private Map<Parameter, Object> extractParams(ServerActionParameter[] params) throws Exception {
        HashMap<Parameter, Object> extractedParams = new HashMap<Parameter, Object>();
        if (params != null) {
            for (ServerActionParameter sap : params) {
                String key = sap.getKey();
                Object value = sap.getValue();
                if (Parameter.STAC.toString().equals(key)) {
                    extractedParams.put(Parameter.STAC, (String)value);
                    continue;
                }
                if (Parameter.STAC_ID.toString().equals(key)) {
                    extractedParams.put(Parameter.STAC_ID, (Integer)value);
                    continue;
                }
                if (Parameter.CHANGEREQUEST_JSON.toString().equals(key)) {
                    extractedParams.put(Parameter.CHANGEREQUEST_JSON, value);
                    continue;
                }
                if (!Parameter.CLERK_IS_SAVING.toString().equals(key)) continue;
                extractedParams.put(Parameter.CLERK_IS_SAVING, value);
            }
        }
        return extractedParams;
    }

    private static void preValidateInput(Map<Parameter, Object> extractedParams) throws Exception {
        String stac = (String)extractedParams.get((Object)Parameter.STAC);
        Integer stacId = (Integer)extractedParams.get((Object)Parameter.STAC_ID);
        Object aenderungsanfrage = extractedParams.get((Object)Parameter.CHANGEREQUEST_JSON);
        if (stac == null && stacId == null) {
            LOG.info((Object)"stac is null");
            throw new Exception("stac and stacId is null");
        }
        if (aenderungsanfrage == null) {
            LOG.info((Object)"aenderungsanfrage is null, returning false");
            throw new Exception("aenderungsanfrage is null");
        }
    }

    private StacEntry createStacEntry(String stac, Integer stacId) throws Exception {
        StacEntry stacEntry;
        StacEntry stacEntry2 = stacEntry = stac != null ? StacUtils.getStacEntry(stac, this.getMetaService(), this.getConnectionContext()) : StacUtils.getStacEntry(stacId, this.getMetaService(), this.getConnectionContext());
        if (stacEntry == null) {
            LOG.info((Object)"stacEntry not found, returning false");
            throw new Exception("stacEntry not found");
        }
        return stacEntry;
    }

    private CidsBean createKassenzeichenBean(StacEntry stacEntry) throws Exception {
        CidsBean kassenzeichenBean = StacUtils.getKassenzeichenBean(stacEntry, this.getMetaService(), this.getConnectionContext());
        if (kassenzeichenBean == null) {
            LOG.info((Object)"kassenzeichen for stacEntry not found, returning false");
            throw new Exception("kassenzeichen not found");
        }
        return kassenzeichenBean;
    }

    private AenderungsanfrageJson createAenderungsanfrageNew(Object aenderungsanfrage) throws Exception {
        AenderungsanfrageJson aenderungsanfrageJson;
        if (aenderungsanfrage instanceof AenderungsanfrageJson) {
            aenderungsanfrageJson = (AenderungsanfrageJson)aenderungsanfrage;
        } else if (aenderungsanfrage instanceof String) {
            aenderungsanfrageJson = AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson((String)aenderungsanfrage);
        } else if (aenderungsanfrage instanceof Map) {
            aenderungsanfrageJson = AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson((Map)aenderungsanfrage);
        } else {
            throw new Exception("aenderungsanfrage in wrong format");
        }
        return aenderungsanfrageJson;
    }

    private Integer createKassenzeichennummer(CidsBean kassenzeichenBean, AenderungsanfrageJson aenderungsanfrageJson) throws Exception {
        Integer kassenzeichenNummerFromObject;
        Integer kassenzeichenNummerFromBean = (Integer)kassenzeichenBean.getProperty("kassenzeichennummer8");
        if (!Objects.equals(kassenzeichenNummerFromBean, kassenzeichenNummerFromObject = aenderungsanfrageJson.getKassenzeichen())) {
            LOG.info((Object)String.format("kassenzeichennummer from json (%d) not equals kassenzeichennummer from bean (%d), returning false", kassenzeichenNummerFromBean, kassenzeichenNummerFromObject));
            throw new Exception("kassenzeichen of stac is not corresponding to the requested change");
        }
        return kassenzeichenNummerFromBean;
    }

    private AenderungsanfrageJson createAenderungsanfrageOrig(CidsBean aenderungsanfrageBean, Integer kassenzeichennummer) throws Exception {
        String aenderungsanfrageOrigJson = (String)aenderungsanfrageBean.getProperty("changes_json");
        AenderungsanfrageJson aenderungsanfrageOrig = aenderungsanfrageOrigJson != null ? AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson(aenderungsanfrageOrigJson) : new AenderungsanfrageJson(kassenzeichennummer);
        return aenderungsanfrageOrig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object boxy, ServerActionParameter ... params) {
        try {
            Map<Parameter, Object> extractedParams = this.extractParams(params);
            KassenzeichenChangeRequestServerAction.preValidateInput(extractedParams);
            String userName = this.getUser().getName();
            boolean citizenOrClerk = "stac".equals(userName);
            String stac = (String)extractedParams.get((Object)Parameter.STAC);
            Integer stacId = (Integer)extractedParams.get((Object)Parameter.STAC_ID);
            Object aenderungsanfrage = extractedParams.get((Object)Parameter.CHANGEREQUEST_JSON);
            Boolean veranlagt = !citizenOrClerk ? (Boolean)extractedParams.get((Object)Parameter.CLERK_IS_SAVING) : null;
            StacEntry stacEntry = this.createStacEntry(stac, stacId);
            AenderungsanfrageJson aenderungsanfrageJson = this.createAenderungsanfrageNew(aenderungsanfrage);
            CidsBean kassenzeichenBean = this.createKassenzeichenBean(stacEntry);
            Integer kassenzeichennummer = this.createKassenzeichennummer(kassenzeichenBean, aenderungsanfrageJson);
            Boolean submission = aenderungsanfrageJson.getSubmission();
            this.removeDoublesFromAenderungsanfrage(aenderungsanfrageJson);
            HashMap<String, CidsBean> existingFlaechen = new HashMap<String, CidsBean>();
            for (CidsBean flaecheBean : kassenzeichenBean.getBeanCollectionProperty("flaechen")) {
                String flaechenBezeichnung = (String)flaecheBean.getProperty("flaechenbezeichnung");
                if (flaechenBezeichnung == null) continue;
                existingFlaechen.put(flaechenBezeichnung.toUpperCase(), flaecheBean);
            }
            KassenzeichenChangeRequestServerAction kassenzeichenChangeRequestServerAction = this;
            synchronized (kassenzeichenChangeRequestServerAction) {
                AenderungsanfrageUtils.Status newStatus;
                String statusSchluessel;
                CidsBean aenderungsanfrageBean;
                Date now = new Date();
                CidsBean existingAenderungsanfrageBean = AenderungsanfrageUtils.getInstance().getAenderungsanfrageBean(stacEntry, this.getMetaService(), this.getConnectionContext());
                if (existingAenderungsanfrageBean != null) {
                    aenderungsanfrageBean = existingAenderungsanfrageBean;
                } else {
                    aenderungsanfrageBean = CidsBean.createNewCidsBeanFromTableName((String)"VERDIS_GRUNDIS", (String)"aenderungsanfrage", (ConnectionContext)this.getConnectionContext());
                    AenderungsanfrageUtils.getInstance();
                    aenderungsanfrageBean.setProperty("status", (Object)AenderungsanfrageUtils.getStatusBean(AenderungsanfrageUtils.Status.NONE, stacEntry, this.getMetaService(), this.getConnectionContext()));
                    aenderungsanfrageBean.setProperty("clerk_username", (Object)stacEntry.getStacOptions().getCreatorUserName());
                }
                String string = aenderungsanfrageBean.getProperty("status") != null ? (String)aenderungsanfrageBean.getProperty("status" + ".schluessel") : (statusSchluessel = null);
                if (AenderungsanfrageUtils.Status.CLOSED.toString().equals(statusSchluessel)) {
                    throw new Exception("status is CLOSED");
                }
                AenderungsanfrageJson aenderungsanfrageOrig = this.createAenderungsanfrageOrig(aenderungsanfrageBean, kassenzeichennummer);
                AenderungsanfrageJson aenderungsanfrageProcessed = AenderungsanfrageUtils.getInstance().doProcessing(stacEntry, kassenzeichennummer, existingFlaechen, aenderungsanfrageOrig, aenderungsanfrageJson, citizenOrClerk, veranlagt, userName, now, this.getMetaService(), this.getConnectionContext());
                AenderungsanfrageUtils.Status oldStatus = statusSchluessel != null ? AenderungsanfrageUtils.Status.valueOf(statusSchluessel) : null;
                AenderungsanfrageUtils.Status status = AenderungsanfrageUtils.getInstance().identifyNewStatus(oldStatus, existingFlaechen, aenderungsanfrageOrig, aenderungsanfrageProcessed, citizenOrClerk, veranlagt, userName, now);
                AenderungsanfrageUtils.getInstance().addStatusChangedSystemMessage(oldStatus, status, aenderungsanfrageProcessed, now, userName);
                AenderungsanfrageUtils.Status status2 = status != null ? status : (newStatus = oldStatus != null ? oldStatus : AenderungsanfrageUtils.Status.PENDING);
                if (AenderungsanfrageUtils.Status.ARCHIVED != oldStatus || AenderungsanfrageUtils.Status.ARCHIVED != newStatus) {
                    this.persistAenderungsanfrage(aenderungsanfrageBean, stacEntry, aenderungsanfrageProcessed, kassenzeichennummer, newStatus, existingAenderungsanfrageBean != null);
                    if (!Objects.equals((Object)oldStatus, (Object)newStatus)) {
                        StacUtils.prolongExpiration(stacEntry, this.getMetaService(), this.getConnectionContext());
                        AenderungsanfrageUtils.getInstance().sendStatusChangedMail(aenderungsanfrageProcessed, newStatus);
                    }
                }
                if (Boolean.TRUE.equals(submission)) {
                    AenderungsanfrageUtils.getInstance().sendSubmissionMail(aenderungsanfrageProcessed);
                }
                AenderungsanfrageJson anderungsanfrageFilteredForClerk = AenderungsanfrageUtils.getInstance().doFilteringOutWhatIShouldntSee(aenderungsanfrageProcessed, false);
                CidsServerMessageManagerImpl.getInstance().publishMessage(CSM_NEWREQUEST, (Object)new ServerMessage((Integer)aenderungsanfrageBean.getProperty("stac_id"), anderungsanfrageFilteredForClerk != null ? anderungsanfrageFilteredForClerk.toJson() : null, newStatus), false, this.getConnectionContext());
                AenderungsanfrageJson anderungsanfrageFiltered = AenderungsanfrageUtils.getInstance().doFilteringOutWhatIShouldntSee(aenderungsanfrageProcessed, citizenOrClerk);
                return new AenderungsanfrageResultJson(AenderungsanfrageResultJson.ResultStatus.SUCCESS, anderungsanfrageFiltered, null).toJson();
            }
        }
        catch (Exception ex) {
            LOG.info((Object)ex, (Throwable)ex);
            try {
                return new AenderungsanfrageResultJson(AenderungsanfrageResultJson.ResultStatus.ERROR, null, ex.getMessage()).toJson();
            }
            catch (Exception ex1) {
                LOG.error((Object)ex1, (Throwable)ex1);
                return null;
            }
        }
    }

    private void removeDoublesFromAenderungsanfrage(AenderungsanfrageJson aenderungsanfrage) {
        List<NachrichtJson> nachrichten = aenderungsanfrage.getNachrichten();
        if (nachrichten == null || nachrichten.size() < 2) {
            return;
        }
        NachrichtJson lastMessage = nachrichten.get(nachrichten.size() - 1);
        boolean firstRemoval = true;
        int count = 1;
        for (int i = nachrichten.size() - 2; i > 0; --i) {
            NachrichtParameterJson.Type lastType;
            NachrichtJson currentMessage = nachrichten.get(i);
            NachrichtParameterJson.Type currentType = currentMessage.getNachrichtenParameter() != null ? currentMessage.getNachrichtenParameter().getType() : null;
            NachrichtParameterJson.Type type = lastType = lastMessage.getNachrichtenParameter() != null ? lastMessage.getNachrichtenParameter().getType() : null;
            if (currentType != null && lastType != null && currentType.equals((Object)NachrichtParameterJson.Type.SEEN) && lastType.equals((Object)NachrichtParameterJson.Type.SEEN) && currentMessage.equals(lastMessage)) {
                nachrichten.remove(i);
                if (firstRemoval) {
                    LOG.warn((Object)("REMOVE doubled message: Kassenzeichen_nummer " + String.valueOf(aenderungsanfrage.getKassenzeichen())), (Throwable)new Exception());
                    firstRemoval = false;
                    continue;
                }
                ++count;
                continue;
            }
            lastMessage = currentMessage;
        }
        if (!firstRemoval) {
            LOG.warn((Object)("REMOVE doubled message: count " + String.valueOf(count)));
        }
    }

    private void persistAenderungsanfrage(CidsBean aenderungsanfrageBean, StacEntry stacEntry, AenderungsanfrageJson aenderungsanfrageProcessed, Integer kassenzeichennumer, AenderungsanfrageUtils.Status status, boolean aenderungsanfrageAlreadyExists) throws Exception {
        this.removeDoublesFromAenderungsanfrage(aenderungsanfrageProcessed);
        aenderungsanfrageBean.setProperty("changes_json", (Object)aenderungsanfrageProcessed.toJson());
        aenderungsanfrageBean.setProperty("stac_id", (Object)stacEntry.getId());
        aenderungsanfrageBean.setProperty("kassenzeichen_nummer", (Object)kassenzeichennumer);
        aenderungsanfrageBean.setProperty("timestamp", (Object)new Timestamp(new Date().getTime()));
        aenderungsanfrageBean.setProperty("status", (Object)AenderungsanfrageUtils.getStatusBean(status, stacEntry, this.getMetaService(), this.getConnectionContext()));
        if (aenderungsanfrageAlreadyExists) {
            DomainServerImpl.getServerInstance().updateMetaObject(this.getUser(), aenderungsanfrageBean.getMetaObject(), this.getConnectionContext());
        } else {
            DomainServerImpl.getServerInstance().insertMetaObject(this.getUser(), aenderungsanfrageBean.getMetaObject(), this.getConnectionContext());
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public static class ServerMessage
    implements Serializable {
        private final Integer stacId;
        private final String aenderungsanfrage;
        private final AenderungsanfrageUtils.Status status;

        public ServerMessage(Integer stacId, String aenderungsanfrage, AenderungsanfrageUtils.Status status) {
            this.stacId = stacId;
            this.aenderungsanfrage = aenderungsanfrage;
            this.status = status;
        }

        public Integer getStacId() {
            return this.stacId;
        }

        public String getAenderungsanfrage() {
            return this.aenderungsanfrage;
        }

        public AenderungsanfrageUtils.Status getStatus() {
            return this.status;
        }
    }

    public static enum Parameter {
        STAC{

            public String toString() {
                return "stac";
            }
        }
        ,
        STAC_ID{

            public String toString() {
                return "stacId";
            }
        }
        ,
        CHANGEREQUEST_JSON{

            public String toString() {
                return "changerequestJson";
            }
        }
        ,
        CLERK_IS_SAVING{

            public String toString() {
                return "Sachbearbeiter speichert Kassenzeichen";
            }
        };

    }
}

