/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.jsondeserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.cismet.verdis.server.json.FlaecheAenderungJson;
import de.cismet.verdis.server.json.FlaecheAnschlussgradJson;
import de.cismet.verdis.server.json.FlaecheFlaechenartJson;
import de.cismet.verdis.server.json.FlaechePruefungJson;
import java.io.IOException;

public class FlaecheAenderungDeserializer
extends StdDeserializer<FlaecheAenderungJson> {
    private final ObjectMapper objectMapper;

    public FlaecheAenderungDeserializer(ObjectMapper objectMapper) {
        super(FlaecheAenderungJson.class);
        this.objectMapper = objectMapper;
    }

    public FlaecheAenderungJson deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        FlaechePruefungJson pruefung;
        ObjectNode on = (ObjectNode)jp.readValueAsTree();
        Boolean draft = on.has("draft") ? Boolean.valueOf(on.get("draft").asBoolean()) : null;
        Integer groesse = on.has("groesse") ? Integer.valueOf(on.get("groesse").intValue()) : null;
        FlaecheFlaechenartJson flaechenart = on.has("flaechenart") ? (FlaecheFlaechenartJson)this.objectMapper.treeToValue((TreeNode)on.get("flaechenart"), FlaecheFlaechenartJson.class) : null;
        FlaecheAnschlussgradJson anschlussgrad = on.has("anschlussgrad") ? (FlaecheAnschlussgradJson)this.objectMapper.treeToValue((TreeNode)on.get("anschlussgrad"), FlaecheAnschlussgradJson.class) : null;
        FlaechePruefungJson flaechePruefungJson = pruefung = on.has("pruefung") ? (FlaechePruefungJson)this.objectMapper.treeToValue((TreeNode)on.get("pruefung"), FlaechePruefungJson.class) : null;
        if (anschlussgrad == null && flaechenart == null && groesse == null) {
            throw new RuntimeException("invalid FlaecheJson: neither anschlussgrad nor flaechenart nor groesse is set");
        }
        if (groesse != null && groesse < 0) {
            throw new RuntimeException("invalid FlaecheJson: groesse can't be negative");
        }
        return new FlaecheAenderungJson(draft, groesse, flaechenart, anschlussgrad, pruefung);
    }
}

