/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.verdis.server.search.GeomServerSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class KassenzeichenGeomSearch
extends GeomServerSearch {
    private static final transient Logger LOG = Logger.getLogger(KassenzeichenGeomSearch.class);
    private boolean flaecheFilter = false;
    private boolean frontFilter = false;
    private boolean allgemeinFilter = false;
    private double scaleDenominator = 0.0;

    public Collection performServerSearch() {
        Geometry searchGeometry = this.getGeometry();
        if (searchGeometry != null) {
            ArrayList<String> joinFilter = new ArrayList<String>();
            ArrayList<String> whereFilter = new ArrayList<String>();
            if (this.flaecheFilter) {
                joinFilter.add("flaecheninfo" + " AS flaecheninfo");
                whereFilter.add("flaecheninfo." + "geometrie" + " = geom." + "id");
            }
            if (this.frontFilter) {
                searchGeometry = searchGeometry.buffer(0.001 * this.scaleDenominator);
                joinFilter.add("frontinfo" + " AS frontinfo");
                whereFilter.add("frontinfo." + "geometrie" + " = geom." + "id");
            }
            if (this.allgemeinFilter) {
                joinFilter.add("kassenzeichen_geometrie" + " AS kassenzeichen_geometrie");
                whereFilter.add("kassenzeichen_geometrie." + "geometrie" + " = geom." + "id");
            }
            String geomFromText = "st_GeomFromText('" + searchGeometry.toText() + "', " + searchGeometry.getSRID() + ")";
            String sqlDerived = "SELECT     DISTINCT " + "kassenzeichen" + "." + "kassenzeichennummer8" + " AS kassenzeichennumer FROM     cs_attr_object_derived,     cs_class,     " + "kassenzeichen" + " AS kassenzeichen, " + (joinFilter.isEmpty() ? "" : KassenzeichenGeomSearch.implodeArray(joinFilter.toArray(new String[0]), ", ") + ", ") + "    " + "geom" + " AS geom WHERE " + (whereFilter.isEmpty() ? " TRUE " : "(" + KassenzeichenGeomSearch.implodeArray(whereFilter.toArray(new String[0]), " OR ") + ")") + "    AND cs_class.table_name ILIKE '" + "kassenzeichen" + "'     AND cs_attr_object_derived.class_id = cs_class.id     AND cs_attr_object_derived.attr_class_id = (SELECT id FROM cs_class WHERE table_name ILIKE '" + "geom" + "')     AND kassenzeichen." + "id" + " = cs_attr_object_derived.object_id     AND kassenzeichen." + "kassenzeichennummer8" + " IS NOT NULL     AND geom." + "id" + " = cs_attr_object_derived.attr_object_id     AND ST_Intersects(       (SELECT geom." + "geo_field" + "),        " + geomFromText + "    ) ORDER BY kassenzeichennumer ASC;";
            MetaService metaService = (MetaService)this.getActiveLocalServers().get("VERDIS_GRUNDIS");
            HashSet<Integer> idSet = new HashSet<Integer>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)sqlDerived);
            }
            try {
                for (ArrayList fields : metaService.performCustomSearch(sqlDerived)) {
                    idSet.add((Integer)fields.get(0));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"problem during kassenzeichen geom search", (Throwable)ex);
            }
            List<Integer> sortedIdList = Arrays.asList(idSet.toArray(new Integer[0]));
            Collections.sort(sortedIdList);
            return sortedIdList;
        }
        LOG.info((Object)"searchGeometry is null, geom search is not possible");
        return null;
    }

    public void setFlaecheFilter(boolean flaecheFilter) {
        this.flaecheFilter = flaecheFilter;
    }

    public void setFrontFilter(boolean frontFilter) {
        this.frontFilter = frontFilter;
    }

    public void setAllgemeinFilter(boolean allgemeinFilter) {
        this.allgemeinFilter = allgemeinFilter;
    }

    public static String implodeArray(String[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(inputArray[0]);
            for (int i = 1; i < inputArray.length; ++i) {
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
        }
        return output;
    }

    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }
}

