/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.verdis.server.search.KassenzeichenGeomSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class KassenzeichenNodeByWKTSearch
extends KassenzeichenGeomSearch
implements RestApiCidsServerSearch {
    private static final transient Logger LOG = Logger.getLogger(KassenzeichenNodeByWKTSearch.class);
    private static int SRID = 25832;
    private SearchInfo searchInfo = new SearchInfo();
    private String wktString = "";
    private boolean flaecheFilter = false;
    private boolean frontFilter = false;
    private boolean allgemeinFilter = false;
    private double scaleDenominator = 0.0;

    public KassenzeichenNodeByWKTSearch() {
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("Search for Kassenzeichen-Objects by WKT Geometry");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        SearchParameterInfo searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("wktString");
        searchParameterInfo.setType(Type.STRING);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("flaecheFilter");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("frontFilter");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        searchParameterInfo = new SearchParameterInfo();
        searchParameterInfo.setKey("allgemeinFilter");
        searchParameterInfo.setType(Type.BOOLEAN);
        parameterDescription.add(searchParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.NODE);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public void setWktString(String wktStringIn) {
        this.wktString = wktStringIn;
        Geometry geometryToUse = null;
        if (this.wktString != null) {
            String wkt;
            int wktSrid;
            int skIndex = this.wktString.indexOf(59);
            if (skIndex > 0) {
                String sridKV = this.wktString.substring(0, skIndex);
                int eqIndex = sridKV.indexOf(61);
                if (eqIndex > 0) {
                    wktSrid = Integer.parseInt(sridKV.substring(eqIndex + 1));
                    wkt = this.wktString.substring(skIndex + 1);
                } else {
                    wkt = this.wktString;
                    wktSrid = SRID;
                }
            } else {
                wkt = this.wktString;
                wktSrid = SRID;
            }
            try {
                if (wktSrid < 0) {
                    geometryToUse = new WKTReader().read(wkt);
                    geometryToUse.setSRID(wktSrid);
                } else {
                    GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), wktSrid);
                    geometryToUse = new WKTReader(geomFactory).read(wkt);
                    geometryToUse.setSRID(wktSrid);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"could not parse or transform WKT String", (Throwable)ex);
                throw new IllegalArgumentException(ex);
            }
        }
        super.setGeometry(geometryToUse);
    }

    @Override
    public Collection performServerSearch() {
        try {
            Geometry searchGeometry = this.getGeometry();
            if (searchGeometry != null) {
                ArrayList<String> joinFilter = new ArrayList<String>();
                ArrayList<String> whereFilter = new ArrayList<String>();
                if (this.flaecheFilter) {
                    joinFilter.add("flaecheninfo" + " AS flaecheninfo");
                    whereFilter.add("flaecheninfo." + "geometrie" + " = geom." + "id");
                }
                if (this.frontFilter) {
                    searchGeometry = searchGeometry.buffer(0.001 * this.scaleDenominator);
                    joinFilter.add("frontinfo" + " AS frontinfo");
                    whereFilter.add("frontinfo." + "geometrie" + " = geom." + "id");
                }
                if (this.allgemeinFilter) {
                    joinFilter.add("kassenzeichen_geometrie" + " AS kassenzeichen_geometrie");
                    whereFilter.add("kassenzeichen_geometrie." + "geometrie" + " = geom." + "id");
                }
                String geomFromText = "st_GeomFromText('" + searchGeometry.toText() + "', " + searchGeometry.getSRID() + ")";
                String sqlDerived = "SELECT DISTINCT (SELECT id FROM cs_class WHERE table_name ILIKE '" + "kassenzeichen" + "' LIMIT 1) as cid, " + "kassenzeichen" + ".id AS oid FROM     cs_attr_object_derived,     cs_class,     " + "kassenzeichen" + " AS kassenzeichen, " + (joinFilter.isEmpty() ? "" : KassenzeichenNodeByWKTSearch.implodeArray(joinFilter.toArray(new String[0]), ", ") + ", ") + "    " + "geom" + " AS geom WHERE " + (whereFilter.isEmpty() ? " TRUE " : "(" + KassenzeichenNodeByWKTSearch.implodeArray(whereFilter.toArray(new String[0]), " OR ") + ")") + "    AND cs_class.table_name ilike '" + "kassenzeichen" + "'     AND cs_attr_object_derived.class_id = cs_class.id     AND cs_attr_object_derived.attr_class_id = (SELECT id FROM cs_class WHERE table_name ILIKE '" + "geom" + "')     AND kassenzeichen." + "id" + " = cs_attr_object_derived.object_id     AND kassenzeichen." + "kassenzeichennummer8" + " IS NOT NULL     AND geom." + "id" + " = cs_attr_object_derived.attr_object_id     AND ST_Intersects(geom." + "geo_field" + ",        " + geomFromText + "    ) ORDER BY 2 ASC;";
                MetaService ms = (MetaService)this.getActiveLocalServers().get("VERDIS_GRUNDIS");
                ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
                ArrayList searchResult = ms.performCustomSearch(sqlDerived);
                LOG.info((Object)sqlDerived);
                for (ArrayList al : searchResult) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    MetaObjectNode mon = new MetaObjectNode("VERDIS_GRUNDIS", oid, cid, "", null, null);
                    result.add(mon);
                }
                return result;
            }
            LOG.info((Object)"searchGeometry is null, geom search is not possible");
        }
        catch (Exception e) {
            LOG.error((Object)"problem during kassenzeichen by wkt search", (Throwable)e);
        }
        return null;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getWktString() {
        return this.wktString;
    }

    public boolean isFlaecheFilter() {
        return this.flaecheFilter;
    }

    @Override
    public void setFlaecheFilter(boolean flaecheFilter) {
        this.flaecheFilter = flaecheFilter;
    }

    public boolean isFrontFilter() {
        return this.frontFilter;
    }

    @Override
    public void setFrontFilter(boolean frontFilter) {
        this.frontFilter = frontFilter;
    }

    public boolean isAllgemeinFilter() {
        return this.allgemeinFilter;
    }

    @Override
    public void setAllgemeinFilter(boolean allgemeinFilter) {
        this.allgemeinFilter = allgemeinFilter;
    }

    public double getScaleDenominator() {
        return this.scaleDenominator;
    }

    @Override
    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }
}

