/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.utils;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserServer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.verdis.server.json.StacOptionsDurationJson;
import de.cismet.verdis.server.json.StacOptionsJson;
import de.cismet.verdis.server.jsondeserializer.StacOptionsDeserializer;
import de.cismet.verdis.server.jsondeserializer.StacOptionsDurationDeserializer;
import de.cismet.verdis.server.utils.StacEntry;
import java.rmi.Naming;
import java.rmi.Remote;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StacUtils {
    private static final Logger LOG = Logger.getLogger(StacUtils.class);
    private static final String PREPARED_STATEMENT__STAC_CHECK = "SELECT id, thehash, stac_options, base_login_name, expiration FROM cs_stac WHERE md5(salt || ? || stac_options || base_login_name) = thehash AND expiration > now();";
    private static final String PREPARED_STATEMENT__STACID_CHECK = "SELECT id, thehash, stac_options, base_login_name, expiration FROM cs_stac WHERE id = ?;";
    private static final String PREPARED_STATEMENT__STAC_CREATE = "SELECT create_stac(?, ?, ?);";
    private static final String PREPARED_STATEMENT__STAC_SET_EXPIRATION = "UPDATE cs_stac SET expiration = ? WHERE id = ?";
    private static Connection CONNECTION = null;
    private final ObjectMapper mapper = new ObjectMapper();

    public StacUtils() {
        try {
            SimpleModule module = new SimpleModule();
            module.addDeserializer(StacOptionsJson.class, (JsonDeserializer)new StacOptionsDeserializer(this.mapper));
            module.addDeserializer(StacOptionsDurationJson.class, (JsonDeserializer)new StacOptionsDurationDeserializer(this.mapper));
            this.mapper.registerModule((Module)module);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"this should never happen", t);
        }
    }

    private static Connection getConnection() throws Exception {
        if (CONNECTION == null) {
            CONNECTION = DomainServerImpl.getServerInstance().getConnectionPool().getConnection(true);
        }
        return CONNECTION;
    }

    public static String createStac(Integer kassenzeichenId, String baseLoginName, String creatorUserName, Timestamp expiration, StacOptionsDurationJson duration) throws Exception {
        StacOptionsJson stacOptions = new StacOptionsJson(kassenzeichenId, creatorUserName, duration);
        String stacOptionsJson = stacOptions.toJson();
        PreparedStatement ps = StacUtils.getConnection().prepareStatement(PREPARED_STATEMENT__STAC_CREATE);
        ps.setString(1, baseLoginName);
        ps.setTimestamp(2, expiration);
        ps.setString(3, stacOptionsJson);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            String stac = rs.getString(1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("stac: " + stac));
            }
            return stac;
        }
        return null;
    }

    public static void updateStacExpiration(int stacId, Timestamp timestamp, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        PreparedStatement ps = StacUtils.getConnection().prepareStatement(PREPARED_STATEMENT__STAC_SET_EXPIRATION);
        ps.setTimestamp(1, timestamp);
        ps.setInt(2, stacId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)ps.toString());
        }
        ps.executeUpdate();
    }

    public static void prolongExpiration(StacEntry stacEntry, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        if (stacEntry.getStacOptions() != null && stacEntry.getStacOptions().getDuration() != null) {
            StacUtils.updateStacExpiration(stacEntry.getId(), StacUtils.createTimestampFrom(stacEntry.getStacOptions().getDuration()), metaService, connectionContext);
        }
    }

    public static Timestamp createTimestampFrom(StacOptionsDurationJson duration) {
        return StacUtils.createTimestampFrom(duration, new Date());
    }

    public static Timestamp createTimestampFrom(StacOptionsDurationJson duration, Date date) {
        if (duration != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            StacOptionsDurationJson.Unit unit = duration.getUnit();
            if (unit != null) {
                Integer value = duration.getValue();
                switch (unit) {
                    case MINUTES: {
                        cal.add(12, value);
                        break;
                    }
                    case HOURS: {
                        cal.add(10, value);
                        break;
                    }
                    case DAYS: {
                        cal.add(6, value);
                        break;
                    }
                    case WEEKS: {
                        cal.add(3, value);
                        break;
                    }
                    case MONTHS: {
                        cal.add(2, value);
                        break;
                    }
                    case YEARS: {
                        cal.add(1, value);
                    }
                }
            }
            return new Timestamp(cal.getTime().getTime());
        }
        return new Timestamp(date.getTime());
    }

    public static StacEntry getStacEntry(String stac, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        ResultSet rs;
        PreparedStatement ps = StacUtils.getConnection().prepareStatement(PREPARED_STATEMENT__STAC_CHECK);
        ps.setString(1, stac);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)ps.toString());
        }
        if ((rs = ps.executeQuery()).next()) {
            Integer id = rs.getInt("id");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("id: " + id));
            }
            String hash = rs.getString("thehash");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("hash: " + hash));
            }
            String optionsJson = rs.getString("stac_options");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("options: " + optionsJson));
            }
            String baseUser = rs.getString("base_login_name");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("user: " + baseUser));
            }
            Timestamp expiration = rs.getTimestamp("expiration");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("expiration: " + expiration));
            }
            return new StacEntry(id, hash, optionsJson, baseUser, expiration);
        }
        return null;
    }

    public static StacEntry getStacEntry(Integer stacId, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        ResultSet rs;
        PreparedStatement ps = StacUtils.getConnection().prepareStatement(PREPARED_STATEMENT__STACID_CHECK);
        ps.setInt(1, stacId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)ps.toString());
        }
        if ((rs = ps.executeQuery()).next()) {
            Integer id = rs.getInt("id");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("id: " + id));
            }
            String hash = rs.getString("thehash");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("hash: " + hash));
            }
            String optionsJson = rs.getString("stac_options");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("options: " + optionsJson));
            }
            String baseUser = rs.getString("base_login_name");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("user: " + baseUser));
            }
            Timestamp expiration = rs.getTimestamp("expiration");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("expiration: " + expiration));
            }
            return new StacEntry(id, hash, optionsJson, baseUser, expiration);
        }
        return null;
    }

    public static CidsBean getKassenzeichenBean(StacEntry stacEntry, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        if (stacEntry != null) {
            User user = StacUtils.getUser(stacEntry, metaService, connectionContext);
            MetaClass mc = metaService.getClassByTableName(user, "kassenzeichen", connectionContext);
            MetaObject mo = metaService.getMetaObject(user, stacEntry.getStacOptions().getKassenzeichenid().intValue(), mc.getId(), connectionContext);
            return mo.getBean();
        }
        return null;
    }

    public static User getUser(StacEntry stacEntry, MetaService metaService, ConnectionContext connectionContext) {
        if (stacEntry != null) {
            for (String registryIP : DomainServerImpl.getServerProperties().getRegistryIps()) {
                try {
                    Remote userServer = Naming.lookup("rmi://" + registryIP + "/userServer");
                    User user = ((UserServer)userServer).getUser(null, null, "VERDIS_GRUNDIS", stacEntry.getLoginName(), null);
                    return user;
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            return null;
        }
        return null;
    }

    public static HashMap<String, Object> asMap(String json) throws Exception {
        return (HashMap)StacUtils.getInstance().mapper.readValue(json, HashMap.class);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static StacOptionsJson createStacOptionsJson(String json) throws Exception {
        return (StacOptionsJson)StacUtils.getInstance().getMapper().readValue(json, StacOptionsJson.class);
    }

    public static StacOptionsJson createStacOptionsJson(Map<String, Object> map) throws Exception {
        return StacUtils.createStacOptionsJson(StacUtils.getInstance().getMapper().writeValueAsString(map));
    }

    public static StacUtils getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private static final class LazyInitialiser {
        private static final StacUtils INSTANCE = new StacUtils();

        private LazyInitialiser() {
        }
    }
}

