/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.watergis.gui.dialog;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.resource.PropertyManager;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;

import org.apache.log4j.Logger;

import org.openide.util.NbBundle;

import java.awt.EventQueue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;

import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.custom.watergis.server.actions.CreateSchemaAction;
import de.cismet.cids.custom.watergis.server.actions.CreateUserAction;
import de.cismet.cids.custom.watergis.server.actions.CreateViewAction;
import de.cismet.cids.custom.watergis.server.actions.RemoveSchemaAction;
import de.cismet.cids.custom.watergis.server.actions.RemoveUserAction;
import de.cismet.cids.custom.watergis.server.actions.SchemaExistsAction;
import de.cismet.cids.custom.watergis.server.actions.UserExistsAction;
import de.cismet.cids.custom.watergis.server.search.AllGroups;

import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;

import de.cismet.cids.tools.CidsLayerUtil;

import de.cismet.cismap.cidslayer.CidsLayer;

import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;

import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;

import de.cismet.tools.gui.WaitingDialogThread;

import de.cismet.watergis.broker.AppBroker;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class DbUserDialog extends javax.swing.JDialog {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(DbUserDialog.class);
    private static final ConnectionContext CONNECTION_CONTEXT = ConnectionContext.create(
            AbstractConnectionContext.Category.ACTION,
            "create db user");

    //~ Instance fields --------------------------------------------------------

    private int selectedThemeFeatureCount = 0;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bgBuffer;
    private javax.swing.JButton butCancel;
    private javax.swing.JButton butOk;
    private javax.swing.JCheckBox cbOverride;
    private javax.swing.JComboBox cbUserGroup;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JLabel labTableName;
    private javax.swing.JLabel labTableName1;
    private javax.swing.JLabel labTableName2;
    private javax.swing.JLabel labTheme;
    private javax.swing.JTextField txtDBSchema;
    private javax.swing.JTextField txtDbPassword;
    private javax.swing.JTextField txtDbUser;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DissolveDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     */
    public DbUserDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, modal);
        initComponents();

        setLayerModel();
        enabledOrNot();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        bgBuffer = new javax.swing.ButtonGroup();
        jDialog1 = new javax.swing.JDialog();
        labTheme = new javax.swing.JLabel();
        cbUserGroup = new javax.swing.JComboBox();
        labTableName = new javax.swing.JLabel();
        txtDbUser = new javax.swing.JTextField();
        txtDbPassword = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        butOk = new javax.swing.JButton();
        butCancel = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        labTableName1 = new javax.swing.JLabel();
        labTableName2 = new javax.swing.JLabel();
        txtDBSchema = new javax.swing.JTextField();
        cbOverride = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.title", new Object[] {})); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            labTheme,
            org.openide.util.NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.labTheme.text", new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 10, 10);
        getContentPane().add(labTheme, gridBagConstraints);

        cbUserGroup.setMinimumSize(new java.awt.Dimension(200, 27));
        cbUserGroup.setPreferredSize(new java.awt.Dimension(200, 27));
        cbUserGroup.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cbUserGroupActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 10, 10);
        getContentPane().add(cbUserGroup, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labTableName,
            org.openide.util.NbBundle.getMessage(
                DbUserDialog.class,
                "DbUserDialog.labTableName.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(labTableName, gridBagConstraints);

        txtDbUser.setMinimumSize(new java.awt.Dimension(200, 27));
        txtDbUser.setPreferredSize(new java.awt.Dimension(200, 27));
        txtDbUser.addKeyListener(new java.awt.event.KeyAdapter() {

                @Override
                public void keyTyped(final java.awt.event.KeyEvent evt) {
                    txtDbUserKeyTyped(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(txtDbUser, gridBagConstraints);

        txtDbPassword.setMinimumSize(new java.awt.Dimension(200, 27));
        txtDbPassword.setPreferredSize(new java.awt.Dimension(200, 27));
        txtDbPassword.addKeyListener(new java.awt.event.KeyAdapter() {

                @Override
                public void keyTyped(final java.awt.event.KeyEvent evt) {
                    txtDbPasswordKeyTyped(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(txtDbPassword, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            butOk,
            org.openide.util.NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.butOk.text", new Object[] {})); // NOI18N
        butOk.setMinimumSize(new java.awt.Dimension(80, 29));
        butOk.setPreferredSize(new java.awt.Dimension(150, 29));
        butOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    butOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 15, 10);
        jPanel1.add(butOk, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            butCancel,
            org.openide.util.NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.butCancel.text", new Object[] {})); // NOI18N
        butCancel.setPreferredSize(new java.awt.Dimension(150, 29));
        butCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    butCancelActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(15, 10, 15, 10);
        jPanel1.add(butCancel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jPanel1, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(jPanel4, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labTableName1,
            org.openide.util.NbBundle.getMessage(
                DbUserDialog.class,
                "DbUserDialog.labTableName1.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(labTableName1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            labTableName2,
            org.openide.util.NbBundle.getMessage(
                DbUserDialog.class,
                "DbUserDialog.labTableName2.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(labTableName2, gridBagConstraints);

        txtDBSchema.setMinimumSize(new java.awt.Dimension(200, 27));
        txtDBSchema.setPreferredSize(new java.awt.Dimension(200, 27));
        txtDBSchema.addKeyListener(new java.awt.event.KeyAdapter() {

                @Override
                public void keyTyped(final java.awt.event.KeyEvent evt) {
                    txtDBSchemaKeyTyped(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(txtDBSchema, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            cbOverride,
            org.openide.util.NbBundle.getMessage(
                DbUserDialog.class,
                "DbUserDialog.cbOverride.text",
                new Object[] {})); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
        getContentPane().add(cbOverride, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void butCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_butCancelActionPerformed
        setVisible(false);
    }                                                                             //GEN-LAST:event_butCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void butOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_butOkActionPerformed
        final String userGroup = (String)cbUserGroup.getSelectedItem();
        final String dbUser = txtDbUser.getText();
        final String dbPassword = txtDbPassword.getText();
        final String schema = txtDBSchema.getText();

        if (!AppBroker.getInstance().isAdminUser()) {
            return;
        }

        if (((dbUser == null) || dbUser.equals("")) || ((dbPassword == null) || dbPassword.equals(""))
                    || ((schema == null) || schema.equals(""))) {
            return;
        }

        if (ActionHelper.isInvalidSchemaName(schema)) {
            JOptionPane.showMessageDialog(
                DbUserDialog.this,
                NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.butOkActionPerformed().invalidSchemaName.text"),
                NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.butOkActionPerformed().invalidSchemaName.title"),
                JOptionPane.ERROR_MESSAGE);
            return;
        }

        if (ActionHelper.isInvalidUserName(dbUser)) {
            JOptionPane.showMessageDialog(
                DbUserDialog.this,
                NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.butOkActionPerformed().invalidUserName.text"),
                NbBundle.getMessage(DbUserDialog.class, "DbUserDialog.butOkActionPerformed().invalidUserName.title"),
                JOptionPane.ERROR_MESSAGE);
            return;
        }

        final WaitingDialogThread<String> wdt = new WaitingDialogThread<String>(AppBroker.getInstance()
                        .getWatergisApp(),
                true,
                "Erstelle neues DB Profil                             ",
                null,
                100,
                true) {

                @Override
                protected String doInBackground() throws Exception {
                    final PropertyManager propertyManager = PropertyManager.getManager();

                    // check if the schema already exists
                    final ServerActionParameter paramSchema = new ServerActionParameter(
                            SchemaExistsAction.ParameterType.SCHEMA.toString(),
                            schema);
                    final Boolean schemaExists = (Boolean)SessionManager.getProxy()
                                .executeTask(
                                        SchemaExistsAction.TASK_NAME,
                                        AppBroker.getInstance().getDomain(),
                                        (Object)null,
                                        ConnectionContext.createDummy(),
                                        paramSchema);

                    // check if the user already exists
                    final ServerActionParameter paramUser = new ServerActionParameter(
                            UserExistsAction.ParameterType.DB_USER.toString(),
                            dbUser);
                    final Boolean userExists = (Boolean)SessionManager.getProxy()
                                .executeTask(
                                        UserExistsAction.TASK_NAME,
                                        AppBroker.getInstance().getDomain(),
                                        (Object)null,
                                        ConnectionContext.createDummy(),
                                        paramUser);

                    if ((!schemaExists && !userExists) || cbOverride.isSelected()) {
                        final Connection connection = SessionManager.getConnection();
                        final ConnectionInfo connInfo = new ConnectionInfo();

                        connInfo.setCallserverURL(AppBroker.getInstance().getCallserverUrl());
                        connInfo.setUsername(SessionManager.getSession().getUser().getName());
                        connInfo.setUserDomain(SessionManager.getSession().getUser().getDomain());
                        connInfo.setUsergroup(userGroup);
                        connInfo.setUsergroupDomain(SessionManager.getSession().getUser().getUserGroup().getDomain());
                        connInfo.setPassword(SessionManager.getSession().getConnectionInfo().getPassword());

                        final ConnectionSession session = ConnectionFactory.getFactory()
                                    .createSession(connection,
                                        connInfo,
                                        true,
                                        CONNECTION_CONTEXT);
                        final ConnectionProxy proxy = ConnectionFactory.getFactory()
                                    .createProxy(
                                        "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler",
                                        session,
                                        CONNECTION_CONTEXT);
                        String errorMessage = null;

                        if (schemaExists) {
                            errorMessage = removeSchema(schema);

                            if (errorMessage != null) {
                                return errorMessage;
                            }
                        }

                        if (userExists) {
                            errorMessage = removeUser(dbUser);

                            if (errorMessage != null) {
                                return errorMessage;
                            }
                        }

                        // create user
                        errorMessage = createUser(dbUser, dbPassword);

                        if (errorMessage != null) {
                            return errorMessage;
                        }

                        // create schema
                        errorMessage = createSchema(schema, dbUser);

                        if (errorMessage != null) {
                            return errorMessage;
                        }

                        final MetaClass[] mc = proxy.getClasses(AppBroker.DOMAIN_NAME, ConnectionContext.createDummy());
                        int count = 0;
                        wd.setMax(mc.length);

                        for (final MetaClass clazz : mc) {
                            final Collection attributes = clazz.getAttributeByName("cidsLayer");
                            final Collection hidden = clazz.getAttributeByName("hidden");
                            wd.setProgress(count++);
                            if ((attributes == null) || attributes.isEmpty()
                                        || ((hidden != null) && !hidden.isEmpty()
                                            && hidden.toArray()[0].toString().equals(
                                                "true"))) {
                                continue;
                            }

                            // do not create a view, if  the class attribute create_ro_view is not set to true
                            final Collection createAsView = clazz.getAttributeByName("create_ro_view");

                            if ((createAsView == null) || createAsView.isEmpty()
                                        || !createAsView.toArray()[0].toString().equalsIgnoreCase("true")) {
                                continue;
                            }

                            createView(clazz, schema, dbUser, session.getUser());
                        }
                    } else {
                        return NbBundle.getMessage(
                                DbUserDialog.class,
                                "DbUserDialog.userOrSchemaAlreadyExists",
                                new Object[] { schema });
                    }

                    return null;
                }

                private String createUser(final String user, final String password) throws ConnectionException {
                    final ServerActionParameter paramDbUser = new ServerActionParameter(
                            CreateUserAction.ParameterType.DB_USER.toString(),
                            user);
                    final ServerActionParameter paramDbPassword = new ServerActionParameter(
                            CreateUserAction.ParameterType.DB_PASSWORD.toString(),
                            password);
                    final Boolean userCreated = (Boolean)SessionManager.getProxy()
                                .executeTask(
                                        CreateUserAction.TASK_NAME,
                                        AppBroker.getInstance().getDomain(),
                                        (Object)null,
                                        ConnectionContext.createDummy(),
                                        paramDbUser,
                                        paramDbPassword);

                    if (userCreated) {
                        return null;
                    } else {
                        return NbBundle.getMessage(
                                DbUserDialog.class,
                                "DbUserDialog.createUser().failure",
                                new Object[] { user });
                    }
                }

                private String removeUser(final String user) throws ConnectionException {
                    final ServerActionParameter paramDbUser = new ServerActionParameter(
                            RemoveUserAction.ParameterType.DB_USER.toString(),
                            user);
                    final Boolean userRemoved = (Boolean)SessionManager.getProxy()
                                .executeTask(
                                        RemoveUserAction.TASK_NAME,
                                        AppBroker.getInstance().getDomain(),
                                        (Object)null,
                                        ConnectionContext.createDummy(),
                                        paramDbUser);

                    if (userRemoved) {
                        return null;
                    } else {
                        return NbBundle.getMessage(
                                DbUserDialog.class,
                                "DbUserDialog.removeUser().failure",
                                new Object[] { user });
                    }
                }

                @Override
                protected void done() {
                    try {
                        final String errorMessage = get();

                        if (errorMessage != null) {
                            if (!errorMessage.equals("")) {
                                JOptionPane.showMessageDialog(
                                    DbUserDialog.this,
                                    errorMessage,
                                    "Fehler beim Erstellen des Schemas",
                                    JOptionPane.ERROR_MESSAGE);
                            } else {
                                JOptionPane.showMessageDialog(
                                    DbUserDialog.this,
                                    "Beim Erstellen des Schemas ist ein Fehler aufgetreten",
                                    "Fehler beim Erstellen des Schemas",
                                    JOptionPane.ERROR_MESSAGE);
                            }
                        }
                    } catch (Exception ex) {
                        LOG.error("Error while execute the create db user operation.", ex);
                    }
                }
            };

        this.setVisible(false);
        wdt.start();
    } //GEN-LAST:event_butOkActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbUserGroupActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cbUserGroupActionPerformed
        EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    enabledOrNot();
                }
            });
    } //GEN-LAST:event_cbUserGroupActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtDbUserKeyTyped(final java.awt.event.KeyEvent evt) { //GEN-FIRST:event_txtDbUserKeyTyped
        EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    enabledOrNot();
                }
            });
    } //GEN-LAST:event_txtDbUserKeyTyped

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtDbPasswordKeyTyped(final java.awt.event.KeyEvent evt) { //GEN-FIRST:event_txtDbPasswordKeyTyped
        EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    enabledOrNot();
                }
            });
    } //GEN-LAST:event_txtDbPasswordKeyTyped

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtDBSchemaKeyTyped(final java.awt.event.KeyEvent evt) { //GEN-FIRST:event_txtDBSchemaKeyTyped
        enabledOrNot();
    }                                                                     //GEN-LAST:event_txtDBSchemaKeyTyped

    /**
     * DOCUMENT ME!
     */
    private void setLayerModel() {
        final Object selectedObject = cbUserGroup.getSelectedItem();
        cbUserGroup.setModel(new DefaultComboBoxModel(
                new String[] { NbBundle.getMessage(DbUserDialog.class,
                        "DBUserDialog.setlayerModel.searchUser") }));

        final Thread t = new Thread(new Runnable() {

                    @Override
                    public void run() {
                        try {
                            final User user = SessionManager.getSession().getUser();
                            final List<String> routes = (List<String>)SessionManager.getProxy()
                                        .customServerSearch(user, new AllGroups(), CONNECTION_CONTEXT);
                            cbUserGroup.setModel(new DefaultComboBoxModel(routes.toArray(new String[routes.size()])));

                            if (selectedObject != null) {
                                cbUserGroup.setSelectedItem(selectedObject);
                            } else {
                                if (cbUserGroup.getModel().getSize() > 0) {
                                    cbUserGroup.setSelectedIndex(0);
                                } else {
                                    cbUserGroup.setSelectedItem(null);
                                }
                            }
                        } catch (ConnectionException e) {
                            LOG.error("Cannot load the user groups", e);
                        }
                    }
                });

        t.start();
    }

    /**
     * DOCUMENT ME!
     */
    private void enabledOrNot() {
        final boolean isUserSelected = (cbUserGroup.getSelectedItem() instanceof String);
        final boolean userGiven = (txtDbUser.getText() != null) && !txtDbUser.getText().equals("");
        final boolean passwordGiven = (txtDbPassword.getText() != null) && !txtDbPassword.getText().equals("");
        final boolean schemaGiven = (txtDBSchema.getText() != null) && !txtDBSchema.getText().equals("");

        butOk.setEnabled(isUserSelected && userGiven && passwordGiven && schemaGiven);
    }

    /**
     * DOCUMENT ME!
     *
     * @param   clazz   DOCUMENT ME!
     * @param   schema  DOCUMENT ME!
     * @param   dbUser  DOCUMENT ME!
     * @param   user    DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  ConnectionException  DOCUMENT ME!
     */
    public static String createView(final MetaClass clazz,
            final String schema,
            final String dbUser,
            final User user) throws ConnectionException {
        final List<ServerActionParameter> parameter = new ArrayList<ServerActionParameter>();

        final ServerActionParameter paramClass = new ServerActionParameter(
                CreateViewAction.ParameterType.CLASS.toString(),
                clazz.getId());
        final ServerActionParameter paramDbUser = new ServerActionParameter(
                CreateViewAction.ParameterType.DB_USER.toString(),
                dbUser);
        final ServerActionParameter paramSchema = new ServerActionParameter(
                CreateViewAction.ParameterType.SCHEMA.toString(),
                schema);
        final ServerActionParameter paramUser = new ServerActionParameter(
                CreateViewAction.ParameterType.USER.toString(),
                user);
        parameter.add(paramClass);
        parameter.add(paramDbUser);
        parameter.add(paramSchema);
        parameter.add(paramUser);
        final CidsLayer layer = new CidsLayer(clazz);
        final AttributeTableRuleSet ruleSet = layer.getLayerProperties().getAttributeTableRuleSet();

        if ((ruleSet != null) && (ruleSet.getAdditionalFieldNames() != null)) {
            final List<CreateViewAction.AdditionalField> additionalFields =
                new ArrayList<CreateViewAction.AdditionalField>();

            for (final String fieldName : ruleSet.getAdditionalFieldNames()) {
                final String formula = layer.decorateQuery(ruleSet.getAdditionalFieldFormula(fieldName));

                if (formula != null) {
                    final CreateViewAction.AdditionalField field = new CreateViewAction.AdditionalField(
                            fieldName,
                            ruleSet.getIndexOfAdditionalFieldName(fieldName),
                            formula);
                    additionalFields.add(field);
                }
            }

            if (additionalFields.size() > 0) {
                parameter.add(new ServerActionParameter(
                        CreateViewAction.ParameterType.ADDITIONAL_FIELDS.toString(),
                        additionalFields.toArray(
                            new CreateViewAction.AdditionalField[additionalFields.size()])));
            }
        }

        final Boolean viewCreated = (Boolean)SessionManager.getProxy()
                    .executeTask(
                            CreateViewAction.TASK_NAME,
                            AppBroker.getInstance().getDomain(),
                            (Object)null,
                            ConnectionContext.createDummy(),
                            parameter.toArray(new ServerActionParameter[parameter.size()]));

        if (viewCreated) {
            return null;
        } else {
            return NbBundle.getMessage(
                    DbUserDialog.class,
                    "DbUserDialog.createView().failure",
                    new Object[] { clazz.getTableName() });
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   schema  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  ConnectionException  DOCUMENT ME!
     */
    public static String removeSchema(final String schema) throws ConnectionException {
        final ServerActionParameter paramSchema = new ServerActionParameter(
                RemoveSchemaAction.ParameterType.SCHEMA.toString(),
                schema);
        final Boolean schemaRemoved = (Boolean)SessionManager.getProxy()
                    .executeTask(
                            RemoveSchemaAction.TASK_NAME,
                            AppBroker.getInstance().getDomain(),
                            (Object)null,
                            ConnectionContext.createDummy(),
                            paramSchema);

        if (schemaRemoved) {
            return null;
        } else {
            return NbBundle.getMessage(
                    DbUserDialog.class,
                    "DbUserDialog.removeSchema().failure",
                    new Object[] { schema });
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   schema  DOCUMENT ME!
     * @param   user    DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  ConnectionException  DOCUMENT ME!
     */
    public static String createSchema(final String schema, final String user) throws ConnectionException {
        final ServerActionParameter paramSchema = new ServerActionParameter(
                CreateSchemaAction.ParameterType.SCHEMA.toString(),
                schema);
        final ServerActionParameter paramUser = new ServerActionParameter(
                CreateSchemaAction.ParameterType.DB_USER.toString(),
                user);
        final Boolean createSchema = (Boolean)SessionManager.getProxy()
                    .executeTask(
                            CreateSchemaAction.TASK_NAME,
                            AppBroker.getInstance().getDomain(),
                            (Object)null,
                            ConnectionContext.createDummy(),
                            paramSchema,
                            paramUser);

        if (createSchema) {
            return null;
        } else {
            return NbBundle.getMessage(
                    DbUserDialog.class,
                    "DbUserDialog.createSchema().failure",
                    new Object[] { schema });
        }
    }
}
