/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.watergis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import de.cismet.cids.dynamics.CidsBean;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class Bookmark
extends CidsBean
implements Comparable<Bookmark> {
    private static final Logger LOG = Logger.getLogger(Bookmark.class);
    private String name;
    private String description;
    private Geometry geometry;

    public Bookmark() {
    }

    public Bookmark(Element bookmarkElement) {
        this.name = bookmarkElement.getAttributeValue("name");
        this.description = bookmarkElement.getChildText("description");
        Element geometryElement = bookmarkElement.getChild("geometry");
        int crs = Integer.parseInt(geometryElement.getAttributeValue("crs"));
        GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), crs);
        WKTReader wktReader = new WKTReader(geomFactory);
        String geomText = bookmarkElement.getChildText("geometry");
        try {
            this.geometry = wktReader.read(geomText);
        }
        catch (ParseException ex) {
            LOG.error((Object)("cannot create geometry from WKT: " + geomText), (Throwable)ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 53 * hash + (this.geometry != null ? this.geometry.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bookmark other = (Bookmark)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return this.geometry == other.geometry || this.geometry != null && this.geometry.equals(other.geometry);
    }

    @Override
    public int compareTo(Bookmark o) {
        return this.name.compareTo(o.name);
    }

    public Element toElement() {
        Element bookmark = new Element("bookmark");
        Attribute nameAttribute = new Attribute("name", this.name);
        Element geometryElement = new Element("geometry");
        geometryElement.addContent(this.geometry.toText());
        geometryElement.setAttribute(new Attribute("crs", String.valueOf(this.geometry.getSRID())));
        bookmark.setAttribute(nameAttribute);
        bookmark.addContent((Content)geometryElement);
        if (this.description != null) {
            Element descriptionElement = new Element("description");
            descriptionElement.addContent(this.description);
            bookmark.addContent((Content)descriptionElement);
        }
        return bookmark;
    }
}

