/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.permissions.dlm25w;

import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.AbstractCustomBeanPermissionProvider;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerPermissionProvider;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.watergis.broker.AppBroker;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class WatergisPermissionProvider
extends AbstractCustomBeanPermissionProvider
implements CidsLayerPermissionProvider {
    protected static final transient Logger log = Logger.getLogger(WatergisPermissionProvider.class);

    public boolean getCustomReadPermissionDecisionforUser(User u, ConnectionContext connectionContext) {
        return this.getCustomReadPermissionDecisionforUser(u);
    }

    public boolean getCustomWritePermissionDecisionforUser(User u, ConnectionContext connectionContext) {
        return this.getCustomWritePermissionDecisionforUser(u);
    }

    public boolean getCustomReadPermissionDecisionforUser(User u) {
        return true;
    }

    public boolean getCustomWritePermissionDecisionforUser(User u) {
        if (u.getUserGroup().getName().equalsIgnoreCase("administratoren") || u.getUserGroup().getName().equalsIgnoreCase("admin_edit")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"member of admin group. permission is granted");
            }
            return true;
        }
        CidsBean wwGr = this.getWwGrBean();
        if (AppBroker.getInstance().getOwnWwGr() != null && AppBroker.getInstance().getOwnWwGr().getProperty("ww_gr") != null) {
            if (wwGr != null && wwGr.getProperty("owner").equals(u.getUserGroup().getName())) {
                return true;
            }
            return wwGr != null && wwGr.getProperty("ww_gr").equals(4000);
        }
        return false;
    }

    public boolean getCustomCidsLayerWritePermissionDecisionforUser(User u, CidsLayerFeature feature) {
        if (u.getUserGroup().getName().equalsIgnoreCase("administratoren") || u.getUserGroup().getName().equalsIgnoreCase("admin_edit")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"member of admin group. permission is granted");
            }
            return true;
        }
        CidsBean wwGr = this.getWwGrfromFeature(feature);
        if (AppBroker.getInstance().getOwnWwGr() != null && AppBroker.getInstance().getOwnWwGr().getProperty("ww_gr") != null) {
            if (wwGr != null && wwGr.getProperty("owner").equals(u.getUserGroup().getName())) {
                return true;
            }
            return wwGr != null && wwGr.getProperty("ww_gr").equals(4000);
        }
        return false;
    }

    protected CidsBean getWwGrfromFeature(CidsLayerFeature feature) {
        return this.getWwGrBeanFromProperty(feature, this.getWwGrPropertyName());
    }

    protected CidsBean getWwGrBeanFromProperty(CidsLayerFeature feature, String property) {
        Object wwGrObject = feature.getProperty(property);
        List<CidsBean> wwgrBeans = AppBroker.getInstance().getWwGrList();
        if (wwGrObject == null) {
            return null;
        }
        if (wwGrObject instanceof CidsBean) {
            return (CidsBean)wwGrObject;
        }
        if (wwGrObject instanceof CidsLayerFeature) {
            CidsLayerFeature f = (CidsLayerFeature)wwGrObject;
            for (CidsBean bean : wwgrBeans) {
                if (!bean.getProperty("id").equals(f.getId())) continue;
                return bean;
            }
        } else {
            String wwGr = wwGrObject.toString();
            for (CidsBean bean : wwgrBeans) {
                if (bean.getProperty("ww_gr") == null || !bean.getProperty("ww_gr").toString().equals(wwGr)) continue;
                return bean;
            }
        }
        return null;
    }

    protected abstract CidsBean getWwGrBean();

    protected abstract String getWwGrPropertyName();
}

