/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap;

import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.NewTextDialog;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class DrawFeatureAction
extends AbstractAction
implements CommonFeatureAction {
    private static final Logger LOG = Logger.getLogger(DrawFeatureAction.class);
    Feature currentFeature = null;

    public DrawFeatureAction() {
        super("\u00c4ndere Schrift");
        super.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-settingsthree-gears.png")));
    }

    public int getSorter() {
        return 1;
    }

    public Feature getSourceFeature() {
        return this.currentFeature;
    }

    public boolean isActive() {
        return this.currentFeature instanceof DrawingSLDStyledFeature && ((DrawingSLDStyledFeature)this.currentFeature).getGeometryType().equals((Object)AbstractNewFeature.geomTypes.TEXT);
    }

    public void setSourceFeature(Feature source) {
        this.currentFeature = source;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final DrawingSLDStyledFeature feature = (DrawingSLDStyledFeature)this.currentFeature;
        final NewTextDialog dialog = new NewTextDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), false);
        dialog.setFont(feature.getPrimaryAnnotationFont());
        dialog.settext(feature.getText());
        dialog.setAutoScaleEnabled(feature.isAutoscale());
        dialog.setHaloEnabled(feature.getPrimaryAnnotationHalo() != null);
        dialog.setRunWhenFinish(new Runnable(){

            @Override
            public void run() {
                if (dialog.isConfirmed()) {
                    feature.setText(dialog.getText());
                    if (!dialog.isAutoScaleEnabled()) {
                        int fontSize = (int)(CismapBroker.getInstance().getMappingComponent().getScaleDenominator() / 3700.0 * 12.0);
                        Font f = dialog.getFont();
                        if (f == null) {
                            f = new Font("sansserif", 0, fontSize);
                        }
                        feature.setPrimaryAnnotationFont(f);
                    } else {
                        Font f = dialog.getFont();
                        if (f == null) {
                            int fontSize = (int)(CismapBroker.getInstance().getMappingComponent().getScaleDenominator() / 3700.0 * 12.0);
                            f = new Font("sansserif", 0, fontSize);
                        } else {
                            int fontSize = (int)(CismapBroker.getInstance().getMappingComponent().getScaleDenominator() / 3700.0 * (double)f.getSize());
                            f = f.deriveFont(fontSize);
                        }
                        feature.setPrimaryAnnotationFont(f);
                    }
                    feature.setAutoScale(dialog.isAutoScaleEnabled());
                    if (dialog.isHaloEnabled()) {
                        feature.setPrimaryAnnotationHalo(Color.WHITE);
                    }
                    ArrayList<DrawingSLDStyledFeature> changedFeatures = new ArrayList<DrawingSLDStyledFeature>();
                    changedFeatures.add(feature);
                    ((DefaultFeatureCollection)CismapBroker.getInstance().getMappingComponent().getFeatureCollection()).fireFeaturesChanged(changedFeatures);
                }
            }
        });
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        dialog.setLocation((int)(mouseLocation.getX() + 10.0), (int)mouseLocation.getY());
        dialog.setVisible(true);
    }
}

