/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class AslRuleSet
extends WatergisDefaultRuleSet {
    public AslRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("szenario", new WatergisDefaultRuleSet.Varchar(100, false, true));
        this.typeMap.put("plan", new WatergisDefaultRuleSet.Bool(false, true));
        this.typeMap.put("ist", new WatergisDefaultRuleSet.Bool(false, true));
        this.typeMap.put("qp_id", new WatergisDefaultRuleSet.Numeric(10, 0, false, true));
        this.typeMap.put("obsolet", new WatergisDefaultRuleSet.Bool(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(255, false, true));
        this.typeMap.put("ba_gn", new WatergisDefaultRuleSet.Varchar(100, false, true));
        this.typeMap.put("m_traeger", new WatergisDefaultRuleSet.Catalogue("k_m_traeger", false, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("abschnitt", new WatergisDefaultRuleSet.Varchar(100, false, true));
        this.typeMap.put("jahr", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("m_software", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("m_dim", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("flaeche") && !columnName.equals("ba_gn") && !columnName.equals("m_traeger") && !columnName.equals("abschnitt") && !columnName.equals("jahr") && !columnName.equals("m_software") && !columnName.equals("m_dim");
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return super.getCellEditor(columnName);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -2;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(dlm25w.asl.geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

