/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FgBaAnllRuleSet
extends WatergisDefaultRuleSet {
    public FgBaAnllRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("anll", new WatergisDefaultRuleSet.Catalogue("k_anll", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, false));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaAnllRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("ww_gr") && !columnName.equals("laenge") && !columnName.equals("obj_nr") && !columnName.equals("id") && !columnName.equals("geom") && !columnName.equals("ba_cd");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaAnllRuleSet.isValueEmpty(newValue) && column.equals("anll")) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaAnllRuleSet.getCurrentYear(), 1800, FgBaAnllRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("ba_st_von") || column.equals("ba_st_bis") && newValue != null) {
            Double till;
            Double from = column.equals("ba_st_von") ? (Double)newValue : (Double)feature.getProperty("ba_st_von");
            Double d = till = column.equals("ba_st_von") ? (Double)feature.getProperty("ba_st_bis") : (Double)newValue;
            if (from != null && till != null) {
                double length = Math.abs(till - from);
                if (feature.getProperty("anll") != null && FgBaAnllRuleSet.isValueIn(feature.getProperty("anll"), new String[]{"See", "Spei"}, false) ? !this.checkRange("l\u00e4nge", (Object)length, 20, 20000, 5, 50000, false, true, true) : (feature.getProperty("anll") != null && FgBaAnllRuleSet.isValueIn(feature.getProperty("anll"), new String[]{"Drte", "Faa", "Rb"}, false) ? !this.checkRange("l\u00e4nge", (Object)length, 10, 100, 5, 200, false, true, true) : feature.getProperty("anll") != null && FgBaAnllRuleSet.isValueIn(feature.getProperty("anll"), new String[]{"Ds", "Sf", "Si", "Sleu", "Tosb", "WKA"}, false) && !this.checkRange("l\u00e4nge", (Object)length, 1, 50, 1, 200, false, true, true))) {
                    return false;
                }
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("anll")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("anll") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            double length;
            Geometry geom;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaAnllRuleSet.isValueEmpty(feature.getProperty("anll"))) {
                this.showMessage("Das Attribut anll darf nicht leer sein", "anll");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "anll");
            }
            if (!this.checkRange("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaAnllRuleSet.getCurrentYear() + 2, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (feature.getProperty("anll") != null && (feature.getProperty("anll").equals("See") || feature.getProperty("anll").equals("Spei")) && (geom = (Geometry)feature.getProperty("geom")) != null && !this.checkRange("laenge", (Object)(length = this.round(geom.getLength())), 20, 20000, 5, 50000, true, true, false)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
            }
            if (feature.getProperty("anll") != null && (feature.getProperty("anll").equals("Drte") || feature.getProperty("anll").equals("Faa") || feature.getProperty("anll").equals("Rb")) && (geom = (Geometry)feature.getProperty("geom")) != null && !this.checkRange("laenge", (Object)(length = this.round(geom.getLength())), 10, 100, 5, 200, true, true, false)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
            }
            if (feature.getProperty("anll") != null && (feature.getProperty("anll").equals("Ds") || feature.getProperty("anll").equals("Sf") || feature.getProperty("anll").equals("Si") || feature.getProperty("anll").equals("Sleu") || feature.getProperty("anll").equals("Tosb") || feature.getProperty("anll").equals("WKA")) && (geom = (Geometry)feature.getProperty("geom")) != null && !this.checkRange("laenge", (Object)(length = this.round(geom.getLength())), 1, 50, 1, 200, true, true, false)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
            }
            Double from = (Double)feature.getProperty("ba_st_von");
            Double till = (Double)feature.getProperty("ba_st_bis");
            if (from == null || till == null) continue;
            double length2 = Math.abs(till - from);
            if (!(feature.getProperty("anll") != null && FgBaAnllRuleSet.isValueIn(feature.getProperty("anll"), new String[]{"See", "Spei"}, false) ? !this.checkRange("l\u00e4nge", (Object)length2, 20, 20000, 5, 50000, false, true, true) : (feature.getProperty("anll") != null && FgBaAnllRuleSet.isValueIn(feature.getProperty("anll"), new String[]{"Drte", "Faa", "Rb"}, false) ? !this.checkRange("l\u00e4nge", (Object)length2, 10, 100, 5, 200, false, true, true) : feature.getProperty("anll") != null && FgBaAnllRuleSet.isValueIn(feature.getProperty("anll"), new String[]{"Ds", "Sf", "Si", "Sleu", "Tosb", "WKA"}, false) && !this.checkRange("l\u00e4nge", (Object)length2, 1, 20, 1, 200, false, true, true)))) continue;
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 1.0f, 50000.0f);
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaAnllRuleSet.downloadDocumentFromWebDav(FgBaAnllRuleSet.getWbblPath(), FgBaAnllRuleSet.addExtension(value.toString(), "pdf"));
        }
    }
}

