/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class FgBaAnlpRuleSet
extends WatergisDefaultRuleSet {
    public FgBaAnlpRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("l_rl", new WatergisDefaultRuleSet.Catalogue("k_l_rl", false, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("anlp", new WatergisDefaultRuleSet.Catalogue("k_anlp", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("anlp_a", new WatergisDefaultRuleSet.Catalogue("k_sbef", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("material_a", new WatergisDefaultRuleSet.Catalogue("k_material", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, true));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaAnlpRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("esw", new WatergisDefaultRuleSet.BooleanAsInteger(false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("ww_gr") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr") && !columnName.equals("id");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaAnlpRuleSet.isValueEmpty(newValue) && (column.equals("anlp") || column.equals("l_rl"))) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaAnlpRuleSet.getCurrentYear(), 1800, FgBaAnlpRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("br") && !FgBaAnlpRuleSet.isValueEmpty(feature.getProperty("l_rl")) && (FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Steg", "VT", "Wee", "Z"}, false) ? column.equals("br") && !this.checkRange(column, newValue, 1, 50, 1, 200, true, false, true) : !FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Steg", "VT", "Wee", "Z"}, false) && column.equals("br") && !this.checkRange(column, newValue, 0, 5, 0, 10, true, false, true))) {
            return oldValue;
        }
        if (column.equals("l_rl") && !FgBaAnlpRuleSet.isValueEmpty(feature.getProperty("anlp"))) {
            Object rl;
            if (FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Albw", "Elbw", "Fu", "Rsk", "Schi", "Slu", "Stt"}, false)) {
                Object rl2 = newValue;
                if (rl2 != null && !rl2.toString().equals("mi")) {
                    this.showMessage("Bei anlp = Albw/Elbw/Fu/Rsk/Schi/Slu/Stt darf das Attribut l_rl nur den Wert mi haben.", column);
                    return oldValue;
                }
            } else if (FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"P", "P-Gr", "P-Steg", "P-Gr-Ste", "P-Lat", "Sta"}, false)) {
                Object rl3 = newValue;
                if (!(rl3 != null && (rl3.toString().equals("mi") || rl3.toString().equals("re") || rl3.toString().equals("li") || rl3.toString().equals("bs") || rl3.toString().equals("nb")))) {
                    this.showMessage("Bei anlp = P/P-Gr/P-Steg/P-Gr-Ste/P-Lat/Sta darf das Attribut l_rl nur die Werte re/li/mi/bs/nb haben.", column);
                    return oldValue;
                }
            } else if (!(!FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Steg", "Vt", "Wes"}, false) || (rl = newValue) != null && (rl.toString().equals("bs") || rl.toString().equals("re") || rl.toString().equals("li") || rl.toString().equals("nb")))) {
                this.showMessage("Bei anlp = Steg/Vt/Wes darf das Attribut l_rl nur die Werte re/li/bs/nb haben.", column);
                return oldValue;
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("anlp")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("anlp") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_rl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), this.createCidsLayerFeatureFilter("anlp"));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_rl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("material_a")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("anlp_a");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("material") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("anlp_a")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("fg_ba_anlp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("sbef") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            Object rl;
            Number br;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaAnlpRuleSet.isValueEmpty(feature.getProperty("anlp"))) {
                this.showMessage("Das Attribut anlp darf nicht leer sein", "anlp");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "anlp");
            }
            if (FgBaAnlpRuleSet.isValueEmpty(feature.getProperty("l_rl"))) {
                this.showMessage("Das Attribut l_rl darf nicht leer sein", "l_rl");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_rl");
            }
            if (FgBaAnlpRuleSet.isValueEmpty(feature.getProperty("br"))) {
                this.showMessage("Das Attribut br darf nicht leer sein", "br");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
            }
            if (!this.checkRange("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaAnlpRuleSet.getCurrentYear() + 2, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Steg", "VT", "Wee"}, false)) {
                br = FgBaAnlpRuleSet.toNumber(feature.getProperty("br"));
                if (br.doubleValue() < 1.0 || br.doubleValue() > 200.0) {
                    this.showMessage("Das Attribut br muss zwischen 1 und 200 liegen, wenn anlp = Steg/VT/Wee", "br");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
                }
            } else {
                br = FgBaAnlpRuleSet.toNumber(feature.getProperty("br"));
                if (br.doubleValue() < 0.0 || br.doubleValue() > 10.0) {
                    this.showMessage("Das Attribut br muss zwischen 0 und 10 liegen, wenn anlp nicht gleich Steg/VT/Wee", "br");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
                }
            }
            if (FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Albw", "Elbw", "Fu", "Rsk", "Schi", "Slu", "Stt"}, false)) {
                rl = feature.getProperty("l_rl");
                if (rl == null || rl.toString().equals("mi")) continue;
                this.showMessage("Bei anlp = Albw/Elbw/Fu/Rsk/Schi/Slu/Stt darf das Attribut l_rl nur den Wert mi haben.", "l_rl");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_rl");
            }
            if (FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"P", "P-Gr", "P-Steg", "P-Gr-Ste", "P-Lat", "Sta"}, false)) {
                rl = feature.getProperty("l_rl");
                if (rl != null && (rl.toString().equals("mi") || rl.toString().equals("re") || rl.toString().equals("li") || rl.toString().equals("bs") || rl.toString().equals("nb"))) continue;
                this.showMessage("Bei anlp = P/P-Gr/P-Steg/P-Gr-Ste/P-Lat/Sta darf das Attribut l_rl nur die Werte re/li/mi/bs/nb haben.", "l_rl");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_rl");
            }
            if (!FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Steg", "Vt", "Wes"}, false) || (rl = feature.getProperty("l_rl")) != null && (rl.toString().equals("bs") || rl.toString().equals("re") || rl.toString().equals("li") || rl.toString().equals("nb"))) continue;
            this.showMessage("Bei anlp = Steg/Vt/Wes darf das Attribut l_rl nur die Werte re/li/bs/nb haben.", "l_rl");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "l_rl");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        Object rl;
        this.adjustFisGDateAndFisGUser(feature);
        if (FgBaAnlpRuleSet.isValueIn(feature.getProperty("anlp"), new Object[]{"Albw", "Elbw", "Fu", "Rsk", "Schi", "Slu", "Stt"}, false) && (rl = feature.getProperty("l_rl")) == null) {
            feature.setProperty("l_rl", (Object)FgBaAnlpRuleSet.getCatalogueElement("dlm25w.k_l_rl", "l_rl", "mi"));
        }
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationCreator creator = new StationCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper());
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaAnlpRuleSet.downloadDocumentFromWebDav(FgBaAnlpRuleSet.getWbblPath(), FgBaAnlpRuleSet.addExtension(value.toString(), "pdf"));
        }
    }
}

