/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class FgBaExpRuleSet
extends WatergisDefaultRuleSet {
    public FgBaExpRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        if (columnName.equals("ww_gr")) {
            return AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren");
        }
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("laenge") && !columnName.equals("geom") && !columnName.equals("ba_cd") && !columnName.equals("ww_gr");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        return super.getCellEditor(columnName);
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            CidsLayerFeature cidsFeature;
            CidsBean bean;
            CidsBean wwGr;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (!(feature instanceof CidsLayerFeature) || (wwGr = (CidsBean)(bean = (cidsFeature = (CidsLayerFeature)feature).getBean()).getProperty("ba_st.von.route.ww_gr")) == null || !AppBroker.getInstance().isOwnerWwGr((Integer)wwGr.getProperty("ww_gr"))) continue;
            this.showMessage("Ein Objekt liegt auf einer Route, die Ihnen bereits geh\u00f6rt.", "ww_gr");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, null);
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOtherRouteStationCheck check = new WatergisDefaultRuleSet.OnOtherRouteStationCheck();
        StationLineCreator c = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper());
        c.setProperties(this.getDefaultValues());
        c.setCheck((StationCreationCheck)check);
        return c;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (AppBroker.getInstance().getOwnWwGr() != null) {
            properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        } else {
            properties.put("ww_gr", AppBroker.getInstance().getNiemandWwGr());
        }
        return properties;
    }
}

