/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class FgBaGbRuleSet
extends WatergisDefaultRuleSet {
    public FgBaGbRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("nr_re", new WatergisDefaultRuleSet.Numeric(5, 0, false, false));
        this.typeMap.put("name_re", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("nr_li", new WatergisDefaultRuleSet.Numeric(5, 0, false, false));
        this.typeMap.put("name_li", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("st_rl", new WatergisDefaultRuleSet.Numeric(1, 0, false, false));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return false;
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaGbRuleSet.isValueEmpty(newValue)) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("gb")) {
            final String owner = AppBroker.getInstance().getOwner();
            Object filter = !owner.equalsIgnoreCase("Administratoren") ? new CidsLayerFeatureFilter(){

                public boolean accept(CidsLayerFeature bean) {
                    if (owner.startsWith("wbv") || owner.startsWith("stalu")) {
                        Boolean b = (Boolean)bean.getProperty(owner.substring(0, owner.indexOf("_edit")));
                        return b != null && b != false;
                    }
                    if (owner.equals("wsa_eberswalde")) {
                        Boolean b = (Boolean)bean.getProperty("wsa_ew");
                        return b != null && b != false;
                    }
                    if (owner.equals("wsa_lauenburg")) {
                        Boolean b = (Boolean)bean.getProperty("wsa_la");
                        return b != null && b != false;
                    }
                    if (owner.equals("wsa_stralsund")) {
                        Boolean b = (Boolean)bean.getProperty("wsa_st");
                        return b != null && b != false;
                    }
                    return false;
                }
            } : new CidsLayerFeatureFilter(){

                public boolean accept(CidsLayerFeature bean) {
                    return bean != null;
                }
            };
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("gb", String.valueOf(12), true), filter);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("gb") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (feature.getProperty("gb") != null) continue;
            this.showMessage("Das Attribut gb darf nicht leer sein", "gb");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gb");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper());
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }
}

