/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FgBaProfRuleSet
extends WatergisDefaultRuleSet {
    public FgBaProfRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("ba_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("profil", new WatergisDefaultRuleSet.Catalogue("k_profil", true, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("obj_nr", new WatergisDefaultRuleSet.Numeric(20, 0, false, true));
        this.typeMap.put("obj_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("traeger", new WatergisDefaultRuleSet.Catalogue("k_traeger", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("traeger_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(FgBaProfRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("ausbaujahr", new WatergisDefaultRuleSet.Numeric(4, 0, false, true));
        this.typeMap.put("zust_kl", new WatergisDefaultRuleSet.Catalogue("k_zust_kl", false, true, true, new WatergisDefaultRuleSet.Numeric(1, 0, false, false)));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_e", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("ho_a", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("gefaelle", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("bv_re", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bh_re", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bl_re", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bv_li", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bh_li", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("bl_li", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("mw", new WatergisDefaultRuleSet.Numeric(4, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.minBaLength = 0.5;
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("laenge") && !columnName.equals("ww_gr") && !columnName.equals("ba_cd") && !columnName.equals("geom") && !columnName.equals("obj_nr");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (FgBaProfRuleSet.isValueEmpty(newValue) && column.equals("profil")) {
            this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
            return oldValue;
        }
        if (column.equals("mw") && !this.checkRange(column, newValue, 0, 10, 0, 15, true, false, true)) {
            return oldValue;
        }
        if (column.equals("mw") && !FgBaProfRuleSet.isValueEmpty(newValue)) {
            double mw = ((Number)newValue).doubleValue();
            if (!FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_li")) && !FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_re"))) {
                if (mw > Math.min(((Number)feature.getProperty("bh_li")).doubleValue(), ((Number)feature.getProperty("bh_re")).doubleValue())) {
                    this.showMessage("Das Attribut mw muss kleiner als das Minimum von bh_re, bh_li sein.", "mw");
                    return oldValue;
                }
            } else if (!FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_li"))) {
                if (mw > ((Number)feature.getProperty("bh_li")).doubleValue()) {
                    this.showMessage("Das Attribut mw muss kleiner als bh_li sein.", "mw");
                    return oldValue;
                }
            } else if (!FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_re")) && mw > ((Number)feature.getProperty("bh_re")).doubleValue()) {
                this.showMessage("Das Attribut mw muss kleiner als bh_re sein.", "mw");
                return oldValue;
            }
        }
        if (column.equals("ausbaujahr") && !this.checkRange(column, newValue, 1950, FgBaProfRuleSet.getCurrentYear(), 1800, FgBaProfRuleSet.getCurrentYear() + 2, true, true, true)) {
            return oldValue;
        }
        if (column.equals("br") && !this.checkRange(column, newValue, 0, 10, 0, 100, true, false, true)) {
            return oldValue;
        }
        if (column.equals("ho_e") && !this.checkRangeBetweenOrEqual(column, newValue, -6, 179, true)) {
            return oldValue;
        }
        if (column.equals("ho_a") && !this.checkRangeBetweenOrEqual(column, newValue, -6, 179, true)) {
            return oldValue;
        }
        if (column.equals("gefaelle") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 50.0, -10.0, 100.0, true)) {
            return oldValue;
        }
        if (column.equals("bv_re") && !this.hasValue(column, newValue, 0.0, true) && !this.checkRangeBetweenOrEqual(column, newValue, 0.25, 10.0, 0.1, 15.0, true)) {
            return oldValue;
        }
        if (column.equals("bh_re") && !this.checkRange(column, newValue, 0, 10, 0, 15, true, false, true)) {
            return oldValue;
        }
        if (column.equals("bl_re") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 15.0, 0.0, 30.0, true)) {
            return oldValue;
        }
        if (column.equals("bv_li") && !this.hasValue(column, newValue, 0.0, true) && !this.checkRangeBetweenOrEqual(column, newValue, 0.25, 10.0, 0.1, 15.0, true)) {
            return oldValue;
        }
        if (column.equals("bh_li") && !this.checkRange(column, newValue, 0, 10, 0, 15, true, false, true)) {
            return oldValue;
        }
        if (column.equals("bl_li") && !this.checkRangeBetweenOrEqual(column, newValue, 0.0, 15.0, 0.0, 30.0, true)) {
            return oldValue;
        }
        if (column.equals("ho_a") || column.equals("ho_e")) {
            if (column.equals("ho_a") && feature.getProperty("ho_e") != null) {
                double hoa;
                double hoe = FgBaProfRuleSet.toNumber(feature.getProperty("ho_e")).doubleValue();
                if (hoe < (hoa = FgBaProfRuleSet.toNumber(newValue).doubleValue())) {
                    this.showMessage("Wert nicht zul\u00e4ssig, weil ho_e >= ho_a nicht eingehalten", "ho_e");
                    return oldValue;
                }
            } else if (column.equals("ho_e") && feature.getProperty("ho_a") != null) {
                double hoa = FgBaProfRuleSet.toNumber(feature.getProperty("ho_a")).doubleValue();
                double hoe = FgBaProfRuleSet.toNumber(newValue).doubleValue();
                if (hoe < hoa) {
                    this.showMessage("Wert nicht zul\u00e4ssig, weil ho_e >= ho_a nicht eingehalten", "ho_e");
                    return oldValue;
                }
            }
        }
        if (column.equals("bv_li") || column.equals("bh_li") || column.equals("bv_re") || column.equals("bh_re") || column.equals("profil")) {
            feature.setProperty(column, newValue);
        }
        this.refillFields(feature, false);
        this.checkRangeBetweenOrEqual("bl_re", feature.getProperty("bl_re"), 0, 30, true);
        this.checkRangeBetweenOrEqual("bl_li", feature.getProperty("bl_li"), 0, 30, true);
        if (column.equals("ho_a") || column.equals("ho_e") || column.equals("ba_st_bis") || column.equals("ba_st_von")) {
            Object bis;
            Object hoA = column.equals("ho_a") ? newValue : feature.getProperty("ho_a");
            Object hoE = column.equals("ho_e") ? newValue : feature.getProperty("ho_e");
            Object von = column.equals("ba_st_von") ? newValue : feature.getProperty("ba_st_von");
            Object object = bis = column.equals("ba_st_bis") ? newValue : feature.getProperty("ba_st_bis");
            if (hoA != null && FgBaProfRuleSet.isNumberOrNull(hoA) && hoE != null && FgBaProfRuleSet.isNumberOrNull(hoE) && von != null && FgBaProfRuleSet.isNumberOrNull(von) && bis != null && FgBaProfRuleSet.isNumberOrNull(bis)) {
                double laenge = FgBaProfRuleSet.toNumber(bis).doubleValue() - FgBaProfRuleSet.toNumber(von).doubleValue();
                double gefaelle = (FgBaProfRuleSet.toNumber(hoE).doubleValue() - FgBaProfRuleSet.toNumber(hoA).doubleValue()) / Math.abs(laenge) * 1000.0;
                if (!this.checkRangeBetweenOrEqual("gefaelle", gefaelle, 0.0, 50.0, -10.0, 100.0, true)) {
                    return oldValue;
                }
                feature.setProperty("gefaelle", (Object)gefaelle);
            } else if (feature.getProperty("gefaelle") != null) {
                feature.setProperty("gefaelle", null);
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("traeger")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("traeger") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("zust_kl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("zust_kl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("profil")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), this.createCidsLayerFeatureFilter("prof"));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("profil") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (FgBaProfRuleSet.isValueEmpty(feature.getProperty("profil"))) {
                this.showMessage("Das Attribut profil darf nicht leer sein", "profil");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "profil");
            }
            if (!this.checkRange("ausbaujahr", feature.getProperty("ausbaujahr"), 1800, FgBaProfRuleSet.getCurrentYear() + 2, true, true, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ausbaujahr");
            }
            if (!this.checkRange("br", feature.getProperty("br"), 0, 10, 0, 100, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "br");
            }
            if (!this.checkRange("mw", feature.getProperty("mw"), 0, 10, 0, 15, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "mw");
            }
            if (!this.checkRangeBetweenOrEqual("ho_e", feature.getProperty("ho_e"), -6, 179, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_e");
            }
            if (!this.checkRangeBetweenOrEqual("ho_a", feature.getProperty("ho_a"), -6, 179, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_a");
            }
            if (!this.hasValue("bv_re", feature.getProperty("bv_re"), 0.0, true) && !this.checkRangeBetweenOrEqual("bv_re", feature.getProperty("bv_re"), 0.25, 10.0, 0.1, 15.0, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bv_re");
            }
            if (!this.checkRange("bh_re", feature.getProperty("bh_re"), 0, 10, 0, 15, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bh_re");
            }
            if (!this.hasValue("bv_li", feature.getProperty("bv_li"), 0.0, true) && !this.checkRangeBetweenOrEqual("bv_li", feature.getProperty("bv_li"), 0.25, 10.0, 0.1, 15.0, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_a");
            }
            if (!this.checkRange("bh_li", feature.getProperty("bh_li"), 0, 10, 0, 15, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bh_li");
            }
            if (!FgBaProfRuleSet.isValueEmpty(feature.getProperty("mw"))) {
                double mw = ((Number)feature.getProperty("mw")).doubleValue();
                if (!FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_li")) && !FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_re"))) {
                    if (mw > Math.min(((Number)feature.getProperty("bh_li")).doubleValue(), ((Number)feature.getProperty("bh_re")).doubleValue())) {
                        this.showMessage("Das Attribut mw muss kleiner als das Minimum von bh_re, bh_li sein.", "mw");
                        return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "mw");
                    }
                } else if (!FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_li"))) {
                    if (mw > ((Number)feature.getProperty("bh_li")).doubleValue()) {
                        this.showMessage("Das Attribut mw muss kleiner als bh_li sein.", "mw");
                        return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "mw");
                    }
                } else if (!FgBaProfRuleSet.isValueEmpty(feature.getProperty("bh_re")) && mw > ((Number)feature.getProperty("bh_re")).doubleValue()) {
                    this.showMessage("Das Attribut mw muss kleiner als bh_re sein.", "mw");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "mw");
                }
            }
            if (!(feature.getProperty("profil") == null || !feature.getProperty("profil").toString().equals("re") || this.hasValue("bv_re", feature.getProperty("bv_re"), 0.0, true) && this.hasValue("bv_li", feature.getProperty("bv_li"), 0.0, true))) {
                this.showMessage("Die Attribute bv_re und bv_li m\u00fcssen beide 0 sein, wenn das Attribut profil den Wert re hat.", "bv_re");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bv_re");
            }
            if (feature.getProperty("profil") != null && feature.getProperty("profil").toString().equals("tr") && feature.getProperty("bv_re") != null && feature.getProperty("bv_li") != null && this.hasValue("bv_re", feature.getProperty("bv_re"), 0.0, true) && this.hasValue("bv_li", feature.getProperty("bv_li"), 0.0, true)) {
                this.showMessage("Die Attribute bv_re und bv_li d\u00fcrfen nicht beide 0 sein, wenn das Attribut profil den Wert tr hat.", "bv_re");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bv_re");
            }
            if (feature.getProperty("ho_e") != null && feature.getProperty("ho_a") != null && FgBaProfRuleSet.toNumber(feature.getProperty("ho_e")).doubleValue() < FgBaProfRuleSet.toNumber(feature.getProperty("ho_a")).doubleValue()) {
                this.showMessage("Das Attribute ho_e muss gr\u00f6\u00dfer oder gleich dem Attribut ho_a sein.", "ho_e");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ho_e");
            }
            this.refillFields(feature, true);
            if (!this.checkRangeBetweenOrEqual("gefaelle", feature.getProperty("gefaelle"), 0.0, 50.0, -10.0, 100.0, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "gefaelle");
            }
            if (!this.checkRange("bl_re", feature.getProperty("bl_re"), 0, 15, 0, 30, true, false, true)) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bl_re");
            }
            if (this.checkRange("bl_li", feature.getProperty("bl_li"), 0, 15, 0, 30, true, false, true)) continue;
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bl_li");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    private void refillFields(FeatureServiceFeature feature, boolean withGefaelle) {
        if (withGefaelle && feature.getProperty("ho_a") != null && FgBaProfRuleSet.isNumberOrNull(feature.getProperty("ho_a")) && feature.getProperty("ho_e") != null && FgBaProfRuleSet.isNumberOrNull(feature.getProperty("ho_e"))) {
            double laenge = FgBaProfRuleSet.toNumber(feature.getProperty("ba_st_bis")).doubleValue() - FgBaProfRuleSet.toNumber(feature.getProperty("ba_st_von")).doubleValue();
            double gefaelle = (FgBaProfRuleSet.toNumber(feature.getProperty("ho_e")).doubleValue() - FgBaProfRuleSet.toNumber(feature.getProperty("ho_a")).doubleValue()) / laenge * 1000.0;
            feature.setProperty("gefaelle", (Object)gefaelle);
        }
        if (feature.getProperty("profil") != null && feature.getProperty("profil").toString().equals("re")) {
            if (feature.getProperty("bv_re") == null) {
                feature.setProperty("bv_re", (Object)0.0);
            }
            if (feature.getProperty("bv_li") == null) {
                feature.setProperty("bv_li", (Object)0.0);
            }
            if (FgBaProfRuleSet.toNumber(feature.getProperty("bh_re")).doubleValue() != 0.0) {
                feature.setProperty("bl_re", feature.getProperty("bh_re"));
            }
            if (FgBaProfRuleSet.toNumber(feature.getProperty("bh_li")).doubleValue() != 0.0) {
                feature.setProperty("bl_li", feature.getProperty("bh_li"));
            }
        }
        if (feature.getProperty("profil") != null && feature.getProperty("profil").toString().equals("tr")) {
            double bl;
            double bv;
            double bh;
            if (feature.getProperty("bv_re") != null && FgBaProfRuleSet.isNumberOrNull(feature.getProperty("bv_re")) && feature.getProperty("bh_re") != null && FgBaProfRuleSet.isNumberOrNull(feature.getProperty("bh_re"))) {
                if (FgBaProfRuleSet.toNumber(feature.getProperty("bv_re")).doubleValue() != 0.0 && FgBaProfRuleSet.toNumber(feature.getProperty("bh_re")).doubleValue() != 0.0) {
                    bh = FgBaProfRuleSet.toNumber(feature.getProperty("bh_re")).doubleValue();
                    bv = FgBaProfRuleSet.toNumber(feature.getProperty("bv_re")).doubleValue();
                    bl = Math.sqrt(Math.pow(bv * bh, 2.0) + Math.pow(bh, 2.0));
                    feature.setProperty("bl_re", (Object)((double)Math.round(bl * 100.0) / 100.0));
                } else if (FgBaProfRuleSet.toNumber(feature.getProperty("bv_re")).doubleValue() == 0.0) {
                    feature.setProperty("bl_re", (Object)FgBaProfRuleSet.toNumber(feature.getProperty("bh_re")).doubleValue());
                }
            }
            if (feature.getProperty("bv_li") != null && FgBaProfRuleSet.isNumberOrNull(feature.getProperty("bv_li")) && feature.getProperty("bh_li") != null && FgBaProfRuleSet.isNumberOrNull(feature.getProperty("bh_li"))) {
                if (FgBaProfRuleSet.toNumber(feature.getProperty("bv_li")).doubleValue() != 0.0 && FgBaProfRuleSet.toNumber(feature.getProperty("bh_li")).doubleValue() != 0.0) {
                    bh = FgBaProfRuleSet.toNumber(feature.getProperty("bh_li")).doubleValue();
                    bv = FgBaProfRuleSet.toNumber(feature.getProperty("bv_li")).doubleValue();
                    bl = Math.sqrt(Math.pow(bv * bh, 2.0) + Math.pow(bh, 2.0));
                    feature.setProperty("bl_li", (Object)((double)Math.round(bl * 100.0) / 100.0));
                } else if (FgBaProfRuleSet.toNumber(feature.getProperty("bv_li")).doubleValue() == 0.0) {
                    feature.setProperty("bl_li", (Object)FgBaProfRuleSet.toNumber(feature.getProperty("bh_li")).doubleValue());
                }
            }
        }
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            FgBaProfRuleSet.downloadDocumentFromWebDav(FgBaProfRuleSet.getWbblPath(), FgBaProfRuleSet.addExtension(value.toString(), "pdf"));
        }
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("ba_st", routeMc, "Basisgew\u00e4sser (FG)", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 0.5f);
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }
}

