/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.PointAndStationCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.RouteTableCellEditor;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class FgLaKmRuleSet
extends WatergisDefaultRuleSet {
    public FgLaKmRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, false, false));
        this.typeMap.put("la_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("km_km", new WatergisDefaultRuleSet.Numeric(7, 1, false, true));
        this.typeMap.put("km_km_c", new WatergisDefaultRuleSet.Varchar(9, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("la_st") && !columnName.equals("la_cd");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("ba_cd")) {
            Number o = (Number)feature.getProperty("ba_st");
            Double baSt = o instanceof CidsBean ? (Double)((CidsBean)o).getProperty("wert") : (o == null ? null : Double.valueOf(((Number)feature.getProperty("ba_st")).doubleValue()));
            this.refreshLaStation(feature, (String)newValue, baSt, "la_cd", "la_st");
        }
        if (column.equals("ba_st")) {
            this.refreshLaStation(feature, (String)feature.getProperty("ba_cd"), ((Number)newValue).doubleValue(), "la_cd", "la_st");
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_cd")) {
            RouteTableCellEditor editor = new RouteTableCellEditor("dlm25w.fg_ba", "ba_st", false);
            String filterString = this.getRouteFilter();
            if (filterString != null) {
                editor.setRouteQuery(filterString);
            }
            return editor;
        }
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        return new PointAndStationCreator("ba_st", null, routeMc, (LinearReferencingHelper)new LinearReferencingWatergisHelper());
    }

    public boolean isCatThree() {
        return true;
    }
}

