/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.DateCellEditor;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.custom.attributerule.QpRuleSet;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.RouteTableCellEditor;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.WebDavDownload;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.foto.ReportAction;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class FotoRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(FotoRuleSet.class);
    public static final BufferedImage ARROW;
    public static final BufferedImage SELECTED_ARROW;
    public static final BufferedImage ARROW_NULL;
    public static final BufferedImage SELECTED_ARROW_NULL;

    public FotoRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", false, false, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, true, false));
        this.typeMap.put("la_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("l_st", new WatergisDefaultRuleSet.Catalogue("k_l_st", false, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("l_rl", new WatergisDefaultRuleSet.Catalogue("k_l_rl", false, true, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("re", new WatergisDefaultRuleSet.Numeric(11, 2, false, true));
        this.typeMap.put("ho", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("winkel", new WatergisDefaultRuleSet.Numeric(5, 1, false, true));
        this.typeMap.put("foto_nr", new WatergisDefaultRuleSet.Numeric(15, 0, false, false));
        this.typeMap.put("foto_nr_gu", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("foto", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("upl_name", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("upl_datum", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("upl_zeit", new WatergisDefaultRuleSet.Varchar(8, false, false));
        this.typeMap.put("aufn_name", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("aufn_datum", new WatergisDefaultRuleSet.DateType(false, true));
        this.typeMap.put("aufn_zeit", new WatergisDefaultRuleSet.Time(false, true));
        this.typeMap.put("freigabe", new WatergisDefaultRuleSet.Catalogue("k_freigabe", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("titel", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("beschreib", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        if (columnName.equals("ww_gr")) {
            return AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren");
        }
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("foto") && !columnName.equals("foto_nr") && !columnName.equals("la_st") && !columnName.equals("la_cd") && !columnName.startsWith("upl");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        Point newPoint;
        Geometry g;
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("ba_cd")) {
            Number o = (Number)feature.getProperty("ba_st");
            Double baSt = o instanceof CidsBean ? (Double)((CidsBean)o).getProperty("wert") : (o == null ? null : Double.valueOf(((Number)feature.getProperty("ba_st")).doubleValue()));
            this.refreshLaStation(feature, (String)newValue, baSt, "la_cd", "la_st");
        }
        if (column.equals("ba_st")) {
            this.refreshLaStation(feature, (String)feature.getProperty("ba_cd"), ((Number)newValue).doubleValue(), "la_cd", "la_st");
        }
        if (column.equals("re") && !this.checkRange(column, newValue, 3.3E7, 3.399999999E7, false, true, true)) {
            return oldValue;
        }
        if (column.equals("ho") && !this.checkRange(column, newValue, 5600000.0, 6399999.99, false, true, true)) {
            return oldValue;
        }
        if (column.equals("re") && newValue instanceof Double) {
            g = feature.getGeometry();
            newPoint = g.getFactory().createPoint(new Coordinate(((Double)newValue).doubleValue(), g.getCoordinate().y));
            feature.setGeometry((Geometry)newPoint);
        }
        if (column.equals("ho") && newValue instanceof Double) {
            g = feature.getGeometry();
            newPoint = g.getFactory().createPoint(new Coordinate(g.getCoordinate().x, ((Double)newValue).doubleValue()));
            feature.setGeometry((Geometry)newPoint);
        }
        if (column.equals("winkel") && !this.checkRange(column, newValue, 0, 360, true, true, false)) {
            return oldValue;
        }
        if (column.equals("aufn_datum") && newValue != null && newValue instanceof Date) {
            Date d = (Date)newValue;
            if (d.getYear() < 0 || d.after(new Date())) {
                this.showMessage("Es sind nur Datumseingaben zwischen dem 01.01.1900 und heute erlaubt", "aufn_datum");
                return oldValue;
            }
            if (d.getYear() >= 0 && d.getYear() < 50 && !this.showSecurityQuestion("Wert au\u00dferhalb Standardbereich (01.01.1950 .. heute) --> verwenden ?", column, newValue)) {
                return oldValue;
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("foto")) {
            return new LinkTableCellRenderer();
        }
        if (columnName.equals("foto_nr")) {
            return new LinkTableCellRenderer(4);
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_cd")) {
            RouteTableCellEditor editor = new RouteTableCellEditor("dlm25w.fg_ba", "ba_st", false);
            String filterString = this.getRouteFilter();
            if (filterString != null) {
                editor.setRouteQuery(filterString);
            }
            return editor;
        }
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        if (columnName.equals("l_st")) {
            CidsLayerFeatureFilter filter = this.createCidsLayerFeatureFilter("nicht_qp");
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), filter);
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_st") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("l_rl")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true), this.createCidsLayerFeatureFilter("foto"));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("l_rl") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("freigabe")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("freigabe") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("aufn_datum")) {
            return new DateCellEditor();
        }
        return super.getCellEditor(columnName);
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (this.checkRange("winkel", feature.getProperty("winkel"), 0, 360, true, true, false)) continue;
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "winkel");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"ho", "re"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("re")) {
            return 9;
        }
        if (name.equals("ho")) {
            return 9;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = feature.getGeometry();
        if (geom instanceof Point) {
            if (propertyName.equals("re")) {
                value = ((Point)geom).getX();
            } else if (propertyName.equals("ho")) {
                value = ((Point)geom).getY();
            }
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("re")) {
            return "st_x(geom)";
        }
        if (propertyName.equals("ho")) {
            return "st_y(geom)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        return null;
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (AppBroker.getInstance().getOwnWwGr() != null) {
            properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        } else {
            properties.put("ww_gr", AppBroker.getInstance().getNiemandWwGr());
        }
        return properties;
    }

    public boolean isCatThree() {
        return true;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("foto")) {
            if (value instanceof String && clickCount == 1 && feature instanceof CidsLayerFeature && DownloadManagerDialog.showAskingForUserTitle((Component)AppBroker.getInstance().getRootWindow())) {
                String filename;
                String jobname = DownloadManagerDialog.getJobname();
                CidsLayerFeature cidsFeature = (CidsLayerFeature)feature;
                String path = Photo.WEB_DAV_DIRECTORY + String.valueOf(cidsFeature.getBean().getProperty("dateipfad"));
                String file = value.toString();
                String extension = null;
                if (file.contains(".")) {
                    extension = file.substring(file.lastIndexOf("."));
                    filename = file.substring(0, file.lastIndexOf("."));
                } else {
                    filename = file;
                }
                WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), Photo.WEB_DAV_USER, Photo.WEB_DAV_PASSWORD, true);
                DownloadManager.instance().add((Download)new WebDavDownload(webDavClient, path + WebDavHelper.encodeURL((String)file), jobname, filename + extension, filename, extension));
            }
        } else if (columnName.equals("foto_nr") && value != null && clickCount == 1) {
            this.createFotoReport();
        }
    }

    private void createFotoReport() {
        ReportAction action = new ReportAction();
        action.actionPerformed(null);
    }

    public FeatureAnnotationSymbol getPointAnnotationSymbol(FeatureServiceFeature feature) {
        FeatureAnnotationSymbol symb;
        Object angle = feature.getProperty("winkel");
        if (angle instanceof Double) {
            double winkel = (Double)angle;
            BufferedImage rotatedArrow = Photo.selectedFeature != null && Photo.selectedFeature.getId() == feature.getId() ? FotoRuleSet.rotateImage(SELECTED_ARROW, winkel) : FotoRuleSet.rotateImage(ARROW, winkel);
            symb = new FeatureAnnotationSymbol((Image)rotatedArrow);
        } else {
            symb = Photo.selectedFeature != null && Photo.selectedFeature.getId() == feature.getId() ? new FeatureAnnotationSymbol((Image)SELECTED_ARROW_NULL) : new FeatureAnnotationSymbol((Image)ARROW_NULL);
        }
        symb.setSweetSpotX(0.5);
        symb.setSweetSpotY(0.5);
        return symb;
    }

    public static BufferedImage rotateImage(BufferedImage src, double degrees) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(degrees), src.getWidth() / 2, src.getHeight() / 2);
        BufferedImage rotatedImage = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
        g.setTransform(affineTransform);
        g.drawImage((Image)src, 0, 0, null);
        return rotatedImage;
    }

    public boolean hasCustomExportFeaturesMethod() {
        return true;
    }

    public void exportFeatures() {
        AppBroker.getInstance().getPhotoExport().actionPerformed(null);
    }

    public boolean hasCustomPrintFeaturesMethod() {
        return true;
    }

    public void printFeatures() {
        AppBroker.getInstance().getPhotoPrint().actionPerformed(null);
    }

    static {
        try {
            URL arrowUrl = QpRuleSet.class.getResource("/de/cismet/watergis/res/icons16/angle.png");
            ARROW = ImageIO.read(arrowUrl);
            URL arrowSelectedUrl = FotoRuleSet.class.getResource("/de/cismet/watergis/res/icons16/angleSelected.png");
            SELECTED_ARROW = ImageIO.read(arrowSelectedUrl);
            URL arrowNullUrl = FotoRuleSet.class.getResource("/de/cismet/watergis/res/icons16/angle_null.png");
            ARROW_NULL = ImageIO.read(arrowNullUrl);
            URL arrowNullSelectedUrl = FotoRuleSet.class.getResource("/de/cismet/watergis/res/icons16/angle_null_selected.png");
            SELECTED_ARROW_NULL = ImageIO.read(arrowNullSelectedUrl);
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

