/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.cidslayer.PointAndStationCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.RouteTableCellEditor;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class MnOwPegelRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(MnOwPegelRuleSet.class);

    public MnOwPegelRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, false, false));
        this.typeMap.put("la_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("gwk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, false, false));
        this.typeMap.put("station", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("ms_nr", new WatergisDefaultRuleSet.Varchar(20, false, true));
        this.typeMap.put("ms_nr_wsa", new WatergisDefaultRuleSet.Varchar(20, false, true));
        this.typeMap.put("ms_name", new WatergisDefaultRuleSet.Varchar(50, true, true));
        this.typeMap.put("re", new WatergisDefaultRuleSet.Numeric(11, 2, true, true));
        this.typeMap.put("ho", new WatergisDefaultRuleSet.Numeric(10, 2, true, true));
        this.typeMap.put("typ", new WatergisDefaultRuleSet.Varchar(2, true, true));
        this.typeMap.put("gbk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, false, true));
        this.typeMap.put("gwk_gn", new WatergisDefaultRuleSet.Varchar(60, false, true));
        this.typeMap.put("see_gn", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("ezg_fl", new WatergisDefaultRuleSet.Numeric(12, 0, false, true));
        this.typeMap.put("ezg_fl_d", new WatergisDefaultRuleSet.Numeric(12, 0, false, true));
        this.typeMap.put("ezg_fl_dp", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("steckbrief", new WatergisDefaultRuleSet.Link(250, false, true));
        this.typeMap.put("ganglin_w", new WatergisDefaultRuleSet.Link(250, false, true));
        this.typeMap.put("ganglin_q", new WatergisDefaultRuleSet.Link(250, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("geom") && !columnName.equals("la_cd") && !columnName.equals("la_st");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("ms_nr") && MnOwPegelRuleSet.isValueEmpty(newValue) && MnOwPegelRuleSet.isValueEmpty(feature.getProperty("ms_nr"))) {
            this.showMessage("Die Attribute ms_nr und ms_nr_wsa d\u00fcrfen nicht beide leer sein.", "ms_nr");
            return oldValue;
        }
        if (column.equals("ms_nr_wsa") && MnOwPegelRuleSet.isValueEmpty(newValue) && MnOwPegelRuleSet.isValueEmpty(feature.getProperty("ms_nr"))) {
            this.showMessage("Die Attribute ms_nr und ms_nr_wsa d\u00fcrfen nicht beide leer sein.", "ms_nr_wsa");
            return oldValue;
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("steckbrief") || columnName.equals("ganglin_w") || columnName.equals("ganglin_q")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_cd")) {
            RouteTableCellEditor editor = new RouteTableCellEditor("dlm25w.fg_ba", "ba_st", false);
            String filterString = this.getRouteFilter();
            if (filterString != null) {
                editor.setRouteQuery(filterString);
            }
            return editor;
        }
        if (columnName.equals("gwk_lawa")) {
            RouteTableCellEditor editor = new RouteTableCellEditor("dlm25w.fg_la", "la_st_wirkort", false);
            String filterString = this.getRouteFilter();
            if (filterString != null) {
                editor.setRouteQuery(filterString);
            }
            return editor;
        }
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("station")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ww_gr")) {
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true));
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (!MnOwPegelRuleSet.isValueEmpty(feature.getProperty("ms_nr")) || !MnOwPegelRuleSet.isValueEmpty(feature.getProperty("ms_nr_wsa"))) continue;
            this.showMessage("Die Attribute ms_nr und ms_nr_wsa d\u00fcrfen nicht beide leer sein.", "ms_nr");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ms_nr");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        return new PointAndStationCreator("ba_st", null, routeMc, (LinearReferencingHelper)new LinearReferencingWatergisHelper());
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if ((columnName.equals("steckbrief") || columnName.equals("ganglin_w") || columnName.equals("ganglin_q")) && value instanceof String && clickCount == 1) {
            try {
                URL u = new URL(value.toString());
                try {
                    BrowserLauncher.openURL((String)u.toString());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public boolean isCatThree() {
        return true;
    }
}

