/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.exception.ConnectionException;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.FgBakGwkRuleSet;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SMldgrRwRuleSet
extends WatergisDefaultRuleSet {
    private final Logger LOG = Logger.getLogger(FgBakGwkRuleSet.class);

    public SMldgrRwRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, true));
        this.typeMap.put("land_cd", new WatergisDefaultRuleSet.Varchar(4, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return columnName.equals("land_cd");
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        try {
            this.refreshTemplate("RefreshRwSegGeom");
        }
        catch (ConnectionException ex) {
            this.LOG.error((Object)"Cannot refresh templates", (Throwable)ex);
        }
        super.afterSave(model);
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", false);
        c.setMinArea(1.0E-4);
        return c;
    }
}

