/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SgGesRuleSet
extends WatergisDefaultRuleSet {
    public SgGesRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("see_gn", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("see_gn_t", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("see_lawa", new WatergisDefaultRuleSet.Varchar(20, false, true));
        this.typeMap.put("gbk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, false, true));
        this.typeMap.put("gwk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, false, true));
        this.typeMap.put("see_sp", new WatergisDefaultRuleSet.Varchar(8, false, true));
        this.typeMap.put("see_typ", new WatergisDefaultRuleSet.Varchar(3, false, true));
        this.typeMap.put("see_art", new WatergisDefaultRuleSet.Varchar(3, false, true));
        this.typeMap.put("see_wrrl", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("see_nhn", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("see_verm", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("verm_datum", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("verm_nhn", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("bz", new WatergisDefaultRuleSet.Numeric(2, 0, false, true));
        this.typeMap.put("tmax", new WatergisDefaultRuleSet.Numeric(5, 2, false, true));
        this.typeMap.put("td", new WatergisDefaultRuleSet.Numeric(5, 2, false, true));
        this.typeMap.put("vol", new WatergisDefaultRuleSet.Numeric(10, 0, false, true));
        this.typeMap.put("tg", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("ue", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("ul", new WatergisDefaultRuleSet.Numeric(7, 3, false, true));
        this.typeMap.put("leff", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("beff", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("tabelle", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("ezg", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("ezg_fl", new WatergisDefaultRuleSet.Numeric(12, 0, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("tabelle")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("tabelle") && value instanceof String && clickCount == 1) {
            SgGesRuleSet.downloadDocumentFromWebDav(this.getSgLinkTablePath(), SgGesRuleSet.addExtension(value.toString(), "xlsx"));
        }
    }
}

