/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SgSeeWkRuleSet
extends WatergisDefaultRuleSet {
    private static final String URL_TEMPLATE = "https://fis-wasser-mv.de/charts/steckbriefe/lw/lw_wk.php?schema=reporting_bp3&sg=%1s";
    private final Logger LOG = Logger.getLogger(SgSeeWkRuleSet.class);

    public SgSeeWkRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("wk_nr", new WatergisDefaultRuleSet.Catalogue("k_wk_sg", true, true, new WatergisDefaultRuleSet.Varchar(50, false, false)));
        this.typeMap.put("wk_gn", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("wk_fedfue", new WatergisDefaultRuleSet.Catalogue("k_wk_sg", false, false, new WatergisDefaultRuleSet.Varchar(2, false, false)));
        this.typeMap.put("gbk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, false, true));
        this.typeMap.put("lake_cat", new WatergisDefaultRuleSet.Varchar(6, false, true));
        this.typeMap.put("see_gn", new WatergisDefaultRuleSet.Varchar(50, true, true));
        this.typeMap.put("see_lawa", new WatergisDefaultRuleSet.Varchar(20, true, true));
        this.typeMap.put("see_sp", new WatergisDefaultRuleSet.Varchar(8, true, true));
        this.typeMap.put("tmax", new WatergisDefaultRuleSet.Numeric(5, 2, false, true));
        this.typeMap.put("td", new WatergisDefaultRuleSet.Numeric(5, 2, false, true));
        this.typeMap.put("vol", new WatergisDefaultRuleSet.Numeric(10, 0, false, true));
        this.typeMap.put("tg", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("ue", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("ul", new WatergisDefaultRuleSet.Numeric(7, 3, false, true));
        this.typeMap.put("leff", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("beff", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("tabelle", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("flaeche") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("wk_fedfue");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (SgSeeWkRuleSet.isValueEmpty(newValue)) {
            if (column.equalsIgnoreCase("wk_nr")) {
                this.showMessage("Das Attribut wk_nr darf nicht leer sein", "wk_nr");
                return oldValue;
            }
            if (column.equalsIgnoreCase("see_gn")) {
                this.showMessage("Das Attribut see_gn darf nicht leer sein", "see_gn");
                return oldValue;
            }
            if (column.equalsIgnoreCase("see_lawa")) {
                this.showMessage("Das Attribut see_lawa darf nicht leer sein", "see_lawa");
                return oldValue;
            }
            if (column.equalsIgnoreCase("see_sp")) {
                this.showMessage("Das Attribut see_sp darf nicht leer sein", "see_sp");
                return oldValue;
            }
        }
        return newValue;
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        switch (columnName) {
            case "wk_nr": {
                return new LinkTableCellRenderer();
            }
            case "tabelle": {
                return new LinkTableCellRenderer();
            }
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("wk_nr")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(false);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return (String)bean.getProperty("wk_nr");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (SgSeeWkRuleSet.isValueEmpty(feature.getProperty("wk_nr"))) {
                this.showMessage("Das Attribut wk_nr darf nicht leer sein", "wk_nr");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "wk_nr");
            }
            if (SgSeeWkRuleSet.isValueEmpty(feature.getProperty("see_gn"))) {
                this.showMessage("Das Attribut see_gn darf nicht leer sein", "see_gn");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "see_gn");
            }
            if (SgSeeWkRuleSet.isValueEmpty(feature.getProperty("see_lawa"))) {
                this.showMessage("Das Attribut gbk_lawa darf nicht leer sein", "see_lawa");
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "see_lawa");
            }
            if (!SgSeeWkRuleSet.isValueEmpty(feature.getProperty("see_sp"))) continue;
            this.showMessage("Das Attribut see_sp darf nicht leer sein", "see_sp");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "see_sp");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        try {
            this.refreshTemplate("RefreshRwSegGeom");
            this.refreshTemplate("RefreshEzgKrl");
        }
        catch (ConnectionException ex) {
            this.LOG.error((Object)"Cannot refresh templates", (Throwable)ex);
        }
        super.afterSave(model);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("tabelle")) {
            if (value instanceof String && clickCount == 1) {
                SgSeeWkRuleSet.downloadDocumentFromWebDav(this.getSgLinkTablePath(), SgSeeWkRuleSet.addExtension(value.toString(), "xlsx"));
            }
        } else if (columnName.equals("wk_nr") && value instanceof String && clickCount == 1) {
            try {
                URL u = new URL(String.format(URL_TEMPLATE, value.toString()));
                try {
                    BrowserLauncher.openURL((String)u.toString());
                }
                catch (Exception ex) {
                    this.LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

