/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class SgUmringProfRuleSet
extends WatergisDefaultRuleSet {
    public SgUmringProfRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("see_id", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("see_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("see_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("see_sp", new WatergisDefaultRuleSet.Varchar(8, false, true));
        this.typeMap.put("br", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.minBaLength = 0.5;
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("laenge") && !columnName.equals("ww_gr") && !columnName.equals("see_id") && !columnName.equals("geom");
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_st_von")) {
            return new StationTableCellEditor(columnName);
        }
        if (columnName.equals("ba_st_bis")) {
            return new StationTableCellEditor(columnName);
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.sg_umring");
        WatergisDefaultRuleSet.OnOwnRouteStationCheck check = new WatergisDefaultRuleSet.OnOwnRouteStationCheck();
        StationLineCreator creator = new StationLineCreator("see_st", routeMc, "Umring D\u00fcV", (LinearReferencingHelper)new LinearReferencingWatergisHelper(), 0.5f);
        creator.setCheck((StationCreationCheck)check);
        return creator;
    }
}

