/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.watergis.server.actions.RefreshTemplateAction;
import de.cismet.cids.custom.watergis.server.search.CalculateFgLa;
import de.cismet.cids.custom.watergis.server.search.UniquenessCheck;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.custom.attributerule.DefaultCidsLayerAttributeTableRuleSet;
import de.cismet.cismap.custom.attributerule.MessageDialog;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.WebDavDownload;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.panels.DocumentCellEditor;
import de.cismet.watergis.utils.FeatureServiceHelper;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class WatergisDefaultRuleSet
extends DefaultCidsLayerAttributeTableRuleSet
implements AttributeTableExtendedRuleSet {
    private static final Logger LOG = Logger.getLogger(WatergisDefaultRuleSet.class);
    private static final String PROTECTEC_WBBL_PATH = "https://files.cismet.de/remote.php/webdav/watergis/watergis_secure/wr_wbu_wbbl_g/";
    private static final String UNPROTECTEC_WBBL_PATH = "https://files.cismet.de/remote.php/webdav/watergis/watergis/wr_wbu_wbbl_o/";
    private static final String SG_LINK_TABLE_PATH = "https://files.cismet.de/remote.php/webdav/watergis/watergis/sg_link_tabelle/";
    protected static final String WR_SG_WSG_UK_TABLE_PATH = "https://files.cismet.de/remote.php/webdav/watergis/watergis/wr_sg_wsg_uk/";
    protected static final String WR_SG_WSG_LK_TABLE_PATH = "https://files.cismet.de/remote.php/webdav/watergis/watergis/wr_sg_wsg_lk/";
    private static final String PHOTO_PATH = "http://fry.fis-wasser-mv.de/watergis/";
    protected static final double MIN_LINE_LENGTH = 0.01;
    protected static final double MIN_AREA_SIZE = 1.0E-4;
    private static String WEB_DAV_PASSWORD = null;
    private static String WEB_DAV_USER = null;
    private static Boolean accessToProtectedWbbl = null;
    public static String WK_FG_WEBDAV_PATH = "http://fry.fis-wasser-mv.de/watergis/wk-reports/";
    private static int currentYear = 0;
    private static final String PROTECTED_AREA_ACTION = "geschuetzte_wbbl";
    protected Double minLaLength = null;
    protected Double maxLaLength = null;
    protected Double minBaLength = null;
    protected Double maxBaLength = null;
    protected Double maxConfirmationlessLength = null;
    protected int idOfCurrentlyCheckedFeature = -1;
    protected final Map<String, DataType> typeMap = new HashMap<String, DataType>();
    private HashMap<ConfirmedValueKey, Object> confirmedValues = new HashMap();
    private final Map<DataType, TreeSet<FeatureServiceFeature>> changedObjectMap = new HashMap<DataType, TreeSet<FeatureServiceFeature>>();

    public WatergisDefaultRuleSet() {
        if (WEB_DAV_USER == null) {
            ResourceBundle bundle = ResourceBundle.getBundle("de/cismet/watergis/configuration/wbblWebDev");
            if (bundle == null) {
                WEB_DAV_PASSWORD = null;
                WEB_DAV_USER = "unknown";
                LOG.error((Object)"wbblWebDav.properties not found");
            } else {
                String pass = bundle.getString("password");
                if (pass != null) {
                    pass = new String(PasswordEncrypter.decrypt((char[])pass.toCharArray(), (boolean)true));
                }
                WEB_DAV_PASSWORD = pass;
                WEB_DAV_USER = bundle.getString("username");
            }
        }
    }

    public DataType getType(String columnName) {
        return this.typeMap.get(columnName);
    }

    public static void downloadDocumentFromWebDav(String path, String file) {
        if (!DownloadManagerDialog.getInstance().isAskForJobNameEnabled() || DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)AppBroker.getInstance().getRootWindow())) {
            String filename;
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            String extension = null;
            while (file.startsWith("/")) {
                file = file.substring(1);
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (file.contains(".")) {
                extension = file.substring(file.lastIndexOf("."));
                filename = file.substring(0, file.lastIndexOf("."));
            } else {
                filename = file;
            }
            if (filename.contains("/")) {
                filename = filename.substring(filename.lastIndexOf("/") + 1);
            }
            WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
            DownloadManager.instance().add((Download)new WebDavDownload(webDavClient, path + WebDavHelper.encodeURL((String)file), jobname, filename + extension, filename, extension));
        }
    }

    public static void downloadDocumentFromWebDav(String path, String file, String newFilename) {
        if (!DownloadManagerDialog.getInstance().isAskForJobNameEnabled() || DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)AppBroker.getInstance().getRootWindow())) {
            String filename;
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            String extension = null;
            while (file.startsWith("/")) {
                file = file.substring(1);
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (newFilename.contains(".")) {
                extension = newFilename.substring(file.lastIndexOf("."));
                filename = newFilename.substring(0, file.lastIndexOf("."));
            } else {
                filename = newFilename;
            }
            if (filename.contains("/")) {
                filename = filename.substring(filename.lastIndexOf("/") + 1);
            }
            WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
            DownloadManager.instance().add((Download)new WebDavDownload(webDavClient, path + WebDavHelper.encodeURL((String)file), jobname, filename + extension, filename, extension));
        }
    }

    protected void refreshTemplate(String template) throws ConnectionException {
        ServerActionParameter paramDbUser = new ServerActionParameter(RefreshTemplateAction.ParameterType.TEMPLATE.toString(), (Object)template);
        SessionManager.getProxy().executeTask("RefreshTemplate", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramDbUser});
    }

    public static WebDavClient createWebDavClient() {
        return new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean checkDocumentExistenceOnWebDav(String path, String file) {
        boolean bl;
        while (file.startsWith("/")) {
            file = file.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
        int statusCode = webDavClient.getStatusCode(path + WebDavHelper.encodeURL((String)file));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checkDocumentExistenceOnWebDav status code: " + statusCode));
        }
        if (statusCode == 200 || statusCode == 204) return true;
        WebDavClient webDavClientDownload = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
        InputStream is = webDavClientDownload.getInputStream(path + WebDavHelper.encodeURL((String)file));
        byte[] tmp = new byte[1000];
        try {
            boolean bl2 = bl = is.read(tmp) > 800;
            if (is == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                LOG.warn((Object)"Check link failed with exception.", (Throwable)ex);
                return false;
            }
        }
        is.close();
        return bl;
    }

    protected static Double round(double value, int digits) {
        BigDecimal bd = new BigDecimal(value);
        return bd.setScale(digits, RoundingMode.HALF_UP).doubleValue();
    }

    public static String addExtension(String name, String extension) {
        if (!name.toLowerCase().endsWith("." + extension.toLowerCase())) {
            return name + "." + extension;
        }
        return name;
    }

    public static String getWbblPath() {
        if (WatergisDefaultRuleSet.hasAccessToProtectedWbbl()) {
            return PROTECTEC_WBBL_PATH;
        }
        return UNPROTECTEC_WBBL_PATH;
    }

    protected String getSgLinkTablePath() {
        return SG_LINK_TABLE_PATH;
    }

    protected String getPhotoPath() {
        return PHOTO_PATH;
    }

    protected void adjustFisGDateAndFisGUser(FeatureServiceFeature feature) {
        if (feature.getId() < 0 || feature instanceof CidsLayerFeature && ((CidsLayerFeature)feature).isFeatureChanged()) {
            feature.getProperties().put("fis_g_date", new Timestamp(System.currentTimeMillis()));
            feature.getProperties().put("fis_g_user", SessionManager.getSession().getUser().getName());
        }
    }

    protected void refreshLaStation(final FeatureServiceFeature feature, final String baCd, final Double baSt, final String laCd, final String laSt) {
        Thread refreshLa = new Thread("refreshLa"){

            @Override
            public void run() {
                try {
                    if (baCd == null || baSt == null) {
                        feature.setProperty(laCd, null);
                        feature.setProperty(laSt, null);
                    } else {
                        CalculateFgLa search = new CalculateFgLa(baCd, baSt.doubleValue());
                        User user = SessionManager.getSession().getUser();
                        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                        if (attributes != null && attributes.size() > 0 && attributes.get(0) != null && ((ArrayList)attributes.get(0)).size() > 1) {
                            feature.setProperty(laCd, ((ArrayList)attributes.get(0)).get(0));
                            feature.setProperty(laSt, ((ArrayList)attributes.get(0)).get(1));
                        } else {
                            feature.setProperty(laCd, null);
                            feature.setProperty(laSt, null);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        refreshLa.start();
    }

    protected String getRouteFilter() {
        User u = SessionManager.getSession().getUser();
        if (u.getUserGroup().getName().equalsIgnoreCase("administratoren") || u.getUserGroup().getName().equalsIgnoreCase("admin_edit")) {
            return null;
        }
        if (AppBroker.getInstance().getOwnWwGr() != null && AppBroker.getInstance().getOwnWwGr().getProperty("ww_gr") != null) {
            StringBuilder query = null;
            List<CidsBean> wwGrs = AppBroker.getInstance().getOwnWwGrList();
            for (CidsBean wwGr : wwGrs) {
                if (query == null) {
                    query = new StringBuilder();
                    query.append("(");
                } else {
                    query.append(" or ");
                }
                Integer id = wwGr.getPrimaryKeyValue();
                query.append("dlm25wPk_ww_gr1=").append(id);
            }
            if (query != null) {
                query.append(")");
                return query.toString();
            }
        }
        return null;
    }

    protected static boolean isValueEmpty(Object field) {
        return field == null || field.toString().isEmpty();
    }

    protected static boolean isEqual(Number n1, Number n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.doubleValue() == n2.doubleValue();
    }

    public static boolean hasAccessToProtectedWbbl() {
        if (accessToProtectedWbbl == null) {
            try {
                String attr = SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), PROTECTED_AREA_ACTION);
                accessToProtectedWbbl = attr != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while checking action attribute", (Throwable)e);
                return false;
            }
        }
        return accessToProtectedWbbl;
    }

    protected CidsLayerFeatureFilter createCidsLayerFeatureFilter(String propertyName) {
        return this.createCidsLayerFeatureFilter(propertyName, false);
    }

    protected CidsLayerFeatureFilter createCidsLayerFeatureFilter(final String propertyName, final boolean justNotNull) {
        return new CidsLayerFeatureFilter(){

            public boolean accept(CidsLayerFeature bean) {
                if (bean == null) {
                    return true;
                }
                return bean.getProperty(propertyName) != null && (justNotNull || (Boolean)bean.getProperty(propertyName) != false);
            }
        };
    }

    protected CidsLayerFeatureFilter createCidsLayerFeatureFilter(final String propertyName, final String value) {
        return new CidsLayerFeatureFilter(){

            public boolean accept(CidsLayerFeature bean) {
                String vals;
                if (bean == null) {
                    return true;
                }
                if (bean.getProperty(propertyName) != null && (vals = (String)bean.getProperty(propertyName)) != null) {
                    String[] valueArray = vals.split(",");
                    return Arrays.asList(valueArray).contains(value);
                }
                return false;
            }
        };
    }

    protected static int getCurrentYear() {
        if (currentYear == 0) {
            currentYear = new GregorianCalendar().get(1);
        }
        return currentYear;
    }

    protected double round(double value) {
        return WatergisDefaultRuleSet.round(value, 2);
    }

    protected static CidsBean getCatalogueElement(String className, String attributeName, String value) {
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)className);
        String query = "select " + mc.getID() + ", " + mc.getPrimaryKey() + " from " + mc.getTableName();
        query = query + " WHERE " + attributeName + " = '" + value + "'";
        try {
            MetaObject[] mo = SessionManager.getConnection().getMetaObjectByQuery(SessionManager.getSession().getUser(), query);
            if (mo != null && mo.length > 0) {
                return mo[0].getBean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected boolean checkRangeBetweenOrEqual(String columnName, Object newValue, double from, double to, boolean nullable) {
        return this.checkRange(columnName, newValue, from, to, nullable, true, true);
    }

    protected boolean checkRangeBetweenOrEqual(String columnName, Object newValue, int from, int to, boolean nullable) {
        return this.checkRange(columnName, newValue, from, to, nullable, true, true);
    }

    protected boolean checkRangeBetweenOrEqual(String columnName, Object newValue, double from, double to, double fromMax, double toMax, boolean nullable) {
        return this.checkRange(columnName, newValue, from, to, fromMax, toMax, nullable, true, true);
    }

    protected boolean isNoInteger(String propName, Object value, boolean allowNull) {
        if (!WatergisDefaultRuleSet.isNumberOrNull(value)) {
            return true;
        }
        Number n = WatergisDefaultRuleSet.toNumber(value);
        if (n == null) {
            return allowNull;
        }
        if (n.doubleValue() != (double)n.intValue()) {
            this.showMessage("Das Attribut " + propName + " darf keine Nachkommastellen enthalten", propName);
            return true;
        }
        return false;
    }

    protected boolean isNoIntegerTempMessage(String propName, Object value, boolean allowNull) {
        if (!WatergisDefaultRuleSet.isNumberOrNull(value)) {
            return true;
        }
        Number n = WatergisDefaultRuleSet.toNumber(value);
        if (n == null) {
            return allowNull;
        }
        if (n.doubleValue() != (double)n.intValue()) {
            this.showMessage("Eingabe ist nur ganzzahlig zul\u00e4ssig", propName);
            return true;
        }
        return false;
    }

    protected boolean checkRange(String columnName, Object newValue, double from, double to, boolean nullable, boolean fromEqualAllowed, boolean toEqualAllowed) {
        if (newValue == null && !nullable) {
            this.showMessage("Das Attribut " + columnName + " darf nicht leer sein", columnName);
            return false;
        }
        if (newValue == null) {
            return true;
        }
        if (!(newValue instanceof Number)) {
            try {
                newValue = Double.parseDouble(String.valueOf(newValue));
            }
            catch (NumberFormatException e) {
                this.showMessage("Das Attribut " + columnName + " darf nur numerische Werte enthalten", columnName);
                return false;
            }
        }
        if (!((fromEqualAllowed && ((Number)newValue).doubleValue() >= from || !fromEqualAllowed && ((Number)newValue).doubleValue() > from) && (toEqualAllowed && ((Number)newValue).doubleValue() <= to || !toEqualAllowed && ((Number)newValue).doubleValue() < to))) {
            this.showMessage("Beim Attribut " + columnName + " sind nur Werte von " + (fromEqualAllowed ? "" : ">") + WatergisDefaultRuleSet.trimTrailingZeros(new BigDecimal(from).setScale(7, 4).toPlainString().replace('.', ',')) + " bis " + (toEqualAllowed ? "" : "<") + WatergisDefaultRuleSet.trimTrailingZeros(new BigDecimal(to).setScale(7, 4).toPlainString().replace('.', ',')) + " erlaubt.", columnName);
            return false;
        }
        return true;
    }

    private static String trimTrailingZeros(String number) {
        if (!number.contains(",") && !number.contains(".")) {
            return number;
        }
        StringBuilder builder = new StringBuilder(number);
        for (int i = number.length() - 1; i > 0 && number.charAt(i) == '0'; --i) {
            builder.deleteCharAt(i);
        }
        return builder.toString();
    }

    protected boolean checkRange(String columnName, Object newValue, int from, int to, boolean nullable, boolean fromEqualAllowed, boolean toEqualAllowed) {
        if (newValue == null && !nullable) {
            this.showMessage("Das Attribut " + columnName + " darf nicht leer sein", columnName);
            return false;
        }
        if (newValue == null) {
            return true;
        }
        if (!(newValue instanceof Number)) {
            try {
                newValue = Double.parseDouble(String.valueOf(newValue));
            }
            catch (NumberFormatException e) {
                this.showMessage("Das Attribut " + columnName + " darf nur numerische Werte enthalten", columnName);
                return false;
            }
        }
        if (!((fromEqualAllowed && ((Number)newValue).doubleValue() >= (double)from || !fromEqualAllowed && ((Number)newValue).doubleValue() > (double)from) && (toEqualAllowed && ((Number)newValue).doubleValue() <= (double)to || !toEqualAllowed && ((Number)newValue).doubleValue() < (double)to))) {
            this.showMessage("Beim Attribut " + columnName + " sind nur Werte von " + (fromEqualAllowed ? "" : ">") + from + " bis " + (toEqualAllowed ? "" : "<") + to + " erlaubt.", columnName);
            return false;
        }
        return true;
    }

    protected boolean checkRange(String columnName, Object newValue, double from, double to, double fromMax, double toMax, boolean nullable, boolean fromEqualAllowed, boolean toEqualAllowed) {
        if (newValue == null && !nullable) {
            this.showMessage("Das Attribut " + columnName + " darf nicht leer sein", columnName);
            return false;
        }
        if (newValue == null) {
            return true;
        }
        if (!(newValue instanceof Number)) {
            try {
                newValue = Double.parseDouble(String.valueOf(newValue));
            }
            catch (NumberFormatException e) {
                this.showMessage("Das Attribut " + columnName + " darf nur numerische Werte enthalten", columnName);
                return false;
            }
        }
        double newDoubleValue = ((Number)newValue).doubleValue();
        if (fromEqualAllowed && newDoubleValue < from && newDoubleValue >= fromMax || !fromEqualAllowed && newDoubleValue <= from && newDoubleValue > fromMax || toEqualAllowed && newDoubleValue <= toMax && newDoubleValue > to || !toEqualAllowed && newDoubleValue < toMax && newDoubleValue >= to) {
            return this.showSecurityQuestion("Wert au\u00dferhalb Standardbereich (" + from + ", " + to + ") --> verwenden ?", columnName, newValue);
        }
        if (fromEqualAllowed && newDoubleValue < fromMax || !fromEqualAllowed && newDoubleValue <= fromMax || toEqualAllowed && newDoubleValue > toMax || !toEqualAllowed && newDoubleValue >= toMax) {
            this.showMessage("Wert nicht zul\u00e4ssig, weil au\u00dferhalb " + (fromEqualAllowed ? " [" : " (") + fromMax + ", " + toMax + (toEqualAllowed ? " ]" : " )"), columnName);
            return false;
        }
        return true;
    }

    protected boolean checkRange(String columnName, Object newValue, int from, int to, int fromMax, int toMax, boolean nullable, boolean fromEqualAllowed, boolean toEqualAllowed) {
        if (newValue == null && !nullable) {
            this.showMessage("Das Attribut " + columnName + " darf nicht leer sein", columnName);
            return false;
        }
        if (newValue == null) {
            return true;
        }
        if (!(newValue instanceof Number)) {
            try {
                newValue = Double.parseDouble(String.valueOf(newValue));
            }
            catch (NumberFormatException e) {
                this.showMessage("Das Attribut " + columnName + " darf nur numerische Werte enthalten", columnName);
                return false;
            }
        }
        double newDoubleValue = ((Number)newValue).doubleValue();
        if (fromEqualAllowed && newDoubleValue < (double)from && newDoubleValue >= (double)fromMax || !fromEqualAllowed && newDoubleValue <= (double)from && newDoubleValue > (double)fromMax || toEqualAllowed && newDoubleValue <= (double)toMax && newDoubleValue > (double)to || !toEqualAllowed && newDoubleValue < (double)toMax && newDoubleValue >= (double)to) {
            return this.showSecurityQuestion("Wert au\u00dferhalb Standardbereich (" + from + ", " + to + ") --> verwenden ?", columnName, newValue);
        }
        if (fromEqualAllowed && newDoubleValue < (double)fromMax || !fromEqualAllowed && newDoubleValue <= (double)fromMax || toEqualAllowed && newDoubleValue > (double)toMax || !toEqualAllowed && newDoubleValue >= (double)toMax) {
            this.showMessage("Wert nicht zul\u00e4ssig, weil au\u00dferhalb " + (fromEqualAllowed ? " [" : " (") + fromMax + ", " + toMax + (toEqualAllowed ? " ]" : " )"), columnName);
            return false;
        }
        return true;
    }

    protected void showMessage(String text, String field) {
        String title = "Ung\u00fcltig ID: " + this.idOfCurrentlyCheckedFeature + " Feld: " + field;
        MessageDialog d = new MessageDialog((Frame)AppBroker.getInstance().getWatergisApp(), true, text, title);
        d.setSize(500, 80);
        StaticSwingTools.showDialog((JDialog)d);
    }

    protected static void showMessage(String text) {
        MessageDialog d = new MessageDialog((Frame)AppBroker.getInstance().getWatergisApp(), true, text);
        d.setSize(500, 80);
        StaticSwingTools.showDialog((JDialog)d);
    }

    protected boolean showSecurityQuestion(String text, String field, Object newValue) {
        ConfirmedValueKey key = new ConfirmedValueKey(this.idOfCurrentlyCheckedFeature, field);
        if (this.confirmedValues.get(key) == null || !this.confirmedValues.get(key).equals(this.roundIfDouble(newValue))) {
            int answ = JOptionPane.showConfirmDialog(AppBroker.getInstance().getWatergisApp(), text, "Best\u00e4tigung ID: " + this.idOfCurrentlyCheckedFeature + " Feld: " + field, 0);
            this.confirmedValues.put(key, this.roundIfDouble(newValue));
            return answ == 0;
        }
        return true;
    }

    private Object roundIfDouble(Object value) {
        if (value instanceof Double) {
            BigDecimal bd = new BigDecimal((Double)value);
            bd = bd.stripTrailingZeros();
            int tmpScale = bd.scale();
            int digitsOnTheLeft = bd.precision() - tmpScale;
            return bd.round(new MathContext(digitsOnTheLeft + 8, RoundingMode.HALF_UP)).doubleValue();
        }
        return value;
    }

    protected boolean checkGreaterThan(String columnName, Object newValue, double minVal, boolean nullable, boolean minEqualAllowed) {
        if (newValue == null && !nullable) {
            this.showMessage("Das Attribut " + columnName + " darf nicht leer sein", columnName);
            return false;
        }
        if (newValue == null) {
            return true;
        }
        if (!(newValue instanceof Number)) {
            try {
                newValue = Double.parseDouble(String.valueOf(newValue));
            }
            catch (NumberFormatException e) {
                this.showMessage("Das Attribut " + columnName + " darf nur numerische Werte enthalten", columnName);
                return false;
            }
        }
        if (minEqualAllowed && ((Number)newValue).doubleValue() < minVal || !minEqualAllowed && ((Number)newValue).doubleValue() <= minVal) {
            String greaterText = minEqualAllowed ? " gr\u00f6\u00dfer oder gleich " : " gr\u00f6\u00dfer ";
            this.showMessage("Das Attribut " + columnName + " muss" + greaterText + minVal + " sein.", columnName);
            return false;
        }
        return true;
    }

    protected static boolean isValueIn(Object value, Object[] allowedValues, boolean nullAllowed) {
        if (value == null) {
            return nullAllowed;
        }
        String stringValue = value.toString();
        for (Object o : allowedValues) {
            if (!stringValue.equals(o)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasValue(String columnName, Object newValue, double value, boolean nullable) {
        if (newValue == null && !nullable) {
            this.showMessage("Das Attribut " + columnName + " darf nicht leer sein", columnName);
            return false;
        }
        if (newValue == null) {
            return true;
        }
        if (!(newValue instanceof Number)) {
            try {
                newValue = Double.parseDouble(String.valueOf(newValue));
            }
            catch (NumberFormatException e) {
                this.showMessage("Das Attribut " + columnName + " darf nur numerische Werte enthalten", columnName);
                return false;
            }
        }
        return ((Number)newValue).doubleValue() == value;
    }

    protected static Number toNumber(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (!(o instanceof Number)) {
            try {
                return Double.parseDouble(String.valueOf(o));
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return (Number)o;
    }

    protected static boolean isNumberOrNull(Object o) {
        if (o == null) {
            return true;
        }
        if (!(o instanceof Number)) {
            try {
                Double d = Double.parseDouble(String.valueOf(o));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    protected static boolean arrayContains(String[] array, String element) {
        for (String tmp : array) {
            if ((tmp != null || element != null) && (tmp == null || element == null || !tmp.toLowerCase().equals(element.toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    protected static String arrayToString(String[] array) {
        StringBuilder builder = new StringBuilder();
        for (String tmp : array) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(tmp);
        }
        return builder.toString();
    }

    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (AppBroker.getInstance().getOwnWwGr() != null) {
            properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        } else {
            properties.put("ww_gr", AppBroker.getInstance().getNiemandWwGr());
        }
        return properties;
    }

    public void copyProperties(FeatureServiceFeature sourceFeature, FeatureServiceFeature targetFeature) {
        boolean hasIdExpression = targetFeature.getLayerProperties().getIdExpressionType() == 1;
        Map attributeMap = targetFeature.getLayerProperties().getFeatureService().getFeatureServiceAttributes();
        Object[] calculatedFields = this.getAdditionalFieldNames();
        Arrays.sort(calculatedFields);
        for (String attrKey : attributeMap.keySet()) {
            Object val;
            if (hasIdExpression && targetFeature.getLayerProperties().getIdExpression().equalsIgnoreCase(attrKey) || attrKey.equalsIgnoreCase("obj_nr") || Arrays.binarySearch(calculatedFields, attrKey) >= 0 || (val = this.getFeaturePropertyIgnoreCase(sourceFeature, attrKey)) == null) continue;
            targetFeature.setProperty(attrKey, val);
        }
        Map<String, Object> defaultValues = this.getDefaultValues();
        if (defaultValues != null) {
            for (String propName : defaultValues.keySet()) {
                if (!attributeMap.containsKey(propName)) continue;
                targetFeature.setProperty(propName, defaultValues.get(propName));
            }
        }
    }

    private Object getFeaturePropertyIgnoreCase(FeatureServiceFeature feature, String name) {
        for (Object prop : feature.getProperties().keySet()) {
            String propName;
            if (!(prop instanceof String) || !(propName = (String)prop).equalsIgnoreCase(name)) continue;
            return feature.getProperty(propName);
        }
        return null;
    }

    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        DataType type = this.typeMap.get(columnName);
        if ((type instanceof Document || type instanceof Catalogue && ((Catalogue)type).getDataType() instanceof Document) && value instanceof String && clickCount == 1) {
            String origPath = (String)((CidsLayerFeature)feature).getBean().getProperty(columnName + "_dateipfad");
            String path = origPath.substring(0, origPath.lastIndexOf("/"));
            String file = origPath.substring(origPath.lastIndexOf("/") + 1);
            String filename = (String)feature.getProperty(columnName);
            WatergisDefaultRuleSet.downloadDocumentFromWebDav(path, file, filename);
        }
    }

    public TableCellRenderer getCellRenderer(String columnName) {
        DataType type = this.typeMap.get(columnName);
        if (columnName.equals("id") || columnName.equals("ww_gr")) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setHorizontalAlignment(4);
                        ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                    }
                    return c;
                }
            };
        }
        if (type != null) {
            if (type instanceof Numeric || type instanceof Catalogue && ((Catalogue)type).getDataType() instanceof Numeric) {
                final Numeric numType = type instanceof Numeric ? (Numeric)type : (Numeric)((Catalogue)type).getDataType();
                return new DefaultTableCellRenderer(){
                    DecimalFormat format = new DecimalFormat();
                    DecimalFormat formatWithOutdecimals = new DecimalFormat();
                    {
                        this.format.setGroupingUsed(false);
                        this.format.setMaximumFractionDigits(numType.getScale());
                        this.format.setMinimumFractionDigits(numType.getScale());
                        this.formatWithOutdecimals.setGroupingUsed(false);
                        this.formatWithOutdecimals.setMaximumFractionDigits(0);
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c;
                        Object val = value;
                        if (value instanceof Number) {
                            val = this.format.format(value);
                        } else if (value instanceof String) {
                            try {
                                val = Double.parseDouble((String)value);
                                val = this.format.format(val);
                            }
                            catch (NumberFormatException e) {
                                LOG.error((Object)"Numeric field does not contain a numeric value", (Throwable)e);
                            }
                        }
                        if (val != null && numType.isShowDecimalsOnlyIfExists()) {
                            try {
                                double doubleVal = this.format.parse(val.toString()).doubleValue();
                                long longVal = (long)doubleVal;
                                if (doubleVal == (double)longVal) {
                                    val = this.formatWithOutdecimals.format(longVal);
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Numeric field does not contain a numeric value", (Throwable)e);
                            }
                        }
                        if ((c = super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column)) instanceof JLabel) {
                            ((JLabel)c).setHorizontalAlignment(4);
                            ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                        }
                        return c;
                    }
                };
            }
            if (type instanceof BooleanAsInteger || type instanceof Catalogue && ((Catalogue)type).isRightAlignment()) {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (c instanceof JLabel) {
                            ((JLabel)c).setHorizontalAlignment(4);
                            ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                        }
                        return c;
                    }
                };
            }
            if (type instanceof Document || type instanceof Catalogue && ((Catalogue)type).getDataType() instanceof Document) {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (c instanceof JLabel) {
                            ((JLabel)c).setHorizontalAlignment(2);
                            ((JLabel)c).setBorder(new EmptyBorder(0, 0, 0, 2));
                        }
                        return c;
                    }
                };
            }
            if (type instanceof Link && ((Link)type).isRightAlignment()) {
                return new LinkTableCellRenderer(4);
            }
        }
        return null;
    }

    public void beforeSave(FeatureServiceFeature feature) {
        for (Object o : new ArrayList(feature.getProperties().keySet())) {
            String key = String.valueOf(o);
            DataType type = this.typeMap.get(key);
            if (!(type instanceof Document) && (!(type instanceof Catalogue) || !(((Catalogue)type).getDataType() instanceof Document))) continue;
            String pathKey = key + "_dateipfad";
            String val = (String)feature.getProperty(key);
            Object path = feature.getProperty(pathKey);
            if (path != null) continue;
            WebDavClient webDavClient = WatergisDefaultRuleSet.createWebDavClient();
            File fileObject = new File(val);
            String webFileName = WebDavHelper.generateWebDAVFileName((String)"DOC-", (File)fileObject);
            feature.setProperty(key, (Object)val.substring(val.lastIndexOf("/") + 1));
            try {
                int statusCode = WebDavHelper.uploadFileToWebDAV((String)webFileName, (File)fileObject, (String)"https://files.cismet.de/remote.php/webdav/watergis/watergis/documents/", (WebDavClient)webDavClient, (Component)AppBroker.getInstance().getWatergisApp());
                ((CidsLayerFeature)feature).getBean().setProperty(pathKey, (Object)("https://files.cismet.de/remote.php/webdav/watergis/watergis/documents/" + webFileName));
                feature.setProperty(pathKey, (Object)("https://files.cismet.de/remote.php/webdav/watergis/watergis/documents/" + webFileName));
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot upload file", (Throwable)e);
            }
        }
    }

    public TableCellEditor getCellEditor(String columnName) {
        DataType type = this.typeMap.get(columnName);
        if (type instanceof Document || type instanceof Catalogue && ((Catalogue)type).getDataType() instanceof Document) {
            return new DocumentCellEditor(columnName);
        }
        return super.getCellEditor(columnName);
    }

    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        DataType type = this.typeMap.get(column);
        if (type != null) {
            ValidationResult result;
            if (type.isUnique()) {
                TreeSet<Object> changedObjects = this.changedObjectMap.get(type);
                if (changedObjects == null) {
                    changedObjects = new TreeSet();
                    this.changedObjectMap.put(type, changedObjects);
                }
                changedObjects.add(feature);
                HashMap<Integer, String> idValueMap = new HashMap<Integer, String>();
                if (changedObjects != null && changedObjects.contains(feature)) {
                    String stalu = newValue != null ? String.valueOf(newValue) : (String)newValue;
                    idValueMap.put((Integer)feature.getProperty("id"), stalu);
                }
                if (!idValueMap.isEmpty()) {
                    try {
                        ArrayList list;
                        User user = SessionManager.getSession().getUser();
                        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new UniquenessCheck(idValueMap, type.field, type.table));
                        if (attributes != null && !attributes.isEmpty() && (list = (ArrayList)attributes.get(0)) != null && !list.isEmpty()) {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().message", list.get(0), (Object)type.field), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().title", (Object)type.field), 0);
                            return oldValue;
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().error.message", (Object)type.field), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().error.title"), 0);
                        LOG.error((Object)"Error while checking the uniqueness of the ba_cd field.", (Throwable)e);
                        return oldValue;
                    }
                }
            }
            if ((column.equals("ba_st") || column.equals("bak_st") || column.equals("su_st") || column.equals("su_st_bis") || column.equals("su_st_von") || column.equals("la_st") || column.equals("la_st_bis") || column.equals("la_st_von") || column.equals("ba_st_bis") || column.equals("ba_st_von") || column.equals("bak_st_bis") || column.equals("bak_st_von")) && newValue instanceof Double && feature instanceof CidsLayerFeature && ((CidsLayerFeature)feature).getStationEditor(column) != null) {
                LinearReferencingHelper helper;
                Geometry routeGeom;
                CidsLayerFeature cidsFeature = (CidsLayerFeature)feature;
                CidsBean lineBean = cidsFeature.getStationEditor(column).getLineBean();
                if ((Double)newValue < 0.0) {
                    JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Der Stationswert liegt au\u00dferhalb der Route.", "Fehlerhafte Eingabe", 0);
                    return 0;
                }
                if (lineBean != null && (routeGeom = (helper = FeatureRegistry.getInstance().getLinearReferencingSolver()).getRouteGeometryFromStationBean(helper.getStationBeanFromLineBean(lineBean, true))) != null && (Double)newValue - 0.01 > routeGeom.getLength()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Der Stationswert liegt au\u00dferhalb der Route.", "Fehlerhafte Eingabe", 0);
                        }
                    });
                }
            }
            if ((result = type.isValidValue(newValue)).getValidationResult() == Validation.OK) {
                return newValue;
            }
            if (result.getValidationResult() == Validation.NULL) {
                this.showMessage("Das Attribut " + column + " darf nicht leer sein", column);
                return oldValue;
            }
            if (result.getValidationResult() == Validation.SIZE_CORRECTION) {
                return result.getChangedValue();
            }
            if (result.getValidationResult() == Validation.OUT_OF_SIZE) {
                this.showMessage("Das Attribut " + column + " muss den Datentyp " + type.toString() + " haben", column);
                return oldValue;
            }
            if (result.getValidationResult() == Validation.WRONG_DATA_TYPE) {
                this.showMessage("Das Attribut " + column + " muss den Datentyp " + type.toString() + " haben", column);
                return oldValue;
            }
            if (result.getValidationResult() == Validation.WRONG_RANGE) {
                this.showMessage("Das Attribut " + column + " hat folgenden Wertebereich: " + type.range(column), column);
                return oldValue;
            }
            if (result.getValidationResult() == Validation.NOT_BINARY) {
                this.showMessage("Wert nicht zul\u00e4ssig, weil au\u00dferhalb (0/1" + (type.isNotNull() ? "" : "/NULL") + ")", column);
                return oldValue;
            }
            if (result.getValidationResult() == Validation.WBBL_NOT_ACCESSIBLE) {
                this.showMessage("Wert nicht zul\u00e4ssig, weil Wasserbuchblatt nicht existiert", column);
                return oldValue;
            }
            if (result.getValidationResult() == Validation.NOT_IN_VALUE_TABLE) {
                this.showMessage("Der Wert ist nicht zul\u00e4ssig. Zul\u00e4ssig sind:\n" + this.toList(result.getAllowedValues()), column);
                return oldValue;
            }
        }
        return newValue;
    }

    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (String attribute : this.typeMap.keySet()) {
            HashMap<Integer, String> idValueMap = new HashMap<Integer, String>();
            DataType type = this.typeMap.get(attribute);
            if (!type.editable) continue;
            for (FeatureServiceFeature feature : features) {
                ValidationResult result;
                TreeSet<FeatureServiceFeature> changedObjects;
                this.idOfCurrentlyCheckedFeature = feature.getId();
                String fieldId = "ID: " + this.idOfCurrentlyCheckedFeature + " Feld: " + attribute;
                if (type.isUnique() && (changedObjects = this.changedObjectMap.get(type)) != null && changedObjects.contains(feature)) {
                    String stalu = feature.getProperty(type.field) != null ? String.valueOf(feature.getProperty(type.field)) : (String)feature.getProperty(type.field);
                    idValueMap.put((Integer)feature.getProperty("id"), stalu);
                }
                if ((result = type.isValidValue(feature.getProperty(attribute))).getValidationResult() == Validation.NULL) {
                    this.showMessage("Das Attribut " + attribute + " darf nicht leer sein", attribute);
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, attribute);
                }
                if (result.getValidationResult() == Validation.SIZE_CORRECTION) {
                    try {
                        feature.setProperty(attribute, result.changedValue);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while set corrected property value", (Throwable)e);
                    }
                    continue;
                }
                if (result.getValidationResult() == Validation.OUT_OF_SIZE) {
                    this.showMessage("Das Attribut " + attribute + " muss den Datentyp " + type.toString() + " haben", attribute);
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, attribute);
                }
                if (result.getValidationResult() == Validation.WRONG_DATA_TYPE) {
                    JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Das Attribut " + attribute + " muss den Datentyp " + type.toString() + " haben", fieldId, 0);
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, attribute);
                }
                if (result.getValidationResult() == Validation.WRONG_RANGE) {
                    this.showMessage("Das Attribut " + attribute + " hat folgenden Wertebereich: " + type.range(attribute), attribute);
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, attribute);
                }
                if (result.getValidationResult() == Validation.NOT_BINARY) {
                    this.showMessage("Das Attribut " + attribute + " hat einen ung\u00fcltigen Wert. Der Wertebereich ist (0/1" + (type.isNotNull() ? "" : "/NULL") + ")", attribute);
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, attribute);
                }
                if (result.getValidationResult() == Validation.WBBL_NOT_ACCESSIBLE) {
                    this.showMessage("Wert nicht zul\u00e4ssig, weil Wasserbuchblatt nicht existiert", attribute);
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, attribute);
                }
                if (result.getValidationResult() != Validation.NOT_IN_VALUE_TABLE) continue;
                this.showMessage("Der Wert ist nicht zul\u00e4ssig. Zul\u00e4ssig sind:\n" + this.toList(result.getAllowedValues()), attribute);
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, attribute);
            }
            if (idValueMap.isEmpty()) continue;
            try {
                ArrayList list;
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new UniquenessCheck(idValueMap, type.field, type.table));
                if (attributes == null || attributes.isEmpty() || (list = (ArrayList)attributes.get(0)) == null || list.isEmpty()) continue;
                String fieldId = "ID: " + this.idOfCurrentlyCheckedFeature + " Feld: " + attribute;
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().message", list.get(0), (Object)type.field), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().title", (Object)type.field) + " " + fieldId, 0);
                return new AttributeTableExtendedRuleSet.ErrorDetails(this.getFeatureWithId(features, this.idOfCurrentlyCheckedFeature), attribute);
            }
            catch (Exception e) {
                String fieldId = "ID: " + this.idOfCurrentlyCheckedFeature + " Feld: " + attribute;
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().error.message", (Object)type.field), NbBundle.getMessage(WatergisDefaultRuleSet.class, (String)"WatergisDefaultRuleSet.prepareForSave().error.title") + " " + fieldId, 0);
                LOG.error((Object)"Error while checking the uniqueness of the ba_cd field.", (Throwable)e);
                return new AttributeTableExtendedRuleSet.ErrorDetails(this.getFeatureWithId(features, this.idOfCurrentlyCheckedFeature), attribute);
            }
        }
        for (FeatureServiceFeature feature : features) {
            Double till;
            Double from;
            this.idOfCurrentlyCheckedFeature = feature.getId();
            if (this.minBaLength != null) {
                from = (Double)feature.getProperty("ba_st_von");
                till = (Double)feature.getProperty("ba_st_bis");
                if (from != null && till != null && Math.abs(till - from) < this.minBaLength) {
                    this.showMessage("Die L\u00e4nge des Objektes darf nicht kleiner " + this.minBaLength + " m sein", "ba_st_bis");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
                }
            }
            if (this.maxBaLength != null) {
                from = (Double)feature.getProperty("ba_st_von");
                till = (Double)feature.getProperty("ba_st_bis");
                if (from != null && till != null && Math.abs(till - from) > this.maxBaLength) {
                    this.showMessage("Die L\u00e4nge des Objektes darf nicht gr\u00f6\u00dfer " + this.maxBaLength + " m sein", "ba_st_bis");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
                }
            }
            if (this.maxConfirmationlessLength != null) {
                from = (Double)feature.getProperty("ba_st_von");
                till = (Double)feature.getProperty("ba_st_bis");
                if (from != null && till != null && Math.abs(till - from) > this.maxConfirmationlessLength && !this.showSecurityQuestion("Wert au\u00dferhalb Standardbereich (" + this.minBaLength + ", " + this.maxConfirmationlessLength + ") --> verwenden ?", "L\u00e4nge", Math.abs(till - from))) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "ba_st_bis");
                }
            }
            if (this.minLaLength != null) {
                from = (Double)feature.getProperty("la_st_von");
                till = (Double)feature.getProperty("la_st_bis");
                if (from != null && till != null && Math.abs(till - from) < this.minLaLength) {
                    this.showMessage("Die L\u00e4nge des Objektes darf nicht kleiner " + this.minLaLength + " m sein", "la_st_bis");
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "la_st_bis");
                }
            }
            if (this.maxLaLength == null) continue;
            from = (Double)feature.getProperty("la_st_von");
            till = (Double)feature.getProperty("la_st_bis");
            if (from == null || till == null || !(Math.abs(till - from) > this.maxLaLength)) continue;
            this.showMessage("Die L\u00e4nge des Objektes darf nicht gr\u00f6\u00dfer" + this.maxLaLength + " m sein", "la_st_bis");
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "la_st_bis");
        }
        return null;
    }

    private String toList(String[] values) {
        StringBuilder sb = null;
        if (values != null) {
            for (String val : values) {
                if (sb == null) {
                    sb = new StringBuilder(val);
                    continue;
                }
                sb.append(", ").append(val);
            }
        }
        return sb != null ? sb.toString() : "";
    }

    protected void reloadService(String name) {
        AttributeTable tablePf;
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree(name);
        for (AbstractFeatureService featureService : services) {
            featureService.retrieve(true);
        }
        if (services != null && !services.isEmpty() && (tablePf = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeatureService(services.get(0))) != null) {
            tablePf.reload();
        }
    }

    private FeatureServiceFeature getFeatureWithId(List<FeatureServiceFeature> features, Integer id) {
        for (FeatureServiceFeature f : features) {
            if (f.getId() != id.intValue()) continue;
            return f;
        }
        return null;
    }

    public static void main(String[] args) {
        BigDecimal bd = new BigDecimal("14E2");
        bd = bd.stripTrailingZeros();
        int tmpScale = bd.scale();
        int tmpPrecision = bd.precision();
        int digitsOnTheLeft = bd.toBigInteger().toString().length();
        System.out.println("scale " + tmpScale + " precision " + tmpPrecision + " left " + digitsOnTheLeft);
    }

    protected String to2Digits(int value) {
        if (value > 9) {
            return "" + value;
        }
        return "0" + value;
    }

    public static class TimeFormatter
    extends Format {
        DateFormat formatterFull = new SimpleDateFormat("HH:mm:ss");
        DateFormat formatter = new SimpleDateFormat("HH:mm");

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            if (obj == null) {
                return null;
            }
            StringBuffer sb = this.formatterFull.format(obj, toAppendTo, pos);
            return sb;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            if (source.equals("")) {
                pos.setIndex(1);
                return null;
            }
            Object o = this.formatterFull.parseObject(source, pos);
            if (o == null) {
                o = this.formatter.parseObject(source, pos);
            }
            return o;
        }
    }

    private static class ConfirmedValueKey {
        private final int id;
        private final String field;

        public ConfirmedValueKey(int id, String field) {
            this.id = id;
            this.field = field;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConfirmedValueKey) {
                ConfirmedValueKey key = (ConfirmedValueKey)obj;
                return key.id == this.id && key.field.equals(this.field);
            }
            return false;
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + this.id;
            hash = 29 * hash + Objects.hashCode(this.field);
            return hash;
        }
    }

    protected static class OnOtherRouteStationCheck
    implements StationCreationCheck {
        protected OnOtherRouteStationCheck() {
        }

        public boolean isRouteValid(PFeature feature) {
            if (feature.getFeature() instanceof FeatureServiceFeature) {
                User u = SessionManager.getSession().getUser();
                if (u.getUserGroup().getName().equalsIgnoreCase("administratoren") || u.getUserGroup().getName().equalsIgnoreCase("admin_edit")) {
                    return true;
                }
                FeatureServiceFeature f = (FeatureServiceFeature)feature.getFeature();
                CidsBean wwGr = this.getWwGrBeanFromProperty(f);
                if (AppBroker.getInstance().getOwnWwGr() != null && AppBroker.getInstance().getOwnWwGr().getProperty("ww_gr") != null) {
                    if (wwGr != null && wwGr.getProperty("owner").equals(u.getUserGroup().getName())) {
                        return false;
                    }
                    return wwGr == null || !wwGr.getProperty("ww_gr").equals(4000);
                }
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), "Sie m\u00fcssen genau eine fremde Route w\u00e4hlen", "Fehler Thema-/Gew\u00e4sserwahl", 2);
                return false;
            }
            return false;
        }

        public boolean isStationValid(CidsBean feature, double start, double end) {
            return true;
        }

        protected CidsBean getWwGrBeanFromProperty(FeatureServiceFeature feature) {
            Object wwGrObject = feature.getProperty("ww_gr");
            List<CidsBean> wwgrBeans = AppBroker.getInstance().getWwGrList();
            if (wwGrObject == null) {
                return null;
            }
            if (wwGrObject instanceof CidsBean) {
                return (CidsBean)wwGrObject;
            }
            if (wwGrObject instanceof CidsLayerFeature) {
                CidsLayerFeature f = (CidsLayerFeature)wwGrObject;
                for (CidsBean bean : wwgrBeans) {
                    if (!bean.getProperty("id").equals(f.getId())) continue;
                    return bean;
                }
            } else {
                String wwGr = wwGrObject.toString();
                for (CidsBean bean : wwgrBeans) {
                    if (bean.getProperty("ww_gr") == null || !bean.getProperty("ww_gr").toString().equals(wwGr)) continue;
                    return bean;
                }
            }
            return null;
        }
    }

    protected static class OnOwnRouteStationStartOrEndCheck
    extends OnOwnRouteStationCheck {
        protected OnOwnRouteStationStartOrEndCheck() {
        }

        @Override
        public boolean isStationValid(CidsBean route, double start, double end) {
            boolean result;
            Geometry routeGeom = (Geometry)route.getProperty("geom.geo_field");
            if (routeGeom == null) {
                return false;
            }
            boolean bl = result = start == 0.0 || Math.abs(end - routeGeom.getLength()) < 0.01;
            if (!result) {
                WatergisDefaultRuleSet.showMessage(NbBundle.getMessage(OnOwnRouteStationStartOrEndCheck.class, (String)"WatergisDefaultRuleSet.OnOwnRouteStationStartOrEndCheck.isStationValid().false"));
            }
            return result;
        }
    }

    protected static class OnOwnRouteStationCheck
    extends OnOtherRouteStationCheck {
        protected OnOwnRouteStationCheck() {
        }

        @Override
        public boolean isRouteValid(PFeature feature) {
            if (feature.getFeature() instanceof FeatureServiceFeature) {
                User u = SessionManager.getSession().getUser();
                if (u.getUserGroup().getName().equalsIgnoreCase("administratoren") || u.getUserGroup().getName().equalsIgnoreCase("admin_edit")) {
                    return true;
                }
                FeatureServiceFeature f = (FeatureServiceFeature)feature.getFeature();
                CidsBean wwGr = this.getWwGrBeanFromProperty(f);
                if (AppBroker.getInstance().getOwnWwGr() != null && AppBroker.getInstance().getOwnWwGr().getProperty("ww_gr") != null) {
                    if (wwGr != null && wwGr.getProperty("owner").equals(u.getUserGroup().getName())) {
                        return true;
                    }
                    if (wwGr != null && wwGr.getProperty("ww_gr").equals(4000)) {
                        return true;
                    }
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), "Sie m\u00fcssen genau eine eigene Route w\u00e4hlen", "Fehler Thema-/Gew\u00e4sserwahl", 2);
                    return false;
                }
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), "Sie m\u00fcssen genau eine eigene Route w\u00e4hlen", "Fehler Thema-/Gew\u00e4sserwahl", 2);
                return false;
            }
            return false;
        }
    }

    protected static class WwGrAdminFilter
    implements CidsLayerFeatureFilter {
        protected WwGrAdminFilter() {
        }

        public boolean accept(CidsLayerFeature bean) {
            return bean != null;
        }
    }

    protected static class ValidationResult {
        private final Validation validationResult;
        private final boolean valueChanged;
        private final Object changedValue;
        private String[] allowedValues = null;

        public ValidationResult(Validation validationResult) {
            this(validationResult, false, null);
        }

        public ValidationResult(Validation validationResult, String[] allowedValues) {
            this.validationResult = validationResult;
            this.allowedValues = allowedValues;
            this.valueChanged = false;
            this.changedValue = null;
        }

        public ValidationResult(Validation validationResult, boolean valueChanged, Object changedValue) {
            this.validationResult = validationResult;
            this.valueChanged = valueChanged;
            this.changedValue = changedValue;
        }

        public String[] getAllowedValues() {
            return this.allowedValues;
        }

        public Validation getValidationResult() {
            return this.validationResult;
        }

        public boolean isValueChanged() {
            return this.valueChanged;
        }

        public Object getChangedValue() {
            return this.changedValue;
        }
    }

    public static class Document
    extends DataType {
        public Document(boolean notNull, boolean editable, String field) {
            super(notNull, false, editable, null, "dlm25w.Dokument");
        }

        @Override
        public String toString() {
            return "Dokument";
        }
    }

    public static class Catalogue
    extends DataType
    implements SubDataType {
        private final String catalogueReference;
        private boolean rightAlignment = false;
        private DataType dataType;

        public Catalogue(String catalogueReference, boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
            this.catalogueReference = catalogueReference;
        }

        public Catalogue(String catalogueReference, boolean notNull, boolean editable, DataType dataType) {
            super(notNull, false, editable, null, null);
            this.catalogueReference = catalogueReference;
            this.dataType = dataType;
        }

        public Catalogue(String catalogueReference, boolean notNull, boolean editable, boolean rightAlignment) {
            this(catalogueReference, notNull, editable);
            this.rightAlignment = rightAlignment;
        }

        public Catalogue(String catalogueReference, boolean notNull, boolean editable, boolean rightAlignment, DataType dataType) {
            this(catalogueReference, notNull, editable);
            this.rightAlignment = rightAlignment;
            this.dataType = dataType;
        }

        public Catalogue(String catalogueReference, boolean notNull, boolean unique, String field, String table) {
            super(notNull, unique, true, field, table);
            this.catalogueReference = catalogueReference;
        }

        @Override
        public void setDataType(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public DataType getDataType() {
            return this.dataType;
        }

        public boolean isRightAlignment() {
            return this.rightAlignment;
        }

        public void setRightAlignment(boolean rightAlignment) {
            this.rightAlignment = rightAlignment;
        }

        public String getCatalogueReference() {
            return this.catalogueReference;
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            return super.isValidValue(value);
        }

        @Override
        public String toString() {
            return "Katalog";
        }
    }

    public static class DateType
    extends DataType {
        GregorianCalendar min = null;
        GregorianCalendar max = null;

        public DateType(boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            ValidationResult result = super.isValidValue(value);
            if (result.getValidationResult() == Validation.OK) {
                if (value instanceof Date) {
                    Date date = (Date)value;
                    GregorianCalendar val = new GregorianCalendar(date.getYear() + 1900, date.getMonth(), date.getDate());
                    if (this.min != null && val.after(this.min) || this.max != null && val.after(this.max)) {
                        result = new ValidationResult(Validation.WRONG_RANGE);
                    }
                } else if (value != null) {
                    LOG.warn((Object)("Enexpected data type to check " + value.getClass().getName()));
                }
            }
            return result;
        }

        public void setRange(GregorianCalendar min, GregorianCalendar max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public String range(String name) {
            if (this.min != null && this.max != null) {
                return name + " >= " + this.toDateString(this.min) + " und " + name + " <= " + this.toDateString(this.max);
            }
            if (this.min != null) {
                return name + " >= " + this.toDateString(this.min);
            }
            if (this.max != null) {
                return name + " <= " + this.toDateString(this.max);
            }
            return "";
        }

        @Override
        public String toString() {
            return "Date";
        }

        private String toDateString(GregorianCalendar cal) {
            return cal.get(5) + "." + (cal.get(2) + 1) + "." + cal.get(1);
        }
    }

    public static class Time
    extends Varchar {
        private SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");

        public Time(boolean notNull, boolean editable) {
            super(8, notNull, editable);
            this.formatter.setLenient(false);
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            ValidationResult result = super.isValidValue(value);
            if (value != null && !value.equals("") && result.getValidationResult() == Validation.OK && value instanceof String) {
                try {
                    this.formatter.parse((String)value);
                }
                catch (ParseException e) {
                    result = new ValidationResult(Validation.WRONG_DATA_TYPE);
                }
            }
            return result;
        }

        @Override
        public String toString() {
            return "Time (00:00:00...23:59:59)";
        }
    }

    public static class DateTime
    extends DataType {
        public DateTime(boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            return super.isValidValue(value);
        }

        @Override
        public String toString() {
            return "Timestamp";
        }
    }

    protected static class Geom
    extends DataType {
        public Geom(boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            return super.isValidValue(value);
        }

        @Override
        public String toString() {
            return "Geometry";
        }
    }

    public static class WbblLink
    extends Link {
        private String wbblPath;

        public WbblLink(String wbblPath, int maxLength, boolean notNull) {
            super(maxLength, notNull);
            this.wbblPath = wbblPath;
            this.setRightAlignment(true);
        }

        public WbblLink(String wbblPath, int maxLength, boolean notNull, boolean editable) {
            super(maxLength, notNull, editable, true);
            this.wbblPath = wbblPath;
        }

        public WbblLink(String wbblPath, int maxLength, boolean notNull, boolean unique, String field, String table) {
            super(maxLength, notNull, unique, field, table);
            this.wbblPath = wbblPath;
            this.setRightAlignment(true);
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            Object val = value;
            if (value == null || value.equals("")) {
                val = null;
            }
            ValidationResult result = super.isValidValue(val);
            if (val != null && !val.equals("") && result.getValidationResult() == Validation.OK && !WatergisDefaultRuleSet.checkDocumentExistenceOnWebDav(this.wbblPath, WatergisDefaultRuleSet.addExtension(val.toString(), "pdf"))) {
                result = new ValidationResult(Validation.WBBL_NOT_ACCESSIBLE);
            }
            return result;
        }
    }

    public static class Link
    extends Varchar {
        private boolean rightAlignment = false;

        public Link(int maxLength, boolean notNull) {
            super(maxLength, notNull);
        }

        public Link(int maxLength, boolean notNull, boolean editable) {
            super(maxLength, notNull, editable);
        }

        public Link(int maxLength, boolean notNull, boolean editable, boolean rightAlignment) {
            this(maxLength, notNull, editable);
            this.rightAlignment = rightAlignment;
        }

        public Link(int maxLength, boolean notNull, boolean unique, String field, String table) {
            super(maxLength, notNull, unique, field, table);
        }

        public boolean isRightAlignment() {
            return this.rightAlignment;
        }

        public void setRightAlignment(boolean rightAlignment) {
            this.rightAlignment = rightAlignment;
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            ValidationResult result = super.isValidValue(value);
            return result;
        }

        @Override
        public String toString() {
            return "Link(" + this.getMaxLength() + ")";
        }
    }

    public static class Varchar
    extends DataType {
        private final int maxLength;
        private String[] allowedValues = null;

        public Varchar(int maxLength, boolean notNull) {
            super(notNull, false, true, null, null);
            this.maxLength = maxLength;
        }

        public Varchar(int maxLength, boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
            this.maxLength = maxLength;
        }

        public Varchar(int maxLength, boolean notNull, boolean editable, String[] allowedValues) {
            super(notNull, false, editable, null, null);
            this.maxLength = maxLength;
            this.allowedValues = allowedValues;
        }

        public Varchar(int maxLength, boolean notNull, boolean unique, String field, String table) {
            super(notNull, unique, true, field, table);
            this.maxLength = maxLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            ValidationResult result = super.isValidValue(value);
            if (result.getValidationResult() == Validation.OK) {
                if (value instanceof String) {
                    String stringValue = (String)value;
                    if (this.allowedValues != null) {
                        boolean valueFound = false;
                        for (String val : this.allowedValues) {
                            if (!val.equals(value)) continue;
                            valueFound = true;
                            break;
                        }
                        if (!valueFound) {
                            result = new ValidationResult(Validation.NOT_IN_VALUE_TABLE, this.allowedValues);
                        }
                    } else if (stringValue.length() > this.maxLength) {
                        result = new ValidationResult(Validation.SIZE_CORRECTION, true, stringValue.substring(0, this.maxLength));
                    }
                } else if (value != null) {
                    result = new ValidationResult(Validation.WRONG_DATA_TYPE);
                }
            }
            return result;
        }

        @Override
        public String toString() {
            return "Varchar(" + this.maxLength + ")";
        }
    }

    public static class Bool
    extends DataType {
        public Bool(boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            ValidationResult result = super.isValidValue(value);
            return result;
        }

        @Override
        public String toString() {
            return "Boolean";
        }
    }

    public static class BooleanAsInteger
    extends DataType
    implements SubDataType {
        public BooleanAsInteger(boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            ValidationResult result = super.isValidValue(value);
            if (result.getValidationResult() == Validation.OK) {
                if (value instanceof String || value instanceof Number) {
                    String stringValue = value.toString();
                    try {
                        int val = Integer.parseInt(stringValue);
                        if (val != 1 && val != 0) {
                            result = new ValidationResult(Validation.NOT_BINARY);
                        }
                    }
                    catch (NumberFormatException e) {
                        result = new ValidationResult(Validation.NOT_BINARY);
                    }
                } else if (value != null) {
                    result = new ValidationResult(Validation.WRONG_DATA_TYPE);
                }
            }
            return result;
        }

        @Override
        public String toString() {
            return "Numeric(1,0)";
        }

        @Override
        public void setDataType(DataType dataType) {
        }

        @Override
        public DataType getDataType() {
            return new Numeric(1, 0, false);
        }
    }

    public static class Numeric
    extends DataType {
        private final int precision;
        private final int scale;
        private Double min = null;
        private Double max = null;
        private boolean minEqualsAllowd = true;
        private boolean maxEqualsAllowd = true;
        private boolean showDecimalsOnlyIfExists = false;

        public Numeric(int precision, int scale, boolean notNull) {
            super(notNull, false, true, null, null);
            this.precision = precision;
            this.scale = scale;
        }

        public Numeric(int precision, int scale, boolean notNull, boolean editable) {
            super(notNull, false, editable, null, null);
            this.precision = precision;
            this.scale = scale;
        }

        public Numeric(int precision, int scale, boolean notNull, boolean editable, boolean showDecimalsOnlyIfExists) {
            this(precision, scale, notNull, editable);
            this.showDecimalsOnlyIfExists = showDecimalsOnlyIfExists;
        }

        public Numeric(int precision, int scale, boolean notNull, boolean editable, double min, double max) {
            super(notNull, false, editable, null, null);
            this.precision = precision;
            this.scale = scale;
            this.min = min;
            this.max = max;
        }

        public Numeric(int precision, int scale, boolean notNull, boolean unique, String field, String table) {
            super(notNull, unique, true, field, table);
            this.precision = precision;
            this.scale = scale;
        }

        public boolean isShowDecimalsOnlyIfExists() {
            return this.showDecimalsOnlyIfExists;
        }

        public void setShowDecimalsOnlyIfExists(boolean showDecimalsOnlyIfExists) {
            this.showDecimalsOnlyIfExists = showDecimalsOnlyIfExists;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        @Override
        public ValidationResult isValidValue(Object value) {
            ValidationResult result = super.isValidValue(value);
            if (result.getValidationResult() == Validation.OK) {
                if (value instanceof String || value instanceof Number) {
                    boolean isDouble = value instanceof Double;
                    boolean isInteger = value instanceof Integer;
                    boolean isLong = value instanceof Long;
                    boolean isFloat = value instanceof Float;
                    String numberString = value.toString();
                    BigDecimal bd = null;
                    try {
                        bd = new BigDecimal(numberString);
                        bd = bd.stripTrailingZeros();
                        int tmpScale = bd.scale();
                        int digitsOnTheLeft = bd.precision() - tmpScale;
                        if (tmpScale < 0) {
                            tmpScale = 0;
                        }
                        if (digitsOnTheLeft > this.precision - this.scale) {
                            result = new ValidationResult(Validation.OUT_OF_SIZE);
                        } else if (tmpScale > this.scale) {
                            Object roundedValue = isDouble ? Double.valueOf(bd.round(new MathContext(digitsOnTheLeft + this.scale, RoundingMode.HALF_UP)).doubleValue()) : (isInteger ? Integer.valueOf(bd.round(new MathContext(digitsOnTheLeft + this.scale, RoundingMode.HALF_UP)).intValue()) : (isLong ? Long.valueOf(bd.round(new MathContext(digitsOnTheLeft + this.scale, RoundingMode.HALF_UP)).longValue()) : (isFloat ? Float.valueOf(bd.round(new MathContext(digitsOnTheLeft + this.scale, RoundingMode.HALF_UP)).floatValue()) : bd.round(new MathContext(digitsOnTheLeft + this.scale, RoundingMode.HALF_UP)).toString())));
                            result = new ValidationResult(Validation.SIZE_CORRECTION, true, roundedValue);
                        }
                    }
                    catch (NumberFormatException e) {
                        result = new ValidationResult(Validation.WRONG_DATA_TYPE);
                    }
                    if (bd != null && result.getValidationResult() == Validation.OK) {
                        if (this.min != null && (this.minEqualsAllowd && bd.doubleValue() < this.min || !this.minEqualsAllowd && bd.doubleValue() <= this.min)) {
                            result = new ValidationResult(Validation.WRONG_RANGE);
                        }
                        if (this.max != null && (this.maxEqualsAllowd && bd.doubleValue() > this.max || !this.maxEqualsAllowd && bd.doubleValue() >= this.max)) {
                            result = new ValidationResult(Validation.WRONG_RANGE);
                        }
                    }
                } else if (value != null) {
                    result = new ValidationResult(Validation.WRONG_DATA_TYPE);
                }
            }
            return result;
        }

        @Override
        public String toString() {
            return "Numeric(" + this.precision + "," + this.scale + ")";
        }

        @Override
        public String range(String name) {
            String maxOp;
            String minOp = this.minEqualsAllowd ? " >= " : " > ";
            String string = maxOp = this.maxEqualsAllowd ? " <= " : " < ";
            if (this.min != null && this.max != null) {
                if (this.scale == 0) {
                    return name + minOp + this.min.intValue() + " und " + name + maxOp + this.max.intValue();
                }
                return name + minOp + this.min + " und " + name + maxOp + this.max;
            }
            if (this.min != null) {
                if (this.scale == 0) {
                    return name + minOp + this.min.intValue();
                }
                return name + minOp + this.min;
            }
            if (this.max != null) {
                if (this.scale == 0) {
                    return name + maxOp + this.max.intValue();
                }
                return name + maxOp + this.max;
            }
            return "";
        }

        public Double getMin() {
            return this.min;
        }

        public void setMin(Double min) {
            this.min = min;
        }

        public Double getMax() {
            return this.max;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public void setRange(Double min, Double max) {
            this.min = min;
            this.max = max;
        }

        public boolean isMinEqualsAllowd() {
            return this.minEqualsAllowd;
        }

        public void setMinEqualsAllowd(boolean minEqualsAllowd) {
            this.minEqualsAllowd = minEqualsAllowd;
        }

        public boolean isMaxEqualsAllowd() {
            return this.maxEqualsAllowd;
        }

        public void setMaxEqualsAllowd(boolean maxEqualsAllowd) {
            this.maxEqualsAllowd = maxEqualsAllowd;
        }
    }

    public static abstract class DataType {
        private final boolean notNull;
        private final boolean unique;
        private final boolean editable;
        private final String field;
        private final String table;

        public DataType(boolean notNull, boolean unique, boolean editable, String field, String table) {
            this.notNull = notNull;
            this.unique = unique;
            this.field = field;
            this.table = table;
            this.editable = editable;
        }

        public boolean isNotNull() {
            return this.notNull;
        }

        public ValidationResult isValidValue(Object value) {
            if (this.notNull && WatergisDefaultRuleSet.isValueEmpty(value)) {
                return new ValidationResult(Validation.NULL);
            }
            return new ValidationResult(Validation.OK);
        }

        public boolean isUnique() {
            return this.unique;
        }

        public String getField() {
            return this.field;
        }

        public String getTable() {
            return this.table;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public abstract String toString();

        public String range(String name) {
            return "";
        }
    }

    public static interface SubDataType {
        public void setDataType(DataType var1);

        public DataType getDataType();
    }

    static enum Validation {
        OK,
        NULL,
        WRONG_DATA_TYPE,
        OUT_OF_SIZE,
        SIZE_CORRECTION,
        WRONG_RANGE,
        WBBL_NOT_ACCESSIBLE,
        NOT_BINARY,
        NOT_IN_VALUE_TABLE;

    }
}

