/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class WrSgKsgRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(WrSgKsgRuleSet.class);

    public WrSgKsgRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ksg_name", new WatergisDefaultRuleSet.Varchar(75, false, true));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(WrSgKsgRuleSet.getWbblPath(), 10, false, true));
        this.typeMap.put("pruef_alk", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("src_erfass", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("src_quelle", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("info", new WatergisDefaultRuleSet.Link(250, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("geom") && !columnName.equals("id") && !columnName.equals("flaeche");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("info")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("info")) {
            if (value instanceof String && clickCount == 1) {
                try {
                    URL u = new URL(value.toString());
                    try {
                        BrowserLauncher.openURL((String)u.toString());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (columnName.equals("wbbl") && value instanceof String && clickCount == 1) {
            WrSgKsgRuleSet.downloadDocumentFromWebDav(WrSgKsgRuleSet.getWbblPath(), WrSgKsgRuleSet.addExtension(value.toString(), "pdf"));
        }
    }
}

