/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.check;

import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.check.BackgroundCheckEvent;
import de.cismet.watergis.check.BackgroundCheckListener;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import de.cismet.watergis.gui.actions.checks.AusbauCheckAction;
import de.cismet.watergis.gui.actions.checks.BasicRoutesCheckAction;
import de.cismet.watergis.gui.actions.checks.BauwerkeCheckAction;
import de.cismet.watergis.gui.actions.checks.GWKConnectionCheckAction;
import de.cismet.watergis.gui.actions.checks.LawaCheckAction;
import de.cismet.watergis.gui.actions.checks.SonstigeCheckAction;
import de.cismet.watergis.gui.actions.checks.VerwaltungCheckAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CheckBackgroundWorker {
    private static final Logger LOG = Logger.getLogger(CheckBackgroundWorker.class);
    private static final int THREADS = 1;
    private final AbstractCheckAction[] CHECKS = new AbstractCheckAction[AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren") ? 7 : 5];
    private final ThreadPoolExecutor threadExecutor;
    private final List<BackgroundCheckListener> listeners = new ArrayList<BackgroundCheckListener>();

    public CheckBackgroundWorker() {
        this.CHECKS[0] = new BasicRoutesCheckAction();
        this.CHECKS[1] = new VerwaltungCheckAction();
        this.CHECKS[2] = new AusbauCheckAction();
        this.CHECKS[3] = new BauwerkeCheckAction();
        this.CHECKS[4] = new SonstigeCheckAction();
        if (AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
            this.CHECKS[5] = new GWKConnectionCheckAction();
            this.CHECKS[6] = new LawaCheckAction();
        }
        this.threadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void addBackgroundCheckListener(BackgroundCheckListener l) {
        this.listeners.add(l);
    }

    public boolean removeBackgroundCheckListener(BackgroundCheckListener l) {
        return this.listeners.remove(l);
    }

    public void fireBackgroundCheckListener(BackgroundCheckEvent e) {
        for (BackgroundCheckListener l : this.listeners) {
            l.checkComplete(e);
        }
    }

    public AbstractCheckAction[] getChecks() {
        return this.CHECKS;
    }

    public void start() {
        for (int index = 0; index < this.CHECKS.length; ++index) {
            this.threadExecutor.submit(new ActionExecutor(index, this.CHECKS[index], this));
        }
    }

    private class ActionExecutor
    implements Runnable {
        private final CheckBackgroundWorker parent;
        private final AbstractCheckAction check;
        private final int index;

        public ActionExecutor(int index, AbstractCheckAction check, CheckBackgroundWorker parent) {
            this.check = check;
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void run() {
            try {
                AbstractCheckResult result = this.check.startBackgroundCheck();
                BackgroundCheckEvent e = new BackgroundCheckEvent(this.index, this.check, result, (Object)this.parent);
                CheckBackgroundWorker.this.fireBackgroundCheckListener(e);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error during background check.", (Throwable)ex);
                BackgroundCheckEvent e = new BackgroundCheckEvent(this.index, this.check, ex, (Object)this.parent);
                CheckBackgroundWorker.this.fireBackgroundCheckListener(e);
            }
        }
    }
}

