/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui;

import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.LinearReferencedPointMarkPHandle;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.panels.Photo;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PLocator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PhotoAngleListener
extends PBasicInputEventHandler {
    private static final float CURSOR_PANEL_TRANSPARENCY = 1.0f;
    public static final String MODE = "FOTO_ANGLE_LISTENER";
    protected MappingComponent mc;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private float cursorX = Float.MIN_VALUE;
    private float cursorY = Float.MIN_VALUE;
    private final Collection<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public PhotoAngleListener(MappingComponent mc) {
        this.mc = mc;
        PLocator l = new PLocator(){

            public double locateX() {
                return PhotoAngleListener.this.cursorX;
            }

            public double locateY() {
                return PhotoAngleListener.this.cursorY;
            }
        };
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        return this.listeners.remove(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    public void mouseDragged(PInputEvent event) {
    }

    public void mouseReleased(PInputEvent event) {
    }

    public void mouseClicked(PInputEvent event) {
        block7: {
            CidsLayerFeature feature;
            if (this.mc.getInteractionMode().equals(MODE) && (feature = Photo.selectedFeature) != null) {
                double dy;
                double pointX = feature.getGeometry().getCoordinate().x;
                double pointY = feature.getGeometry().getCoordinate().y;
                double mouseX = AppBroker.getInstance().getMappingComponent().getWtst().getWorldX(event.getPosition().getX());
                double mouseY = AppBroker.getInstance().getMappingComponent().getWtst().getWorldY(event.getPosition().getY());
                double dx = mouseX - pointX;
                double scalar = dy = mouseY - pointY;
                double prodLaenge = Math.pow(dx * dx + dy * dy, 0.5) * Math.pow(1.0, 0.5);
                double angle = Math.acos(scalar / prodLaenge);
                if (dx > 0.0) {
                    angle = Math.PI * 2 - angle;
                }
                angle = Math.PI * 2 - angle;
                if ((angle = angle * 360.0 / (Math.PI * 2)) < 0.0) {
                    angle += 360.0;
                }
                try {
                    feature.getBean().setProperty("winkel", (Object)((double)Math.round(angle * 100.0) / 100.0));
                    feature.setProperty("winkel", (Object)((double)Math.round(angle * 100.0) / 100.0));
                    AbstractFeatureService service = feature.getLayerProperties().getFeatureService();
                    if (service == null) break block7;
                    List pfeatureList = service.getPNode().getChildrenReference();
                    for (PFeature pf : pfeatureList) {
                        Feature f = pf.getFeature();
                        if (!(f instanceof FeatureServiceFeature) || ((FeatureServiceFeature)f).getId() != feature.getId()) continue;
                        ((FeatureServiceFeature)f).setProperty("winkel", (Object)((double)Math.round(angle * 100.0) / 100.0));
                        pf.visualize();
                        pf.refreshDesign();
                        PFeature mapFeature = (PFeature)pf.getViewer().getPFeatureHM().get(feature);
                        if (mapFeature != null) {
                            ((FeatureServiceFeature)mapFeature.getFeature()).setProperty("winkel", (Object)((double)Math.round(angle * 100.0) / 100.0));
                            mapFeature.visualize();
                            mapFeature.refreshDesign();
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Cannot set winkel property", (Throwable)e);
                }
            }
        }
    }

    public PLayer getPLayer() {
        return this.mc.getHandleLayer();
    }

    private void showToolTip(PNode father, PPath child, boolean show) {
        boolean found = false;
        for (Object o : father.getChildrenReference()) {
            if (o == null || !o.equals(child)) continue;
            found = true;
            break;
        }
        if (!found && show) {
            father.addChild((PNode)child);
        }
        if (found && !show) {
            father.removeChild((PNode)child);
        }
    }

    public void mouseMoved(PInputEvent event) {
        if (this.mc.getInteractionMode().equals(MODE)) {
            // empty if block
        }
    }

    class PointMark {
        private double position;
        private LinearReferencedPointMarkPHandle pHandle;

        PointMark(double position, LinearReferencedPointMarkPHandle handle) {
            this.pHandle = handle;
            this.position = position;
        }

        public double getPosition() {
            return this.position;
        }

        public LinearReferencedPointMarkPHandle getPHandle() {
            return this.pHandle;
        }
    }
}

