/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.watergis.gui.PhotoInfoPHandle;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PLocator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PhotoInfoListener
extends PBasicInputEventHandler {
    private static final float CURSOR_PANEL_TRANSPARENCY = 1.0f;
    public static final String MODE = "FOTO_INFO_LISTENER";
    protected MappingComponent mc;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private float cursorX = Float.MIN_VALUE;
    private float cursorY = Float.MIN_VALUE;
    private final PhotoInfoPHandle cursorPHandle;
    private final Collection<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public PhotoInfoListener(MappingComponent mc) {
        this.mc = mc;
        PLocator l = new PLocator(){

            public double locateX() {
                return PhotoInfoListener.this.cursorX;
            }

            public double locateY() {
                return PhotoInfoListener.this.cursorY;
            }
        };
        this.cursorPHandle = new PhotoInfoPHandle(l, mc);
        this.cursorPHandle.setInfoPanelTransparency(1.0f);
        this.cursorPHandle.setPaint(null);
    }

    public void setPhotoSize() {
        this.cursorPHandle.setPhotoSize();
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        return this.listeners.remove(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    public void mouseDragged(PInputEvent event) {
    }

    public void mouseReleased(PInputEvent event) {
    }

    public void mouseClicked(PInputEvent event) {
    }

    public PLayer getPLayer() {
        return this.mc.getHandleLayer();
    }

    private void showCursor(boolean show) {
        this.showToolTip((PNode)this.getPLayer(), this.cursorPHandle, show);
    }

    private void showToolTip(PNode father, PPath child, boolean show) {
        boolean found = false;
        for (Object o : father.getChildrenReference()) {
            if (o == null || !o.equals(child)) continue;
            found = true;
            break;
        }
        if (!found && show) {
            father.addChild((PNode)child);
        }
        if (found && !show) {
            father.removeChild((PNode)child);
        }
    }

    public void mouseMoved(PInputEvent event) {
        if (this.mc.getInteractionMode().equals(MODE)) {
            this.updateCursor(event);
            this.cursorPHandle.setMarkPosition();
        }
    }

    private void updateCursor(PInputEvent event) {
        List c = PFeatureTools.getValidObjectsUnderPointer((PInputEvent)event, (Class[])new Class[]{PFeature.class}, (double)0.001);
        boolean cursorIsVisible = false;
        ArrayList<CidsLayerFeature> fotoFeature = new ArrayList<CidsLayerFeature>();
        for (Object o : c) {
            CidsLayerFeature cFeature;
            PFeature feature;
            if (!(o instanceof PFeature) || !((feature = (PFeature)o).getFeature() instanceof CidsLayerFeature) || !((cFeature = (CidsLayerFeature)feature.getFeature()).getLayerProperties().getFeatureService() instanceof CidsLayer) || !((CidsLayer)cFeature.getLayerProperties().getFeatureService()).getMetaClass().getName().equalsIgnoreCase("foto")) continue;
            cursorIsVisible = true;
            fotoFeature.add(cFeature);
        }
        this.showCursor(cursorIsVisible);
        this.cursorPHandle.setVisible(cursorIsVisible);
        if (fotoFeature != null) {
            this.cursorPHandle.setFeature(fotoFeature);
        }
        this.cursorX = (float)event.getPosition().getX();
        this.cursorY = (float)event.getPosition().getY();
    }
}

