/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.AbstractWMS;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.LocalConfigAction;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import org.openide.util.NbBundle;

public class AdoptLocalConfigFileAction
extends AbstractAction {
    File file;

    public AdoptLocalConfigFileAction(File file) {
        String tooltip = NbBundle.getMessage(LocalConfigAction.class, (String)"LocalConfigAction.toolTipText");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-file.png"));
        this.putValue("SmallIcon", icon);
        this.file = file;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        AppBroker.getInstance().getRecentlyOpenedFilesList().saveFilenames();
        String filename = this.file.getAbsolutePath();
        final MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
        ConfigurationManager configurationManager = AppBroker.getConfigManager();
        mappingComponent.getRasterServiceLayer().removeAllChildren();
        AppBroker.getInstance().getWatergisApp().setCurrentLayoutFile(filename);
        configurationManager.configure(filename);
        String layoutFilepath = FilenameUtils.getFullPath((String)filename) + FilenameUtils.getBaseName((String)filename) + ".layout";
        AppBroker.getInstance().getWatergisApp().loadLayout(layoutFilepath);
        AppBroker.getInstance().switchMapMode(mappingComponent.getInteractionMode());
        AppBroker.getInstance().getRecentlyOpenedFilesList().addFile(this.file);
        String projectName = this.file.getName();
        if (projectName.contains(".")) {
            projectName = projectName.substring(0, projectName.indexOf("."));
        }
        EventQueue.invokeLater(new Thread("Initialise layers"){

            @Override
            public void run() {
                TreeMap map = ((ActiveLayerModel)mappingComponent.getMappingModel()).getMapServices();
                if (map != null && map.keySet() != null) {
                    for (Integer key : map.keySet()) {
                        MapService service = (MapService)map.get((int)key);
                        if (!(service instanceof AbstractWMS) || ((AbstractWMS)service).isVisible()) continue;
                        ((AbstractWMS)service).setSize(mappingComponent.getHeight(), mappingComponent.getWidth());
                    }
                }
            }
        });
        AppBroker.getInstance().getWatergisApp().setTitle("FIS Gew\u00e4sser \u2013 Projekt: " + projectName);
        Thread t = new Thread("check layers"){

            @Override
            public void run() {
                AppBroker.getInstance().getWatergisApp().checkMapConfiguration(AdoptLocalConfigFileAction.this.file);
            }
        };
        t.start();
    }

    public void adoptConfigFile() {
        this.actionPerformed(null);
    }
}

