/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanel;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanelListener;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class InfoWindowAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(InfoWindowAction.class);
    private static JDialog dialog = null;
    private FeatureInfoPanel featureInfoPanel;
    private boolean dialogOnly = false;

    public InfoWindowAction() {
        String tooltip = NbBundle.getMessage(InfoWindowAction.class, (String)"InfoWindowAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(InfoWindowAction.class, (String)"InfoWindowAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(InfoWindowAction.class, (String)"InfoWindowAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-info-sign.png"));
        this.putValue("SmallIcon", icon);
    }

    public InfoWindowAction(boolean dialogOnly) {
        this.dialogOnly = dialogOnly;
        String tooltip = NbBundle.getMessage(InfoWindowAction.class, (String)"InfoWindowAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(InfoWindowAction.class, (String)"InfoWindowAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(InfoWindowAction.class, (String)"InfoWindowAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-webpage.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.initDialog();
        if (!this.dialogOnly) {
            AppBroker.getInstance().getMappingComponent().setInteractionMode("FEATURE_INFO_MULTI_GEOM");
            this.putValue("SwingSelectedKey", Boolean.TRUE);
        }
        StaticSwingTools.showDialog((JDialog)dialog);
    }

    private void initDialog() {
        if (dialog == null) {
            dialog = new JDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(InfoWindowAction.class, (String)"InfoWindowAction.actionPerformed.JDialog"), false);
            this.featureInfoPanel = new FeatureInfoPanel(AppBroker.getInstance().getMappingComponent(), (ThemeLayerWidget)AppBroker.getInstance().getComponent(ComponentName.TREE));
            dialog.add((Component)this.featureInfoPanel);
            dialog.setAlwaysOnTop(true);
            dialog.setSize(350, 550);
            dialog.setDefaultCloseOperation(0);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (InfoWindowAction.this.featureInfoPanel.dispose()) {
                        dialog.setVisible(false);
                    }
                    AppBroker.getInstance().getMappingComponent().setInteractionMode("ZOOM");
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    this.windowClosing(e);
                }
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void showDialog() {
        this.initDialog();
        StaticSwingTools.showDialog((JDialog)dialog);
    }

    public void showAllFeature() {
        this.featureInfoPanel.showAllFeatures();
    }

    public void addFeatureInfoPanelListener(FeatureInfoPanelListener listener) {
        if (this.featureInfoPanel != null) {
            this.featureInfoPanel.addFeatureInfoPanelListeners(listener);
        }
    }

    public void removeFeatureInfoPanelListener(FeatureInfoPanelListener listener) {
        if (this.featureInfoPanel != null) {
            this.featureInfoPanel.removeFeatureInfoPanelListeners(listener);
        }
    }

    public void dispose() {
        if (this.featureInfoPanel != null) {
            this.featureInfoPanel.dispose();
        }
    }
}

