/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.WatergisApp;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.openide.util.NbBundle;

public class IntermediateSaveAction
extends AbstractAction {
    public IntermediateSaveAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-editalt.png");
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("ShortDescription", NbBundle.getMessage(IntermediateSaveAction.class, (String)"IntermediateSaveAction.toolTipText"));
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(NbBundle.getMessage(IntermediateSaveAction.class, (String)"IntermediateSaveAction.mnemonic")).getKeyCode());
        this.putValue("Name", NbBundle.getMessage(IntermediateSaveAction.class, (String)"IntermediateSaveAction.text"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActiveLayerModel model = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        final WatergisApp watergis = AppBroker.getInstance().getWatergisApp();
        final TreeMap map = model.getMapServices();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (MapService mapService : map.values()) {
                    AttributeTable table;
                    AbstractFeatureService service;
                    if (!(mapService instanceof AbstractFeatureService) || !watergis.isProcessingModeActive(service = (AbstractFeatureService)mapService) || (table = watergis.getAttributeTableByFeatureService(service)) == null) continue;
                    table.saveChangedRows(true, false);
                }
            }
        };
        EventQueue.invokeLater(r);
    }
}

