/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.actions.AdoptLocalConfigFileAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class OpenProjectAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(OpenProjectAction.class);

    public OpenProjectAction() {
        String tooltip = NbBundle.getMessage(OpenProjectAction.class, (String)"OpenProjectAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(OpenProjectAction.class, (String)"OpenProjectAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(OpenProjectAction.class, (String)"OpenProjectAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-importfile.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Load Project");
        }
        this.load();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void load() {
        File file = StaticSwingTools.chooseFile((String)WatergisApp.getDIRECTORYPATH_WATERGIS(), (boolean)false, (String[])new String[]{"xml"}, (String)NbBundle.getMessage(OpenProjectAction.class, (String)"OpenProjectAction.load.FileFilter.getDescription.return"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            if (file.exists()) {
                new AdoptLocalConfigFileAction(file).adoptConfigFile();
            } else {
                LOG.warn((Object)"Config file, which the user wanted to open, does not exist.");
                String message = NbBundle.getMessage(OpenProjectAction.class, (String)"OpenProjectAction.load.fileDoesNotExist.message");
                String title = NbBundle.getMessage(OpenProjectAction.class, (String)"OpenProjectAction.load.fileDoesNotExist.title");
                JOptionPane.showMessageDialog((Component)AppBroker.getInstance().getMappingComponent(), message, title, 1);
            }
        }
    }
}

