/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.watergis.broker.AppBroker;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PrintAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(PrintAction.class);

    public PrintAction() {
        String tooltip = NbBundle.getMessage(PrintAction.class, (String)"PrintAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(PrintAction.class, (String)"PrintAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(PrintAction.class, (String)"PrintAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-print.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
        String oldMode = mappingComponent.getInteractionMode();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("oldInteractionMode:" + oldMode));
        }
        mappingComponent.showPrintingSettingsDialog(true);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

