/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.watergis.broker.AppBroker;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SaveToSameFileProjectAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SaveToSameFileProjectAction.class);

    public SaveToSameFileProjectAction() {
        String tooltip = NbBundle.getMessage(SaveToSameFileProjectAction.class, (String)"SaveToSameFileProjectAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SaveToSameFileProjectAction.class, (String)"SaveToSameFileProjectAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(SaveToSameFileProjectAction.class, (String)"SaveToSameFileProjectAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-savetodrive.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Save Project");
        }
        this.save();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void save() {
        String currentLayout = AppBroker.getInstance().getWatergisApp().getCurrentLayoutFile();
        File file = null;
        if (currentLayout != null) {
            file = new File(currentLayout);
        }
        if (file != null) {
            ConfigurationManager configurationManager = AppBroker.getConfigManager();
            String name = file.getAbsolutePath();
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "\u00c4nderungen in der zentralen Datenbank k\u00f6nnen nicht in das lokale Projekt \u00fcbernommen werden (z.B. wegen fehlender Schreibrechte).", "Hinweis", 1);
            }
            configurationManager.writeConfiguration(name);
            AppBroker.getInstance().getRecentlyOpenedFilesList().addFile(file);
            String layoutPath = FilenameUtils.getFullPath((String)name) + FilenameUtils.getBaseName((String)name) + ".layout";
            AppBroker.getInstance().getWatergisApp().saveLayout(layoutPath);
        } else {
            ConfigurationManager configurationManager = AppBroker.getConfigManager();
            configurationManager.writeConfiguration();
        }
    }
}

